/*
 * Decompiled with CFR 0.152.
 */
package org.apache.twill.zookeeper;

import java.util.LinkedList;
import java.util.concurrent.CancellationException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hive.com.google.common.collect.Lists;
import org.apache.hive.com.google.common.util.concurrent.FutureCallback;
import org.apache.hive.com.google.common.util.concurrent.Futures;
import org.apache.hive.com.google.common.util.concurrent.ListenableFuture;
import org.apache.hive.com.google.common.util.concurrent.SettableFuture;
import org.apache.hive.org.apache.zookeeper.KeeperException;
import org.apache.hive.org.apache.zookeeper.WatchedEvent;
import org.apache.hive.org.apache.zookeeper.Watcher;
import org.apache.hive.org.apache.zookeeper.data.Stat;
import org.apache.hive.org.slf4j.Logger;
import org.apache.hive.org.slf4j.LoggerFactory;
import org.apache.twill.common.Cancellable;
import org.apache.twill.common.Threads;
import org.apache.twill.internal.zookeeper.SettableOperationFuture;
import org.apache.twill.zookeeper.NodeChildren;
import org.apache.twill.zookeeper.NodeData;
import org.apache.twill.zookeeper.OperationFuture;
import org.apache.twill.zookeeper.ZKClient;

public final class ZKOperations {
    private static final Logger LOG = LoggerFactory.getLogger(ZKOperations.class);

    public static Cancellable watchData(final ZKClient zkClient, String path, DataCallback callback) {
        final AtomicBoolean cancelled = new AtomicBoolean(false);
        ZKOperations.watchChanges(new Operation<NodeData>(){

            @Override
            public ZKClient getZKClient() {
                return zkClient;
            }

            @Override
            public OperationFuture<NodeData> exec(String path, Watcher watcher) {
                return zkClient.getData(path, watcher);
            }
        }, path, callback, cancelled);
        return new Cancellable(){

            @Override
            public void cancel() {
                cancelled.set(true);
            }
        };
    }

    public static ListenableFuture<String> watchDeleted(ZKClient zkClient, String path) {
        SettableFuture<String> completion = SettableFuture.create();
        ZKOperations.watchDeleted(zkClient, path, completion);
        return completion;
    }

    public static void watchDeleted(final ZKClient zkClient, final String path, final SettableFuture<String> completion) {
        Futures.addCallback(zkClient.exists(path, new Watcher(){

            @Override
            public void process(WatchedEvent event) {
                if (!completion.isDone()) {
                    if (event.getType() == Watcher.Event.EventType.NodeDeleted) {
                        completion.set(path);
                    } else {
                        ZKOperations.watchDeleted(zkClient, path, completion);
                    }
                }
            }
        }), new FutureCallback<Stat>(){

            @Override
            public void onSuccess(Stat result) {
                if (result == null) {
                    completion.set(path);
                }
            }

            @Override
            public void onFailure(Throwable t) {
                completion.setException(t);
            }
        });
    }

    public static Cancellable watchChildren(final ZKClient zkClient, String path, ChildrenCallback callback) {
        final AtomicBoolean cancelled = new AtomicBoolean(false);
        ZKOperations.watchChanges(new Operation<NodeChildren>(){

            @Override
            public ZKClient getZKClient() {
                return zkClient;
            }

            @Override
            public OperationFuture<NodeChildren> exec(String path, Watcher watcher) {
                return zkClient.getChildren(path, watcher);
            }
        }, path, callback, cancelled);
        return new Cancellable(){

            @Override
            public void cancel() {
                cancelled.set(true);
            }
        };
    }

    public static <V> OperationFuture<V> ignoreError(OperationFuture<V> future, final Class<? extends KeeperException> exceptionType, final V errorResult) {
        final SettableOperationFuture resultFuture = SettableOperationFuture.create(future.getRequestPath(), Threads.SAME_THREAD_EXECUTOR);
        Futures.addCallback(future, new FutureCallback<V>(){

            @Override
            public void onSuccess(V result) {
                resultFuture.set(result);
            }

            @Override
            public void onFailure(Throwable t) {
                if (exceptionType.isAssignableFrom(t.getClass())) {
                    resultFuture.set(errorResult);
                } else if (t instanceof CancellationException) {
                    resultFuture.cancel(true);
                } else {
                    resultFuture.setException(t);
                }
            }
        }, Threads.SAME_THREAD_EXECUTOR);
        return resultFuture;
    }

    public static OperationFuture<String> recursiveDelete(final ZKClient zkClient, final String path) {
        final SettableOperationFuture<String> resultFuture = SettableOperationFuture.create(path, Threads.SAME_THREAD_EXECUTOR);
        Futures.addCallback(zkClient.delete(path), new FutureCallback<String>(){
            private final FutureCallback<String> deleteCallback = this;

            @Override
            public void onSuccess(String result) {
                resultFuture.set(result);
            }

            @Override
            public void onFailure(Throwable t) {
                if (!(t instanceof KeeperException.NotEmptyException) && !(t instanceof KeeperException.NoNodeException)) {
                    resultFuture.setException(t);
                    return;
                }
                Futures.addCallback(zkClient.getChildren(path), new FutureCallback<NodeChildren>(){

                    @Override
                    public void onSuccess(NodeChildren result) {
                        final LinkedList<OperationFuture<String>> deleteFutures = Lists.newLinkedList();
                        for (String child : result.getChildren()) {
                            deleteFutures.add(ZKOperations.recursiveDelete(zkClient, path + "/" + child));
                        }
                        Futures.successfulAsList(deleteFutures).addListener(new Runnable(){

                            @Override
                            public void run() {
                                for (OperationFuture deleteFuture : deleteFutures) {
                                    try {
                                        deleteFuture.get();
                                    }
                                    catch (Exception e) {
                                        resultFuture.setException(e.getCause());
                                    }
                                }
                                Futures.addCallback(zkClient.delete(path), deleteCallback, Threads.SAME_THREAD_EXECUTOR);
                            }
                        }, Threads.SAME_THREAD_EXECUTOR);
                    }

                    @Override
                    public void onFailure(Throwable t) {
                        resultFuture.setException(t);
                    }
                }, Threads.SAME_THREAD_EXECUTOR);
            }
        }, Threads.SAME_THREAD_EXECUTOR);
        return resultFuture;
    }

    private static void watchExists(final ZKClient zkClient, final String path, final SettableFuture<String> completion) {
        Futures.addCallback(zkClient.exists(path, new Watcher(){

            @Override
            public void process(WatchedEvent event) {
                if (!completion.isDone()) {
                    ZKOperations.watchExists(zkClient, path, completion);
                }
            }
        }), new FutureCallback<Stat>(){

            @Override
            public void onSuccess(Stat result) {
                if (result != null) {
                    completion.set(path);
                }
            }

            @Override
            public void onFailure(Throwable t) {
                completion.setException(t);
            }
        });
    }

    private static <T> void watchChanges(final Operation<T> operation, final String path, final Callback<T> callback, final AtomicBoolean cancelled) {
        Futures.addCallback(operation.exec(path, new Watcher(){

            @Override
            public void process(WatchedEvent event) {
                if (!cancelled.get()) {
                    ZKOperations.watchChanges(operation, path, callback, cancelled);
                }
            }
        }), new FutureCallback<T>(){

            @Override
            public void onSuccess(T result) {
                if (!cancelled.get()) {
                    callback.updated(result);
                }
            }

            @Override
            public void onFailure(Throwable t) {
                if (t instanceof KeeperException && ((KeeperException)t).code() == KeeperException.Code.NONODE) {
                    final SettableFuture existCompletion = SettableFuture.create();
                    existCompletion.addListener(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                if (!cancelled.get()) {
                                    ZKOperations.watchChanges(operation, (String)existCompletion.get(), callback, cancelled);
                                }
                            }
                            catch (Exception e) {
                                LOG.error("Failed to watch children for path " + path, e);
                            }
                        }
                    }, Threads.SAME_THREAD_EXECUTOR);
                    ZKOperations.watchExists(operation.getZKClient(), path, existCompletion);
                    return;
                }
                LOG.error("Failed to watch data for path " + path + " " + t, t);
            }
        });
    }

    private ZKOperations() {
    }

    private static interface Operation<T> {
        public ZKClient getZKClient();

        public OperationFuture<T> exec(String var1, Watcher var2);
    }

    public static interface ChildrenCallback
    extends Callback<NodeChildren> {
        @Override
        public void updated(NodeChildren var1);
    }

    public static interface DataCallback
    extends Callback<NodeData> {
        @Override
        public void updated(NodeData var1);
    }

    public static interface Callback<T> {
        public void updated(T var1);
    }
}

