/*
 * Decompiled with CFR 0.152.
 */
package org.apache.twill.zookeeper;

import java.util.concurrent.TimeUnit;
import org.apache.hive.com.google.common.base.Preconditions;
import org.apache.twill.zookeeper.RetryStrategy;

public final class RetryStrategies {
    public static RetryStrategy noRetry() {
        return new RetryStrategy(){

            @Override
            public long nextRetry(int failureCount, long startTime, RetryStrategy.OperationType type, String path) {
                return -1L;
            }
        };
    }

    public static RetryStrategy limit(final int limit, final RetryStrategy strategy) {
        Preconditions.checkArgument(limit >= 0, "limit must be >= 0");
        return new RetryStrategy(){

            @Override
            public long nextRetry(int failureCount, long startTime, RetryStrategy.OperationType type, String path) {
                return failureCount <= limit ? strategy.nextRetry(failureCount, startTime, type, path) : -1L;
            }
        };
    }

    public static RetryStrategy fixDelay(final long delay, final TimeUnit delayUnit) {
        Preconditions.checkArgument(delay >= 0L, "delay must be >= 0");
        return new RetryStrategy(){

            @Override
            public long nextRetry(int failureCount, long startTime, RetryStrategy.OperationType type, String path) {
                return TimeUnit.MILLISECONDS.convert(delay, delayUnit);
            }
        };
    }

    public static RetryStrategy exponentialDelay(final long baseDelay, final long maxDelay, final TimeUnit delayUnit) {
        Preconditions.checkArgument(baseDelay >= 0L, "base delay must be >= 0");
        Preconditions.checkArgument(maxDelay >= 0L, "max delay must be >= 0");
        return new RetryStrategy(){

            @Override
            public long nextRetry(int failureCount, long startTime, RetryStrategy.OperationType type, String path) {
                long power = failureCount > 64 ? Long.MAX_VALUE : 1L << failureCount - 1;
                long delay = Math.min(baseDelay * power, maxDelay);
                delay = delay < 0L ? maxDelay : delay;
                return TimeUnit.MILLISECONDS.convert(delay, delayUnit);
            }
        };
    }

    public static RetryStrategy timeLimit(long maxElapseTime, TimeUnit timeUnit, final RetryStrategy strategy) {
        Preconditions.checkArgument(maxElapseTime >= 0L, "max elapse time must be >= 0");
        final long maxElapseMs = TimeUnit.MILLISECONDS.convert(maxElapseTime, timeUnit);
        return new RetryStrategy(){

            @Override
            public long nextRetry(int failureCount, long startTime, RetryStrategy.OperationType type, String path) {
                long elapseTime = System.currentTimeMillis() - startTime;
                return elapseTime <= maxElapseMs ? strategy.nextRetry(failureCount, startTime, type, path) : -1L;
            }
        };
    }

    private RetryStrategies() {
    }
}

