/*
 * Decompiled with CFR 0.152.
 */
package org.apache.twill.internal.zookeeper;

import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.hive.com.google.common.base.Preconditions;
import org.apache.hive.org.apache.zookeeper.WatchedEvent;
import org.apache.hive.org.apache.zookeeper.Watcher;
import org.apache.hive.org.apache.zookeeper.ZooKeeper;

public final class KillZKSession {
    private KillZKSession() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void kill(ZooKeeper client, String connectionString, int maxMs) throws IOException, InterruptedException {
        final CountDownLatch latch = new CountDownLatch(1);
        try (ZooKeeper zk = new ZooKeeper(connectionString, maxMs, new Watcher(){

            @Override
            public void process(WatchedEvent event) {
                if (event.getState() == Watcher.Event.KeeperState.SyncConnected) {
                    latch.countDown();
                }
            }
        }, client.getSessionId(), client.getSessionPasswd());){
            Preconditions.checkState(latch.await(maxMs, TimeUnit.MILLISECONDS), "Fail to kill ZK connection.");
        }
    }
}

