/*
 * Decompiled with CFR 0.152.
 */
package org.apache.twill.internal.zookeeper;

import java.io.File;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.concurrent.Executor;
import org.apache.hive.com.google.common.base.Preconditions;
import org.apache.hive.com.google.common.base.Throwables;
import org.apache.hive.com.google.common.io.Files;
import org.apache.hive.com.google.common.util.concurrent.AbstractIdleService;
import org.apache.hive.com.google.common.util.concurrent.ListenableFuture;
import org.apache.hive.com.google.common.util.concurrent.Service;
import org.apache.hive.org.apache.zookeeper.server.ServerCnxnFactory;
import org.apache.hive.org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.hive.org.apache.zookeeper.server.persistence.FileTxnSnapLog;
import org.apache.hive.org.slf4j.Logger;
import org.apache.hive.org.slf4j.LoggerFactory;

public final class InMemoryZKServer
implements Service {
    private static final Logger LOG = LoggerFactory.getLogger(InMemoryZKServer.class);
    private final File dataDir;
    private final int tickTime;
    private final boolean autoClean;
    private final int port;
    private final Service delegateService = new AbstractIdleService(){

        @Override
        protected void startUp() throws Exception {
            ZooKeeperServer zkServer = new ZooKeeperServer();
            FileTxnSnapLog ftxn = new FileTxnSnapLog(InMemoryZKServer.this.dataDir, InMemoryZKServer.this.dataDir);
            zkServer.setTxnLogFactory(ftxn);
            zkServer.setTickTime(InMemoryZKServer.this.tickTime);
            InMemoryZKServer.this.factory = ServerCnxnFactory.createFactory();
            InMemoryZKServer.this.factory.configure(InMemoryZKServer.this.getAddress(InMemoryZKServer.this.port), -1);
            InMemoryZKServer.this.factory.startup(zkServer);
            LOG.info("In memory ZK started: " + InMemoryZKServer.this.getConnectionStr());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void shutDown() throws Exception {
            try {
                InMemoryZKServer.this.factory.shutdown();
            }
            finally {
                if (InMemoryZKServer.this.autoClean) {
                    InMemoryZKServer.this.cleanDir(InMemoryZKServer.this.dataDir);
                }
            }
        }
    };
    private ServerCnxnFactory factory;

    public static Builder builder() {
        return new Builder();
    }

    private InMemoryZKServer(File dataDir, int tickTime, boolean autoClean, int port) {
        if (dataDir == null) {
            dataDir = Files.createTempDir();
            autoClean = true;
        } else {
            Preconditions.checkArgument(dataDir.isDirectory() || dataDir.mkdirs() || dataDir.isDirectory());
        }
        this.dataDir = dataDir;
        this.tickTime = tickTime;
        this.autoClean = autoClean;
        this.port = port;
    }

    public String getConnectionStr() {
        InetSocketAddress addr = this.factory.getLocalAddress();
        return String.format("%s:%d", addr.getHostName(), addr.getPort());
    }

    public InetSocketAddress getLocalAddress() {
        return this.factory.getLocalAddress();
    }

    private InetSocketAddress getAddress(int port) {
        try {
            int socketPort;
            int n = socketPort = port < 0 ? 0 : port;
            if (Boolean.parseBoolean(System.getProperties().getProperty("twill.zk.server.localhost", "true"))) {
                return new InetSocketAddress(InetAddress.getLocalHost(), socketPort);
            }
            return new InetSocketAddress(socketPort);
        }
        catch (UnknownHostException e) {
            throw Throwables.propagate(e);
        }
    }

    private void cleanDir(File dir) {
        File[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            if (file.isDirectory()) {
                this.cleanDir(file);
            }
            file.delete();
        }
    }

    @Override
    public ListenableFuture<Service.State> start() {
        return this.delegateService.start();
    }

    @Override
    public Service.State startAndWait() {
        return this.delegateService.startAndWait();
    }

    @Override
    public boolean isRunning() {
        return this.delegateService.isRunning();
    }

    @Override
    public Service.State state() {
        return this.delegateService.state();
    }

    @Override
    public ListenableFuture<Service.State> stop() {
        return this.delegateService.stop();
    }

    @Override
    public Service.State stopAndWait() {
        return this.delegateService.stopAndWait();
    }

    @Override
    public void addListener(Service.Listener listener, Executor executor) {
        this.delegateService.addListener(listener, executor);
    }

    public static final class Builder {
        private File dataDir;
        private boolean autoCleanDataDir = false;
        private int tickTime = 3000;
        private int port = -1;

        public Builder setDataDir(File dataDir) {
            this.dataDir = dataDir;
            return this;
        }

        public Builder setAutoCleanDataDir(boolean auto) {
            this.autoCleanDataDir = auto;
            return this;
        }

        public Builder setTickTime(int tickTime) {
            this.tickTime = tickTime;
            return this;
        }

        public Builder setPort(int port) {
            this.port = port;
            return this;
        }

        public InMemoryZKServer build() {
            return new InMemoryZKServer(this.dataDir, this.tickTime, this.autoCleanDataDir, this.port);
        }

        private Builder() {
        }
    }
}

