/*
 * Decompiled with CFR 0.152.
 */
package org.apache.twill.internal.state;

import org.apache.hive.com.google.common.base.Preconditions;
import org.apache.twill.api.Command;
import org.apache.twill.internal.state.Message;
import org.apache.twill.internal.state.SimpleMessage;

public final class SystemMessages {
    public static final Command STOP_COMMAND = Command.Builder.of("stop").build();
    public static final Message SECURE_STORE_UPDATED = new SimpleMessage(Message.Type.SYSTEM, Message.Scope.APPLICATION, null, Command.Builder.of("secureStoreUpdated").build());

    public static Message stopApplication() {
        return new SimpleMessage(Message.Type.SYSTEM, Message.Scope.APPLICATION, null, STOP_COMMAND);
    }

    public static Message stopRunnable(String runnableName) {
        return new SimpleMessage(Message.Type.SYSTEM, Message.Scope.RUNNABLE, runnableName, STOP_COMMAND);
    }

    public static Message setInstances(String runnableName, int instances) {
        Preconditions.checkArgument(instances > 0, "Instances should be > 0.");
        return new SimpleMessage(Message.Type.SYSTEM, Message.Scope.RUNNABLE, runnableName, Command.Builder.of("instances").addOption("count", Integer.toString(instances)).build());
    }

    public static Message updateRunnableInstances(Command updateCommand, String runnableName) {
        Preconditions.checkNotNull(updateCommand);
        Preconditions.checkNotNull(runnableName);
        return new SimpleMessage(Message.Type.SYSTEM, Message.Scope.RUNNABLE, runnableName, updateCommand);
    }

    public static Message updateRunnablesInstances(Command updateCommand) {
        Preconditions.checkNotNull(updateCommand);
        return new SimpleMessage(Message.Type.SYSTEM, Message.Scope.RUNNABLES, null, updateCommand);
    }

    private SystemMessages() {
    }
}

