/*
 * Decompiled with CFR 0.152.
 */
package org.apache.twill.internal.kafka.client;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.hive.com.google.common.base.Preconditions;
import org.apache.hive.com.google.common.util.concurrent.AbstractIdleService;
import org.apache.hive.org.slf4j.Logger;
import org.apache.hive.org.slf4j.LoggerFactory;
import org.apache.twill.common.Cancellable;
import org.apache.twill.common.Threads;
import org.apache.twill.internal.kafka.client.SimpleKafkaConsumer;
import org.apache.twill.internal.kafka.client.SimpleKafkaPublisher;
import org.apache.twill.internal.kafka.client.ZKBrokerService;
import org.apache.twill.kafka.client.BrokerService;
import org.apache.twill.kafka.client.Compression;
import org.apache.twill.kafka.client.KafkaClientService;
import org.apache.twill.kafka.client.KafkaConsumer;
import org.apache.twill.kafka.client.KafkaPublisher;
import org.apache.twill.zookeeper.ZKClient;

public class ZKKafkaClientService
extends AbstractIdleService
implements KafkaClientService,
Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(ZKKafkaClientService.class);
    private static final long PUBLISHER_CLEANUP_SECONDS = 1L;
    private final BrokerService brokerService;
    private final Map<WeakReference<KafkaPublisher>, Cancellable> publishers;
    private final ReferenceQueue<KafkaPublisher> referenceQueue;
    private final SimpleKafkaConsumer consumer;
    private ScheduledExecutorService scheduler;

    public ZKKafkaClientService(ZKClient zkClient) {
        this.brokerService = new ZKBrokerService(zkClient);
        this.publishers = Collections.synchronizedMap(new IdentityHashMap());
        this.referenceQueue = new ReferenceQueue();
        this.consumer = new SimpleKafkaConsumer(this.brokerService);
    }

    @Override
    public KafkaPublisher getPublisher(KafkaPublisher.Ack ack, Compression compression) {
        Preconditions.checkState(this.isRunning(), "Service is not running.");
        SimpleKafkaPublisher publisher = new SimpleKafkaPublisher(this.brokerService, ack, compression);
        this.publishers.put(new WeakReference<KafkaPublisher>(publisher, this.referenceQueue), publisher.start());
        return publisher;
    }

    @Override
    public KafkaConsumer getConsumer() {
        Preconditions.checkState(this.isRunning(), "Service is not running.");
        return this.consumer;
    }

    @Override
    public void run() {
        Reference<KafkaPublisher> ref = this.referenceQueue.poll();
        while (ref != null && this.isRunning()) {
            this.publishers.remove(ref).cancel();
            ref = this.referenceQueue.poll();
        }
    }

    @Override
    protected void startUp() throws Exception {
        this.scheduler = Executors.newSingleThreadScheduledExecutor(Threads.createDaemonThreadFactory("kafka-client-cleanup"));
        this.scheduler.scheduleAtFixedRate(this, 1L, 1L, TimeUnit.SECONDS);
        this.brokerService.startAndWait();
    }

    @Override
    protected void shutDown() throws Exception {
        LOG.info("Stopping KafkaClientService");
        this.scheduler.shutdownNow();
        for (Cancellable cancellable : this.publishers.values()) {
            cancellable.cancel();
        }
        this.consumer.stop();
        this.brokerService.stopAndWait();
        LOG.info("KafkaClientService stopped");
    }
}

