/*
 * Decompiled with CFR 0.152.
 */
package org.apache.twill.discovery;

import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hive.com.google.common.collect.LinkedHashMultimap;
import org.apache.hive.com.google.common.collect.Maps;
import org.apache.hive.com.google.common.collect.SetMultimap;
import org.apache.twill.common.Cancellable;
import org.apache.twill.discovery.DefaultServiceDiscovered;
import org.apache.twill.discovery.Discoverable;
import org.apache.twill.discovery.DiscoverableWrapper;
import org.apache.twill.discovery.DiscoveryService;
import org.apache.twill.discovery.DiscoveryServiceClient;
import org.apache.twill.discovery.ServiceDiscovered;

public class InMemoryDiscoveryService
implements DiscoveryService,
DiscoveryServiceClient {
    private final SetMultimap<String, Discoverable> services = LinkedHashMultimap.create();
    private final Map<String, DefaultServiceDiscovered> serviceDiscoveredMap = Maps.newHashMap();
    private final Lock lock = new ReentrantLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Cancellable register(Discoverable discoverable) {
        final DiscoverableWrapper wrapper = new DiscoverableWrapper(discoverable);
        final String serviceName = wrapper.getName();
        this.lock.lock();
        try {
            this.services.put(serviceName, wrapper);
            DefaultServiceDiscovered serviceDiscovered = this.serviceDiscoveredMap.get(serviceName);
            if (serviceDiscovered != null) {
                serviceDiscovered.setDiscoverables(this.services.get(serviceName));
            }
        }
        finally {
            this.lock.unlock();
        }
        return new Cancellable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void cancel() {
                InMemoryDiscoveryService.this.lock.lock();
                try {
                    InMemoryDiscoveryService.this.services.remove(serviceName, wrapper);
                    DefaultServiceDiscovered serviceDiscovered = (DefaultServiceDiscovered)InMemoryDiscoveryService.this.serviceDiscoveredMap.get(serviceName);
                    if (serviceDiscovered != null) {
                        serviceDiscovered.setDiscoverables(InMemoryDiscoveryService.this.services.get(serviceName));
                    }
                }
                finally {
                    InMemoryDiscoveryService.this.lock.unlock();
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServiceDiscovered discover(String name) {
        this.lock.lock();
        try {
            DefaultServiceDiscovered serviceDiscovered = this.serviceDiscoveredMap.get(name);
            if (serviceDiscovered == null) {
                serviceDiscovered = new DefaultServiceDiscovered(name);
                serviceDiscovered.setDiscoverables(this.services.get(name));
                this.serviceDiscoveredMap.put(name, serviceDiscovered);
            }
            DefaultServiceDiscovered defaultServiceDiscovered = serviceDiscovered;
            return defaultServiceDiscovered;
        }
        finally {
            this.lock.unlock();
        }
    }
}

