/*
 * Decompiled with CFR 0.152.
 */
package org.apache.twill.discovery;

import java.net.InetSocketAddress;
import org.apache.twill.discovery.Discoverable;

final class DiscoverableWrapper
implements Discoverable {
    private final String name;
    private final InetSocketAddress address;

    DiscoverableWrapper(Discoverable discoverable) {
        this.name = discoverable.getName();
        this.address = discoverable.getSocketAddress();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public InetSocketAddress getSocketAddress() {
        return this.address;
    }

    public String toString() {
        return "{name=" + this.name + ", address=" + this.address;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Discoverable other = (Discoverable)o;
        return this.name.equals(other.getName()) && this.address.equals(other.getSocketAddress());
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.address.hashCode();
        return result;
    }
}

