/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service;

import java.io.Closeable;
import java.io.IOException;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hive.org.slf4j.Logger;

public class ServiceUtils {
    public static int indexOfDomainMatch(String userName) {
        int idx2;
        if (userName == null) {
            return -1;
        }
        int idx = userName.indexOf(47);
        int endIdx = Math.min(idx, idx2 = userName.indexOf(64));
        if (endIdx == -1) {
            endIdx = Math.max(idx, idx2);
        }
        return endIdx;
    }

    public static void cleanup(Logger log, Closeable ... closeables) {
        for (Closeable c : closeables) {
            if (c == null) continue;
            try {
                c.close();
            }
            catch (IOException e) {
                if (log == null || !log.isDebugEnabled()) continue;
                log.debug("Exception in closing " + c, e);
            }
        }
    }

    public static boolean canProvideProgressLog(HiveConf hiveConf) {
        return "tez".equals(hiveConf.getVar(HiveConf.ConfVars.HIVE_EXECUTION_ENGINE)) && hiveConf.getBoolVar(HiveConf.ConfVars.HIVE_SERVER2_INPLACE_PROGRESS);
    }
}

