/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.org.apache.zookeeper.test;

import java.io.IOException;
import org.apache.hive.org.apache.zookeeper.CreateMode;
import org.apache.hive.org.apache.zookeeper.KeeperException;
import org.apache.hive.org.apache.zookeeper.StatsTrack;
import org.apache.hive.org.apache.zookeeper.TestableZooKeeper;
import org.apache.hive.org.apache.zookeeper.ZooDefs;
import org.apache.hive.org.apache.zookeeper.ZooKeeperMain;
import org.apache.hive.org.apache.zookeeper.data.Stat;
import org.apache.hive.org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.hive.org.apache.zookeeper.test.ClientBase;
import org.apache.hive.org.slf4j.Logger;
import org.apache.hive.org.slf4j.LoggerFactory;
import org.junit.Assert;
import org.junit.Test;

public class ZooKeeperQuotaTest
extends ClientBase {
    private static final Logger LOG = LoggerFactory.getLogger(ZooKeeperQuotaTest.class);

    @Test
    public void testQuota() throws IOException, InterruptedException, KeeperException, Exception {
        TestableZooKeeper zk = this.createClient();
        String path = "/a/b/v";
        zk.setData("/", "some".getBytes(), -1);
        zk.create("/a", "some".getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        zk.create("/a/b", "some".getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        zk.create("/a/b/v", "some".getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        zk.create("/a/b/v/d", "some".getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        ZooKeeperMain.createQuota(zk, "/a/b/v", 5L, 10);
        String absolutePath = "/zookeeper/quota/a/b/v/zookeeper_limits";
        byte[] data = zk.getData(absolutePath, false, new Stat());
        StatsTrack st = new StatsTrack(new String(data));
        Assert.assertTrue((String)"bytes are set", (st.getBytes() == 5L ? 1 : 0) != 0);
        Assert.assertTrue((String)"num count is set", (st.getCount() == 10 ? 1 : 0) != 0);
        String statPath = "/zookeeper/quota/a/b/v/zookeeper_stats";
        byte[] qdata = zk.getData(statPath, false, new Stat());
        StatsTrack qst = new StatsTrack(new String(qdata));
        Assert.assertTrue((String)"bytes are set", (qst.getBytes() == 8L ? 1 : 0) != 0);
        Assert.assertTrue((String)"count is set", (qst.getCount() == 2 ? 1 : 0) != 0);
        this.stopServer();
        this.startServer();
        this.stopServer();
        this.startServer();
        ZooKeeperServer server = ZooKeeperQuotaTest.getServer(this.serverFactory);
        Assert.assertNotNull((String)"Quota is still set", (Object)(server.getZKDatabase().getDataTree().getMaxPrefixWithQuota("/a/b/v") != null ? 1 : 0));
    }
}

