/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.org.apache.zookeeper.test;

import java.io.IOException;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.hive.org.apache.zookeeper.AsyncCallback;
import org.apache.hive.org.apache.zookeeper.CreateMode;
import org.apache.hive.org.apache.zookeeper.TestableZooKeeper;
import org.apache.hive.org.apache.zookeeper.Watcher;
import org.apache.hive.org.apache.zookeeper.ZooDefs;
import org.apache.hive.org.apache.zookeeper.data.Stat;
import org.apache.hive.org.apache.zookeeper.test.ClientBase;
import org.junit.Assert;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SyncCallTest
extends ClientBase
implements AsyncCallback.ChildrenCallback,
AsyncCallback.Children2Callback,
AsyncCallback.StringCallback,
AsyncCallback.VoidCallback {
    private CountDownLatch opsCount;
    List<Integer> results = new LinkedList<Integer>();
    Integer limit = 301;

    @Test
    public void testSync() throws Exception {
        try {
            int i;
            LOG.info("Starting ZK:" + new Date().toString());
            this.opsCount = new CountDownLatch(this.limit);
            TestableZooKeeper zk = this.createClient();
            LOG.info("Beginning test:" + new Date().toString());
            for (i = 0; i < 100; ++i) {
                zk.create("/test" + i, new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT, this, this.results);
            }
            zk.sync("/test", this, this.results);
            for (i = 0; i < 100; ++i) {
                zk.delete("/test" + i, 0, this, this.results);
            }
            for (i = 0; i < 100; ++i) {
                zk.getChildren("/", (Watcher)new ClientBase.NullWatcher(), (AsyncCallback.ChildrenCallback)this, this.results);
            }
            for (i = 0; i < 100; ++i) {
                zk.getChildren("/", (Watcher)new ClientBase.NullWatcher(), (AsyncCallback.Children2Callback)this, this.results);
            }
            LOG.info("Submitted all operations:" + new Date().toString());
            if (!this.opsCount.await(10000L, TimeUnit.MILLISECONDS)) {
                Assert.fail((String)("Haven't received all confirmations" + this.opsCount.getCount()));
            }
            for (i = 0; i < this.limit; ++i) {
                Assert.assertEquals((long)0L, (long)this.results.get(i).intValue());
            }
        }
        catch (IOException e) {
            System.out.println(e.toString());
        }
    }

    @Override
    public void processResult(int rc, String path, Object ctx, List<String> children) {
        ((List)ctx).add(rc);
        this.opsCount.countDown();
    }

    @Override
    public void processResult(int rc, String path, Object ctx, List<String> children, Stat stat) {
        ((List)ctx).add(rc);
        this.opsCount.countDown();
    }

    @Override
    public void processResult(int rc, String path, Object ctx, String name) {
        ((List)ctx).add(rc);
        this.opsCount.countDown();
    }

    @Override
    public void processResult(int rc, String path, Object ctx) {
        ((List)ctx).add(rc);
        this.opsCount.countDown();
    }
}

