/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.org.apache.zookeeper.test;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.hive.org.apache.zookeeper.ZKTestCase;
import org.apache.hive.org.apache.zookeeper.client.StaticHostProvider;
import org.apache.hive.org.slf4j.Logger;
import org.apache.hive.org.slf4j.LoggerFactory;
import org.junit.Assert;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StaticHostProviderTest
extends ZKTestCase {
    private static final Logger LOG = LoggerFactory.getLogger(StaticHostProviderTest.class);

    @Test
    public void testNextGoesRound() throws UnknownHostException {
        StaticHostProvider hostProvider = this.getHostProvider((byte)2);
        InetSocketAddress first = hostProvider.next(0L);
        Assert.assertTrue((boolean)(first instanceof InetSocketAddress));
        hostProvider.next(0L);
        Assert.assertEquals((Object)first, (Object)hostProvider.next(0L));
    }

    @Test
    public void testNextGoesRoundAndSleeps() throws UnknownHostException {
        byte size;
        StaticHostProvider hostProvider = this.getHostProvider(size);
        for (size = 2; size > 0; size = (byte)(size - 1)) {
            hostProvider.next(0L);
        }
        long start = System.currentTimeMillis();
        hostProvider.next(1000L);
        long stop = System.currentTimeMillis();
        Assert.assertTrue((900L <= stop - start ? 1 : 0) != 0);
    }

    @Test
    public void testNextDoesNotSleepForZero() throws UnknownHostException {
        byte size;
        StaticHostProvider hostProvider = this.getHostProvider(size);
        for (size = 2; size > 0; size = (byte)(size - 1)) {
            hostProvider.next(0L);
        }
        long start = System.currentTimeMillis();
        hostProvider.next(0L);
        long stop = System.currentTimeMillis();
        Assert.assertTrue((5L > stop - start ? 1 : 0) != 0);
    }

    @Test
    public void testTwoConsequitiveCallsToNextReturnDifferentElement() throws UnknownHostException {
        StaticHostProvider hostProvider = this.getHostProvider((byte)2);
        Assert.assertNotSame((Object)hostProvider.next(0L), (Object)hostProvider.next(0L));
    }

    @Test
    public void testOnConnectDoesNotReset() throws UnknownHostException {
        StaticHostProvider hostProvider = this.getHostProvider((byte)2);
        InetSocketAddress first = hostProvider.next(0L);
        hostProvider.onConnected();
        InetSocketAddress second = hostProvider.next(0L);
        Assert.assertNotSame((Object)first, (Object)second);
    }

    @Test
    public void testLiteralIPNoReverseNS() throws Exception {
        int size = 30;
        StaticHostProvider hostProvider = this.getHostProviderUnresolved((byte)size);
        for (int i = 0; i < size; ++i) {
            InetSocketAddress next = hostProvider.next(0L);
            Assert.assertTrue((boolean)(next instanceof InetSocketAddress));
            Assert.assertTrue((!next.isUnresolved() ? 1 : 0) != 0);
            Assert.assertTrue((String)("Did not match " + next.toString()), (!next.toString().startsWith("/") ? 1 : 0) != 0);
            String hostname = next.getHostName();
            hostname.equals(next.getAddress().getHostAddress());
        }
    }

    private StaticHostProvider getHostProviderUnresolved(byte size) throws UnknownHostException {
        return new StaticHostProvider(this.getUnresolvedServerAddresses(size));
    }

    private Collection<InetSocketAddress> getUnresolvedServerAddresses(byte size) {
        ArrayList<InetSocketAddress> list = new ArrayList<InetSocketAddress>(size);
        while (size > 0) {
            list.add(InetSocketAddress.createUnresolved("10.10.10." + size, 1234 + size));
            size = (byte)(size - 1);
        }
        return list;
    }

    private StaticHostProvider getHostProvider(byte size) throws UnknownHostException {
        ArrayList<InetSocketAddress> list = new ArrayList<InetSocketAddress>(size);
        while (size > 0) {
            try {
                list.add(new InetSocketAddress(InetAddress.getByAddress(new byte[]{10, 10, 10, size}), 1234 + size));
            }
            catch (UnknownHostException e) {
                LOG.error("Exception while resolving address", e);
                Assert.fail((String)"Failed to resolve address");
            }
            size = (byte)(size - 1);
        }
        return new StaticHostProvider(list);
    }
}

