/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.org.apache.zookeeper.test;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hive.org.apache.zookeeper.CreateMode;
import org.apache.hive.org.apache.zookeeper.KeeperException;
import org.apache.hive.org.apache.zookeeper.TestableZooKeeper;
import org.apache.hive.org.apache.zookeeper.WatchedEvent;
import org.apache.hive.org.apache.zookeeper.Watcher;
import org.apache.hive.org.apache.zookeeper.ZooDefs;
import org.apache.hive.org.apache.zookeeper.test.ClientBase;
import org.junit.Assert;
import org.junit.Test;

public class SaslAuthFailDesignatedClientTest
extends ClientBase {
    private AtomicInteger authFailed = new AtomicInteger(0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAuth() throws Exception {
        ClientBase.CountdownWatcher watcher = new ClientBase.CountdownWatcher();
        TestableZooKeeper zk = new TestableZooKeeper(this.hostPort, CONNECTION_TIMEOUT, watcher);
        if (!watcher.clientConnected.await(CONNECTION_TIMEOUT, TimeUnit.MILLISECONDS)) {
            Assert.fail((String)"Unable to connect to server");
        }
        try {
            zk.create("/path1", null, ZooDefs.Ids.CREATOR_ALL_ACL, CreateMode.PERSISTENT);
            Assert.fail((String)"Should have gotten exception.");
        }
        catch (KeeperException e) {
            LOG.info("Got exception as expected: " + e);
        }
        finally {
            zk.close();
        }
    }

    static {
        System.setProperty("zookeeper.authProvider.1", "org.apache.hive.org.apache.zookeeper.server.auth.SASLAuthenticationProvider");
        System.setProperty("zookeeper.sasl.clientconfig", "MyZookeeperClient");
        try {
            File tmpDir = SaslAuthFailDesignatedClientTest.createTmpDir();
            File saslConfFile = new File(tmpDir, "jaas.conf");
            FileWriter fwriter = new FileWriter(saslConfFile);
            fwriter.write("Server {\n          org.apache.zookeeper.server.auth.DigestLoginModule required\n          user_myuser=\"mypassword\";\n};\nClient {\n       org.apache.zookeeper.server.auth.DigestLoginModule required\n       username=\"myuser\"\n       password=\"mypassword\";\n};MyZookeeperClient {\n       org.apache.zookeeper.server.auth.DigestLoginModule required\n       username=\"myuser\"\n       password=\"wrongpassword\";\n};\n");
            fwriter.close();
            System.setProperty("java.security.auth.login.config", saslConfFile.getAbsolutePath());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private class MyWatcher
    extends ClientBase.CountdownWatcher {
        private MyWatcher() {
        }

        public synchronized void process(WatchedEvent event) {
            if (event.getState() == Watcher.Event.KeeperState.AuthFailed) {
                SaslAuthFailDesignatedClientTest.this.authFailed.incrementAndGet();
            } else {
                super.process(event);
            }
        }
    }
}

