/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.org.apache.zookeeper.test;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.hive.org.apache.zookeeper.AsyncCallback;
import org.apache.hive.org.apache.zookeeper.CreateMode;
import org.apache.hive.org.apache.zookeeper.KeeperException;
import org.apache.hive.org.apache.zookeeper.WatchedEvent;
import org.apache.hive.org.apache.zookeeper.Watcher;
import org.apache.hive.org.apache.zookeeper.ZKTestCase;
import org.apache.hive.org.apache.zookeeper.ZooDefs;
import org.apache.hive.org.apache.zookeeper.ZooKeeper;
import org.apache.hive.org.apache.zookeeper.data.Stat;
import org.apache.hive.org.apache.zookeeper.server.quorum.Leader;
import org.apache.hive.org.apache.zookeeper.server.quorum.LearnerHandler;
import org.apache.hive.org.apache.zookeeper.test.ClientBase;
import org.apache.hive.org.apache.zookeeper.test.ClientTest;
import org.apache.hive.org.apache.zookeeper.test.DisconnectableZooKeeper;
import org.apache.hive.org.apache.zookeeper.test.QuorumBase;
import org.apache.hive.org.slf4j.Logger;
import org.apache.hive.org.slf4j.LoggerFactory;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class QuorumTest
extends ZKTestCase {
    private static final Logger LOG = LoggerFactory.getLogger(QuorumTest.class);
    public static final long CONNECTION_TIMEOUT = ClientTest.CONNECTION_TIMEOUT;
    private final QuorumBase qb = new QuorumBase();
    private final ClientTest ct = new ClientTest();
    volatile int counter = 0;
    volatile int errors = 0;

    @Before
    public void setUp() throws Exception {
        this.qb.setUp();
        this.ct.hostPort = this.qb.hostPort;
        this.ct.setUpAll();
    }

    @After
    public void tearDown() throws Exception {
        this.ct.tearDownAll();
        this.qb.tearDown();
    }

    @Test
    public void testDeleteWithChildren() throws Exception {
        this.ct.testDeleteWithChildren();
    }

    @Test
    public void testPing() throws Exception {
        this.ct.testPing();
    }

    @Test
    public void testSequentialNodeNames() throws IOException, InterruptedException, KeeperException {
        this.ct.testSequentialNodeNames();
    }

    @Test
    public void testACLs() throws Exception {
        this.ct.testACLs();
    }

    @Test
    public void testClientwithoutWatcherObj() throws IOException, InterruptedException, KeeperException {
        this.ct.testClientwithoutWatcherObj();
    }

    @Test
    public void testClientWithWatcherObj() throws IOException, InterruptedException, KeeperException {
        this.ct.testClientWithWatcherObj();
    }

    @Test
    public void testGetView() {
        Assert.assertEquals((long)5L, (long)this.qb.s1.getView().size());
        Assert.assertEquals((long)5L, (long)this.qb.s2.getView().size());
        Assert.assertEquals((long)5L, (long)this.qb.s3.getView().size());
        Assert.assertEquals((long)5L, (long)this.qb.s4.getView().size());
        Assert.assertEquals((long)5L, (long)this.qb.s5.getView().size());
    }

    @Test
    public void testViewContains() {
        Assert.assertTrue((boolean)this.qb.s1.viewContains(this.qb.s1.getId()));
        Assert.assertTrue((boolean)this.qb.s1.viewContains(this.qb.s2.getId()));
        Assert.assertFalse((boolean)this.qb.s1.viewContains(-1L));
    }

    @Test
    public void testLeaderShutdown() throws IOException, InterruptedException, KeeperException {
        DisconnectableZooKeeper zk = new DisconnectableZooKeeper(this.qb.hostPort, ClientBase.CONNECTION_TIMEOUT, new Watcher(){

            public void process(WatchedEvent event) {
            }
        });
        zk.create("/blah", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        zk.create("/blah/blah", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        Leader leader = this.qb.s1.leader;
        if (leader == null) {
            leader = this.qb.s2.leader;
        }
        if (leader == null) {
            leader = this.qb.s3.leader;
        }
        if (leader == null) {
            leader = this.qb.s4.leader;
        }
        if (leader == null) {
            leader = this.qb.s5.leader;
        }
        Assert.assertNotNull((Object)leader);
        for (int i = 0; i < 5000; ++i) {
            zk.setData("/blah/blah", new byte[0], -1, new AsyncCallback.StatCallback(){

                public void processResult(int rc, String path, Object ctx, Stat stat) {
                    ++QuorumTest.this.counter;
                    if (rc != 0) {
                        ++QuorumTest.this.errors;
                    }
                }
            }, null);
        }
        for (LearnerHandler f : leader.getForwardingFollowers()) {
            f.getSocket().shutdownInput();
        }
        for (int i = 0; i < 5000; ++i) {
            zk.setData("/blah/blah", new byte[0], -1, new AsyncCallback.StatCallback(){

                public void processResult(int rc, String path, Object ctx, Stat stat) {
                    ++QuorumTest.this.counter;
                    if (rc != 0) {
                        ++QuorumTest.this.errors;
                    }
                }
            }, null);
        }
        Assert.assertTrue((boolean)this.qb.s1.isAlive());
        Assert.assertTrue((boolean)this.qb.s2.isAlive());
        Assert.assertTrue((boolean)this.qb.s3.isAlive());
        Assert.assertTrue((boolean)this.qb.s4.isAlive());
        Assert.assertTrue((boolean)this.qb.s5.isAlive());
        zk.close();
    }

    @Test
    public void testMultipleWatcherObjs() throws IOException, InterruptedException, KeeperException {
        this.ct.testMutipleWatcherObjs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Test
    public void testSessionMoved() throws Exception {
        String[] hostPorts = this.qb.hostPort.split(",");
        DisconnectableZooKeeper zk = new DisconnectableZooKeeper(hostPorts[0], ClientBase.CONNECTION_TIMEOUT, new Watcher(){

            public void process(WatchedEvent event) {
            }
        });
        zk.create("/sessionMoveTest", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
        int i = 0;
        while (true) {
            if (i >= hostPorts.length * 2) {
                zk.close();
                return;
            }
            zk.dontReconnect();
            DisconnectableZooKeeper zknew = new DisconnectableZooKeeper(hostPorts[(i + 1) % hostPorts.length], ClientBase.CONNECTION_TIMEOUT, new Watcher(){

                public void process(WatchedEvent event) {
                }
            }, zk.getSessionId(), zk.getSessionPasswd());
            zknew.setData("/", new byte[1], -1);
            final int[] result = new int[]{Integer.MAX_VALUE};
            zknew.sync("/", new AsyncCallback.VoidCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void processResult(int rc, String path, Object ctx) {
                    int[] nArray = result;
                    synchronized (result) {
                        result[0] = rc;
                        result.notify();
                        // ** MonitorExit[var4_4] (shouldn't be in output)
                        return;
                    }
                }
            }, null);
            int[] nArray = result;
            // MONITORENTER : result
            if (result[0] == Integer.MAX_VALUE) {
                result.wait(5000L);
            }
            // MONITOREXIT : nArray
            LOG.info(hostPorts[(i + 1) % hostPorts.length] + " Sync returned " + result[0]);
            Assert.assertTrue((result[0] == KeeperException.Code.OK.intValue() ? 1 : 0) != 0);
            try {
                zk.setData("/", new byte[1], -1);
                Assert.fail((String)"Should have lost the connection");
            }
            catch (KeeperException.ConnectionLossException e) {
                // empty catch block
            }
            zk = zknew;
            ++i;
        }
    }

    @Test
    @Ignore
    public void testSessionMove() throws Exception {
        int i;
        String[] hps = this.qb.hostPort.split(",");
        DiscoWatcher oldWatcher = new DiscoWatcher();
        DisconnectableZooKeeper zk = new DisconnectableZooKeeper(hps[0], ClientBase.CONNECTION_TIMEOUT, oldWatcher);
        zk.create("/t1", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
        zk.dontReconnect();
        DiscoWatcher watcher = new DiscoWatcher();
        DisconnectableZooKeeper zknew = new DisconnectableZooKeeper(hps[1], ClientBase.CONNECTION_TIMEOUT, watcher, zk.getSessionId(), zk.getSessionPasswd());
        zknew.create("/t2", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
        try {
            zk.create("/t3", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
            Assert.fail((String)"Should have lost the connection");
        }
        catch (KeeperException.ConnectionLossException e) {
            for (i = 0; i < 30 && !oldWatcher.zkDisco; ++i) {
                Thread.sleep(1000L);
            }
            Assert.assertTrue((boolean)oldWatcher.zkDisco);
        }
        ArrayList<DisconnectableZooKeeper> toClose = new ArrayList<DisconnectableZooKeeper>();
        toClose.add(zknew);
        for (i = 0; i < 10; ++i) {
            zknew.dontReconnect();
            zknew = new DisconnectableZooKeeper(hps[1], ClientBase.CONNECTION_TIMEOUT, new DiscoWatcher(), zk.getSessionId(), zk.getSessionPasswd());
            toClose.add(zknew);
            zknew.create("/t-" + i, new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
        }
        for (ZooKeeper zooKeeper : toClose) {
            zooKeeper.close();
        }
        zk.close();
    }

    private static class DiscoWatcher
    implements Watcher {
        volatile boolean zkDisco = false;

        private DiscoWatcher() {
        }

        public void process(WatchedEvent event) {
            if (event.getState() == Watcher.Event.KeeperState.Disconnected) {
                this.zkDisco = true;
            }
        }
    }
}

