/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.org.apache.zookeeper.test;

import java.io.File;
import java.util.List;
import org.apache.hive.org.apache.zookeeper.CreateMode;
import org.apache.hive.org.apache.zookeeper.PortAssignment;
import org.apache.hive.org.apache.zookeeper.WatchedEvent;
import org.apache.hive.org.apache.zookeeper.Watcher;
import org.apache.hive.org.apache.zookeeper.ZKTestCase;
import org.apache.hive.org.apache.zookeeper.ZooDefs;
import org.apache.hive.org.apache.zookeeper.ZooKeeper;
import org.apache.hive.org.apache.zookeeper.server.PurgeTxnLog;
import org.apache.hive.org.apache.zookeeper.server.ServerCnxnFactory;
import org.apache.hive.org.apache.zookeeper.server.SyncRequestProcessor;
import org.apache.hive.org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.hive.org.apache.zookeeper.server.persistence.FileTxnSnapLog;
import org.apache.hive.org.apache.zookeeper.test.ClientBase;
import org.junit.Assert;
import org.junit.Test;

public class PurgeTxnTest
extends ZKTestCase
implements Watcher {
    private static String HOSTPORT = "127.0.0.1:" + PortAssignment.unique();
    private static final int CONNECTION_TIMEOUT = 3000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPurge() throws Exception {
        File tmpDir = ClientBase.createTmpDir();
        ClientBase.setupTestEnv();
        ZooKeeperServer zks = new ZooKeeperServer(tmpDir, tmpDir, 3000);
        SyncRequestProcessor.setSnapCount(100);
        int PORT = Integer.parseInt(HOSTPORT.split(":")[1]);
        ServerCnxnFactory f = ServerCnxnFactory.createFactory(PORT, -1);
        f.startup(zks);
        Assert.assertTrue((String)"waiting for server being up ", (boolean)ClientBase.waitForServerUp(HOSTPORT, 3000L));
        ZooKeeper zk = new ZooKeeper(HOSTPORT, 3000, this);
        try {
            for (int i = 0; i < 2000; ++i) {
                zk.create("/invalidsnap-" + i, new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            }
        }
        finally {
            zk.close();
        }
        f.shutdown();
        Assert.assertTrue((String)"waiting for server to shutdown", (boolean)ClientBase.waitForServerDown(HOSTPORT, 3000L));
        PurgeTxnLog.purge(tmpDir, tmpDir, 3);
        FileTxnSnapLog snaplog = new FileTxnSnapLog(tmpDir, tmpDir);
        List<File> listLogs = snaplog.findNRecentSnapshots(4);
        int numSnaps = 0;
        for (File ff : listLogs) {
            if (!ff.getName().startsWith("snapshot")) continue;
            ++numSnaps;
        }
        Assert.assertTrue((String)"exactly 3 snapshots ", (numSnaps == 3 ? 1 : 0) != 0);
        zks.shutdown();
    }

    public void process(WatchedEvent event) {
    }
}

