/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.org.apache.zookeeper.test;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.hive.org.apache.zookeeper.AsyncCallback;
import org.apache.hive.org.apache.zookeeper.CreateMode;
import org.apache.hive.org.apache.zookeeper.Op;
import org.apache.hive.org.apache.zookeeper.WatchedEvent;
import org.apache.hive.org.apache.zookeeper.Watcher;
import org.apache.hive.org.apache.zookeeper.ZKTestCase;
import org.apache.hive.org.apache.zookeeper.ZooDefs;
import org.apache.hive.org.apache.zookeeper.ZooKeeper;
import org.apache.hive.org.apache.zookeeper.data.Stat;
import org.apache.hive.org.apache.zookeeper.server.quorum.Leader;
import org.apache.hive.org.apache.zookeeper.test.ClientBase;
import org.apache.hive.org.apache.zookeeper.test.ClientTest;
import org.apache.hive.org.apache.zookeeper.test.DisconnectableZooKeeper;
import org.apache.hive.org.apache.zookeeper.test.QuorumUtil;
import org.apache.hive.org.slf4j.Logger;
import org.apache.hive.org.slf4j.LoggerFactory;
import org.junit.Assert;
import org.junit.Test;

public class FollowerTest
extends ZKTestCase {
    private static final Logger LOG = LoggerFactory.getLogger(FollowerTest.class);
    public static final long CONNECTION_TIMEOUT = ClientTest.CONNECTION_TIMEOUT;
    volatile int counter = 0;
    volatile int errors = 0;

    @Test
    public void testFollowersStartAfterLeader() throws Exception {
        QuorumUtil qu = new QuorumUtil(1);
        ClientBase.CountdownWatcher watcher = new ClientBase.CountdownWatcher();
        qu.startQuorum();
        int index = 1;
        while (qu.getPeer((int)index).peer.leader == null) {
            ++index;
        }
        ZooKeeper zk = new ZooKeeper("127.0.0.1:" + qu.getPeer((int)(index == 1 ? 2 : 1)).peer.getClientPort(), ClientBase.CONNECTION_TIMEOUT, watcher);
        watcher.waitForConnected(CONNECTION_TIMEOUT);
        qu.shutdown(index);
        watcher.waitForDisconnected(CONNECTION_TIMEOUT);
        qu.start(index);
        try {
            watcher.waitForConnected(30000L);
        }
        catch (TimeoutException e) {
            Assert.fail((String)"client could not connect to reestablished quorum: giving up after 30+ seconds.");
        }
        zk.close();
        qu.tearDown();
    }

    @Test
    public void testNoLogBeforeLeaderEstablishment() throws Exception {
        final Semaphore sem = new Semaphore(0);
        System.setProperty("zookeeper.cnxTimeout", "50");
        QuorumUtil qu = new QuorumUtil(2, 10);
        qu.startQuorum();
        int index = 1;
        while (qu.getPeer((int)index).peer.leader == null) {
            ++index;
        }
        Leader leader = qu.getPeer((int)index).peer.leader;
        Assert.assertNotNull((Object)leader);
        index = index == 1 ? 2 : 1;
        DisconnectableZooKeeper zk = new DisconnectableZooKeeper("127.0.0.1:" + qu.getPeer((int)index).peer.getClientPort(), ClientBase.CONNECTION_TIMEOUT, new Watcher(){

            public void process(WatchedEvent event) {
            }
        });
        zk.create("/blah", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        for (int i = 0; i < 50000; ++i) {
            zk.setData("/blah", new byte[0], -1, new AsyncCallback.StatCallback(){

                public void processResult(int rc, String path, Object ctx, Stat stat) {
                    ++FollowerTest.this.counter;
                    if (rc != 0) {
                        ++FollowerTest.this.errors;
                    }
                    if (FollowerTest.this.counter == 20000) {
                        sem.release();
                    }
                }
            }, null);
            if (i == 5000) {
                qu.shutdown(index);
                LOG.info("Shutting down s1");
            }
            if (i == 12000) {
                qu.start(index);
                LOG.info("Setting up server: " + index);
            }
            if (i % 1000 != 0) continue;
            Thread.sleep(500L);
        }
        sem.tryAcquire(15L, TimeUnit.SECONDS);
        Assert.assertTrue((String)"Not following", (qu.getPeer((int)index).peer.follower != null ? 1 : 0) != 0);
        long epochF = qu.getPeer((int)index).peer.getActiveServer().getZxid() >> 32;
        long epochL = leader.getEpoch() >> 32;
        Assert.assertTrue((String)("Zxid: " + qu.getPeer((int)index).peer.getActiveServer().getZxid() + "Current epoch: " + epochF), (epochF == epochL ? 1 : 0) != 0);
        qu.tearDown();
    }

    @Test
    public void testMultiToFollower() throws Exception {
        QuorumUtil qu = new QuorumUtil(1);
        ClientBase.CountdownWatcher watcher = new ClientBase.CountdownWatcher();
        qu.startQuorum();
        int index = 1;
        while (qu.getPeer((int)index).peer.leader == null) {
            ++index;
        }
        ZooKeeper zk = new ZooKeeper("127.0.0.1:" + qu.getPeer((int)(index == 1 ? 2 : 1)).peer.getClientPort(), ClientBase.CONNECTION_TIMEOUT, watcher);
        watcher.waitForConnected(CONNECTION_TIMEOUT);
        List<Object> results = new ArrayList();
        results = zk.multi(Arrays.asList(Op.create("/multi0", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT), Op.create("/multi1", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT), Op.create("/multi2", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT)));
        zk.getData("/multi0", false, null);
        zk.getData("/multi1", false, null);
        zk.getData("/multi2", false, null);
        zk.close();
        qu.tearDown();
    }
}

