/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.org.apache.zookeeper.test;

import java.io.File;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Random;
import java.util.concurrent.Semaphore;
import org.apache.hive.org.apache.zookeeper.PortAssignment;
import org.apache.hive.org.apache.zookeeper.ZKTestCase;
import org.apache.hive.org.apache.zookeeper.server.quorum.FastLeaderElection;
import org.apache.hive.org.apache.zookeeper.server.quorum.QuorumPeer;
import org.apache.hive.org.apache.zookeeper.server.quorum.Vote;
import org.apache.hive.org.apache.zookeeper.test.ClientBase;
import org.apache.hive.org.apache.zookeeper.test.FLETest;
import org.apache.hive.org.apache.zookeeper.test.QuorumBase;
import org.apache.hive.org.slf4j.Logger;
import org.apache.hive.org.slf4j.LoggerFactory;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FLERestartTest
extends ZKTestCase {
    protected static final Logger LOG = LoggerFactory.getLogger(FLETest.class);
    int count;
    HashMap<Long, QuorumPeer.QuorumServer> peers;
    ArrayList<FLERestartThread> restartThreads;
    HashMap<Integer, HashSet<TestVote>> voteMap;
    File[] tmpdir;
    int[] port;
    int successCount;
    Semaphore finish;
    volatile Vote[] votes;
    volatile boolean leaderDies;
    volatile long leader = -1L;
    Random rand = new Random();

    int countVotes(HashSet<TestVote> hs, long id) {
        int counter = 0;
        for (TestVote v : hs) {
            if (v.leader != id) continue;
            ++counter;
        }
        return counter;
    }

    @Before
    public void setUp() throws Exception {
        this.count = 3;
        this.peers = new HashMap(this.count);
        this.restartThreads = new ArrayList(this.count);
        this.voteMap = new HashMap();
        this.votes = new Vote[this.count];
        this.tmpdir = new File[this.count];
        this.port = new int[this.count];
        this.successCount = 0;
        this.finish = new Semaphore(0);
    }

    @After
    public void tearDown() throws Exception {
        for (int i = 0; i < this.restartThreads.size(); ++i) {
            ((FastLeaderElection)this.restartThreads.get((int)i).peer.getElectionAlg()).shutdown();
        }
    }

    @Test
    public void testLERestart() throws Exception {
        int i;
        FastLeaderElection[] le = new FastLeaderElection[this.count];
        boolean allowOneBadLeader = this.leaderDies = true;
        LOG.info("TestLE: " + this.getTestName() + ", " + this.count);
        for (i = 0; i < this.count; ++i) {
            this.peers.put(Long.valueOf(i), new QuorumPeer.QuorumServer(i, new InetSocketAddress(PortAssignment.unique()), new InetSocketAddress(PortAssignment.unique())));
            this.tmpdir[i] = ClientBase.createTmpDir();
            this.port[i] = PortAssignment.unique();
        }
        for (i = 0; i < this.count; ++i) {
            QuorumPeer peer = new QuorumPeer(this.peers, this.tmpdir[i], this.tmpdir[i], this.port[i], 3, (long)i, 1000, 2, 2);
            peer.startLeaderElection();
            FLERestartThread thread = new FLERestartThread(peer, i);
            thread.start();
            this.restartThreads.add(thread);
        }
        LOG.info("Started threads " + this.getTestName());
        for (i = 0; i < this.restartThreads.size(); ++i) {
            this.restartThreads.get(i).join(10000L);
            if (!this.restartThreads.get(i).isAlive()) continue;
            Assert.fail((String)"Threads didn't join");
        }
    }

    class FLERestartThread
    extends Thread {
        int i;
        QuorumPeer peer;
        int peerRound = 0;

        FLERestartThread(QuorumPeer peer, int i) {
            this.i = i;
            this.peer = peer;
            LOG.info("Constructor: " + this.getName());
        }

        public void run() {
            try {
                Vote v = null;
                while (true) {
                    this.peer.setPeerState(QuorumPeer.ServerState.LOOKING);
                    LOG.info("Going to call leader election again.");
                    v = this.peer.getElectionAlg().lookForLeader();
                    if (v == null) {
                        LOG.info("Thread " + this.i + " got a null vote");
                        break;
                    }
                    this.peer.setCurrentVote(v);
                    LOG.info("Finished election: " + this.i + ", " + v.getId());
                    switch (this.i) {
                        case 0: {
                            if (this.peerRound == 0) {
                                LOG.info("First peer, shutting it down");
                                QuorumBase.shutdown(this.peer);
                                ((FastLeaderElection)FLERestartTest.this.restartThreads.get((int)this.i).peer.getElectionAlg()).shutdown();
                                this.peer = new QuorumPeer(FLERestartTest.this.peers, FLERestartTest.this.tmpdir[this.i], FLERestartTest.this.tmpdir[this.i], FLERestartTest.this.port[this.i], 3, (long)this.i, 1000, 2, 2);
                                this.peer.startLeaderElection();
                                ++this.peerRound;
                                break;
                            }
                            FLERestartTest.this.finish.release(2);
                            return;
                        }
                        case 1: {
                            LOG.info("Second entering case");
                            FLERestartTest.this.finish.acquire();
                            LOG.info("Release");
                            return;
                        }
                        case 2: {
                            LOG.info("First peer, do nothing, just join");
                            FLERestartTest.this.finish.acquire();
                            LOG.info("Release");
                            return;
                        }
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    static class TestVote {
        long leader;

        TestVote(int id, long leader) {
            this.leader = leader;
        }
    }
}

