/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.org.apache.zookeeper.test;

import java.util.EnumSet;
import org.apache.hive.org.apache.zookeeper.CreateMode;
import org.apache.hive.org.apache.zookeeper.KeeperException;
import org.apache.hive.org.apache.zookeeper.ZKTestCase;
import org.junit.Assert;
import org.junit.Test;

public class CreateModeTest
extends ZKTestCase {
    @Test
    public void testBasicCreateMode() {
        CreateMode cm = CreateMode.PERSISTENT;
        Assert.assertEquals((long)cm.toFlag(), (long)0L);
        Assert.assertFalse((boolean)cm.isEphemeral());
        Assert.assertFalse((boolean)cm.isSequential());
        cm = CreateMode.EPHEMERAL;
        Assert.assertEquals((long)cm.toFlag(), (long)1L);
        Assert.assertTrue((boolean)cm.isEphemeral());
        Assert.assertFalse((boolean)cm.isSequential());
        cm = CreateMode.PERSISTENT_SEQUENTIAL;
        Assert.assertEquals((long)cm.toFlag(), (long)2L);
        Assert.assertFalse((boolean)cm.isEphemeral());
        Assert.assertTrue((boolean)cm.isSequential());
        cm = CreateMode.EPHEMERAL_SEQUENTIAL;
        Assert.assertEquals((long)cm.toFlag(), (long)3L);
        Assert.assertTrue((boolean)cm.isEphemeral());
        Assert.assertTrue((boolean)cm.isSequential());
    }

    @Test
    public void testFlagConversion() throws KeeperException {
        EnumSet<CreateMode> allModes = EnumSet.allOf(CreateMode.class);
        for (CreateMode cm : allModes) {
            Assert.assertEquals((Object)((Object)cm), (Object)((Object)CreateMode.fromFlag(cm.toFlag())));
        }
    }

    @Test
    public void testInvalidFlagConversion() throws KeeperException {
        CreateMode cm;
        try {
            cm = CreateMode.fromFlag(99);
            Assert.fail((String)"Shouldn't be able to convert 99 to a CreateMode.");
        }
        catch (KeeperException ke) {
            Assert.assertEquals((Object)KeeperException.Code.BADARGUMENTS, (Object)ke.code());
        }
        try {
            cm = CreateMode.fromFlag(-1);
            Assert.fail((String)"Shouldn't be able to convert -1 to a CreateMode.");
        }
        catch (KeeperException ke) {
            Assert.assertEquals((Object)KeeperException.Code.BADARGUMENTS, (Object)ke.code());
        }
    }
}

