/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.org.apache.zookeeper.test;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.apache.hive.org.apache.zookeeper.CreateMode;
import org.apache.hive.org.apache.zookeeper.PortAssignment;
import org.apache.hive.org.apache.zookeeper.WatchedEvent;
import org.apache.hive.org.apache.zookeeper.Watcher;
import org.apache.hive.org.apache.zookeeper.ZKTestCase;
import org.apache.hive.org.apache.zookeeper.ZooDefs;
import org.apache.hive.org.apache.zookeeper.ZooKeeper;
import org.apache.hive.org.apache.zookeeper.data.ACL;
import org.apache.hive.org.apache.zookeeper.data.Stat;
import org.apache.hive.org.apache.zookeeper.server.ServerCnxnFactory;
import org.apache.hive.org.apache.zookeeper.server.SyncRequestProcessor;
import org.apache.hive.org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.hive.org.apache.zookeeper.test.ACLTest;
import org.apache.hive.org.apache.zookeeper.test.ClientBase;
import org.apache.hive.org.slf4j.Logger;
import org.apache.hive.org.slf4j.LoggerFactory;
import org.junit.Assert;
import org.junit.Test;

public class ACLCountTest
extends ZKTestCase
implements Watcher {
    private static final Logger LOG = LoggerFactory.getLogger(ACLTest.class);
    private static final String HOSTPORT = "127.0.0.1:" + PortAssignment.unique();
    private volatile CountDownLatch startSignal;

    @Test
    public void testAclCount() throws Exception {
        File tmpDir = ClientBase.createTmpDir();
        ClientBase.setupTestEnv();
        ZooKeeperServer zks = new ZooKeeperServer(tmpDir, tmpDir, 3000);
        SyncRequestProcessor.setSnapCount(1000);
        int PORT = Integer.parseInt(HOSTPORT.split(":")[1]);
        ServerCnxnFactory f = ServerCnxnFactory.createFactory(PORT, -1);
        f.startup(zks);
        ArrayList<ACL> CREATOR_ALL_AND_WORLD_READABLE = new ArrayList<ACL>(){
            {
                this.add(new ACL(1, ZooDefs.Ids.ANYONE_ID_UNSAFE));
                this.add(new ACL(31, ZooDefs.Ids.AUTH_IDS));
                this.add(new ACL(1, ZooDefs.Ids.ANYONE_ID_UNSAFE));
                this.add(new ACL(31, ZooDefs.Ids.AUTH_IDS));
            }
        };
        try {
            LOG.info("starting up the zookeeper server .. waiting");
            Assert.assertTrue((String)"waiting for server being up", (boolean)ClientBase.waitForServerUp(HOSTPORT, ClientBase.CONNECTION_TIMEOUT));
            ZooKeeper zk = new ZooKeeper(HOSTPORT, ClientBase.CONNECTION_TIMEOUT, this);
            zk.addAuthInfo("digest", "pat:test".getBytes());
            zk.setACL("/", ZooDefs.Ids.CREATOR_ALL_ACL, -1);
            String path = "/path";
            try {
                Assert.assertEquals((long)4L, (long)CREATOR_ALL_AND_WORLD_READABLE.size());
            }
            catch (Exception e) {
                LOG.error("Something is fundamentally wrong with ArrayList's add() method. add()ing four times to an empty ArrayList should result in an ArrayList with 4 members.");
                throw e;
            }
            zk.create(path, path.getBytes(), (List<ACL>)CREATOR_ALL_AND_WORLD_READABLE, CreateMode.PERSISTENT);
            List<ACL> acls = zk.getACL("/path", new Stat());
            Assert.assertEquals((long)2L, (long)acls.size());
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)false);
        }
        f.shutdown();
        zks.shutdown();
    }

    public void process(WatchedEvent event) {
        LOG.info("Event:" + (Object)((Object)event.getState()) + " " + (Object)((Object)event.getType()) + " " + event.getPath());
        if (event.getState() == Watcher.Event.KeeperState.SyncConnected) {
            if (this.startSignal != null && this.startSignal.getCount() > 0L) {
                LOG.info("startsignal.countDown()");
                this.startSignal.countDown();
            } else {
                LOG.warn("startsignal " + this.startSignal);
            }
        }
    }
}

