/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.org.apache.zookeeper.server.quorum;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.hive.org.apache.log4j.Appender;
import org.apache.hive.org.apache.log4j.Layout;
import org.apache.hive.org.apache.log4j.Level;
import org.apache.hive.org.apache.log4j.Logger;
import org.apache.hive.org.apache.log4j.Priority;
import org.apache.hive.org.apache.log4j.WriterAppender;
import org.apache.hive.org.apache.zookeeper.CreateMode;
import org.apache.hive.org.apache.zookeeper.KeeperException;
import org.apache.hive.org.apache.zookeeper.PortAssignment;
import org.apache.hive.org.apache.zookeeper.ZooDefs;
import org.apache.hive.org.apache.zookeeper.ZooKeeper;
import org.apache.hive.org.apache.zookeeper.common.AtomicFileOutputStream;
import org.apache.hive.org.apache.zookeeper.server.quorum.Leader;
import org.apache.hive.org.apache.zookeeper.server.quorum.QuorumPeerTestBase;
import org.apache.hive.org.apache.zookeeper.server.util.ZxidUtils;
import org.apache.hive.org.apache.zookeeper.test.ClientBase;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class QuorumPeerMainTest
extends QuorumPeerTestBase {
    protected static final Logger LOG = Logger.getLogger(QuorumPeerMainTest.class);
    private Servers servers;
    private int numServers = 0;

    @After
    public void tearDown() throws Exception {
        if (this.servers == null || this.servers.mt == null) {
            LOG.info("No servers to shutdown!");
            return;
        }
        for (int i = 0; i < this.numServers; ++i) {
            if (i >= this.servers.mt.length) continue;
            this.servers.mt[i].shutdown();
        }
    }

    @Test
    public void testQuorum() throws Exception {
        ClientBase.setupTestEnv();
        int CLIENT_PORT_QP1 = PortAssignment.unique();
        int CLIENT_PORT_QP2 = PortAssignment.unique();
        String quorumCfgSection = "server.1=127.0.0.1:" + PortAssignment.unique() + ":" + PortAssignment.unique() + "\nserver.2=127.0.0.1:" + PortAssignment.unique() + ":" + PortAssignment.unique();
        QuorumPeerTestBase.MainThread q1 = new QuorumPeerTestBase.MainThread(1, CLIENT_PORT_QP1, quorumCfgSection);
        QuorumPeerTestBase.MainThread q2 = new QuorumPeerTestBase.MainThread(2, CLIENT_PORT_QP2, quorumCfgSection);
        q1.start();
        q2.start();
        Assert.assertTrue((String)"waiting for server 1 being up", (boolean)ClientBase.waitForServerUp("127.0.0.1:" + CLIENT_PORT_QP1, ClientBase.CONNECTION_TIMEOUT));
        Assert.assertTrue((String)"waiting for server 2 being up", (boolean)ClientBase.waitForServerUp("127.0.0.1:" + CLIENT_PORT_QP2, ClientBase.CONNECTION_TIMEOUT));
        ZooKeeper zk = new ZooKeeper("127.0.0.1:" + CLIENT_PORT_QP1, ClientBase.CONNECTION_TIMEOUT, this);
        this.waitForOne(zk, ZooKeeper.States.CONNECTED);
        zk.create("/foo_q1", "foobar1".getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        Assert.assertEquals((Object)new String(zk.getData("/foo_q1", null, null)), (Object)"foobar1");
        zk.close();
        zk = new ZooKeeper("127.0.0.1:" + CLIENT_PORT_QP2, ClientBase.CONNECTION_TIMEOUT, this);
        this.waitForOne(zk, ZooKeeper.States.CONNECTED);
        zk.create("/foo_q2", "foobar2".getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        Assert.assertEquals((Object)new String(zk.getData("/foo_q2", null, null)), (Object)"foobar2");
        zk.close();
        q1.shutdown();
        q2.shutdown();
        Assert.assertTrue((String)"waiting for server 1 down", (boolean)ClientBase.waitForServerDown("127.0.0.1:" + CLIENT_PORT_QP1, ClientBase.CONNECTION_TIMEOUT));
        Assert.assertTrue((String)"waiting for server 2 down", (boolean)ClientBase.waitForServerDown("127.0.0.1:" + CLIENT_PORT_QP2, ClientBase.CONNECTION_TIMEOUT));
    }

    @Test
    public void testEarlyLeaderAbandonment() throws Exception {
        int i;
        int i2;
        ClientBase.setupTestEnv();
        int SERVER_COUNT = 3;
        int[] clientPorts = new int[3];
        StringBuilder sb = new StringBuilder();
        for (int i3 = 0; i3 < 3; ++i3) {
            clientPorts[i3] = PortAssignment.unique();
            sb.append("server." + i3 + "=127.0.0.1:" + PortAssignment.unique() + ":" + PortAssignment.unique() + "\n");
        }
        String quorumCfgSection = sb.toString();
        QuorumPeerTestBase.MainThread[] mt = new QuorumPeerTestBase.MainThread[3];
        ZooKeeper[] zk = new ZooKeeper[3];
        for (i2 = 0; i2 < 3; ++i2) {
            mt[i2] = new QuorumPeerTestBase.MainThread(i2, clientPorts[i2], quorumCfgSection);
            mt[i2].start();
            zk[i2] = new ZooKeeper("127.0.0.1:" + clientPorts[i2], ClientBase.CONNECTION_TIMEOUT, this);
        }
        this.waitForAll(zk, ZooKeeper.States.CONNECTED);
        for (i2 = 0; i2 < 3; ++i2) {
            mt[i2].shutdown();
        }
        this.waitForAll(zk, ZooKeeper.States.CONNECTING);
        for (i2 = 0; i2 < 3; ++i2) {
            mt[i2].start();
        }
        this.waitForAll(zk, ZooKeeper.States.CONNECTED);
        int leader = -1;
        ConcurrentMap<Long, Leader.Proposal> outstanding = null;
        for (int i4 = 0; i4 < 3; ++i4) {
            if (mt[i4].main.quorumPeer.leader == null) {
                mt[i4].shutdown();
                continue;
            }
            leader = i4;
            outstanding = mt[leader].main.quorumPeer.leader.outstandingProposals;
        }
        try {
            zk[leader].create("/zk" + leader, "zk".getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            Assert.fail((String)("create /zk" + leader + " should have failed"));
        }
        catch (KeeperException e) {
            // empty catch block
        }
        Assert.assertTrue((outstanding.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((((Leader.Proposal)outstanding.values().iterator().next()).request.hdr.getType() == 1 ? 1 : 0) != 0);
        Thread.sleep(1000L);
        mt[leader].shutdown();
        this.waitForAll(zk, ZooKeeper.States.CONNECTING);
        for (i = 0; i < 3; ++i) {
            if (i == leader) continue;
            mt[i].start();
        }
        for (i = 0; i < 3; ++i) {
            if (i == leader) continue;
            this.waitForOne(zk[i], ZooKeeper.States.CONNECTED);
            zk[i].create("/zk" + i, "zk".getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        }
        mt[leader].start();
        this.waitForAll(zk, ZooKeeper.States.CONNECTED);
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                if (i == leader) {
                    Assert.assertTrue((String)((j == leader ? "Leader (" + leader + ")" : "Follower " + j) + " should not have /zk" + i), (zk[j].exists("/zk" + i, false) == null ? 1 : 0) != 0);
                    continue;
                }
                Assert.assertTrue((String)((j == leader ? "Leader (" + leader + ")" : "Follower " + j) + " does not have /zk" + i), (zk[j].exists("/zk" + i, false) != null ? 1 : 0) != 0);
            }
        }
        for (i = 0; i < 3; ++i) {
            zk[i].close();
        }
        for (i = 0; i < 3; ++i) {
            mt[i].shutdown();
        }
    }

    @Test
    public void testHighestZxidJoinLate() throws Exception {
        int i;
        this.numServers = 3;
        this.servers = this.LaunchServers(this.numServers);
        String path = "/hzxidtest";
        int leader = -1;
        for (int i2 = 0; i2 < this.numServers; ++i2) {
            if (this.servers.mt[i2].main.quorumPeer.leader == null) continue;
            leader = i2;
        }
        Assert.assertTrue((String)"There should be a leader", (leader >= 0 ? 1 : 0) != 0);
        int nonleader = (leader + 1) % this.numServers;
        byte[] input = new byte[]{1};
        this.servers.zk[leader].create(path + leader, input, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        this.servers.zk[leader].create(path + nonleader, input, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        byte[] output = this.servers.zk[leader].getData(path + nonleader, false, null);
        for (i = 0; i < this.numServers; ++i) {
            if (i == leader) continue;
            this.servers.mt[i].shutdown();
        }
        input[0] = 2;
        this.servers.zk[leader].setData(path + leader, input, -1, null, null);
        Thread.sleep(500L);
        this.servers.mt[leader].shutdown();
        System.gc();
        this.waitForAll(this.servers.zk, ZooKeeper.States.CONNECTING);
        for (i = 0; i < this.numServers; ++i) {
            if (i == leader) continue;
            this.servers.mt[i].start();
        }
        this.waitForOne(this.servers.zk[nonleader], ZooKeeper.States.CONNECTED);
        output = this.servers.zk[nonleader].getData(path + leader, false, null);
        Assert.assertEquals((String)"Expecting old value 1 since 2 isn't committed yet", (long)output[0], (long)1L);
        this.servers.zk[nonleader].setData(path + nonleader, input, -1);
        this.servers.mt[leader].start();
        this.waitForOne(this.servers.zk[leader], ZooKeeper.States.CONNECTED);
        output = this.servers.zk[leader].getData(path + leader, false, null);
        Assert.assertEquals((String)"Validating that the deposed leader has rolled back that change it had written", (long)output[0], (long)1L);
        output = this.servers.zk[leader].getData(path + nonleader, false, null);
        Assert.assertEquals((String)"Validating that the deposed leader caught up on changes it missed", (long)output[0], (long)2L);
    }

    private void waitForOne(ZooKeeper zk, ZooKeeper.States state) throws InterruptedException {
        while (zk.getState() != state) {
            Thread.sleep(500L);
        }
    }

    private void waitForAll(ZooKeeper[] zks, ZooKeeper.States state) throws InterruptedException {
        int iterations = 10;
        boolean someoneNotConnected = true;
        while (someoneNotConnected) {
            if (iterations-- == 0) {
                ClientBase.logAllStackTraces();
                throw new RuntimeException("Waiting too long");
            }
            someoneNotConnected = false;
            for (ZooKeeper zk : zks) {
                if (zk.getState() == state) continue;
                someoneNotConnected = true;
            }
            Thread.sleep(1000L);
        }
    }

    private Servers LaunchServers(int numServers) throws IOException, InterruptedException {
        int SERVER_COUNT = numServers;
        Servers svrs = new Servers();
        int[] clientPorts = new int[SERVER_COUNT];
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < SERVER_COUNT; ++i) {
            clientPorts[i] = PortAssignment.unique();
            sb.append("server." + i + "=127.0.0.1:" + PortAssignment.unique() + ":" + PortAssignment.unique() + "\n");
        }
        String quorumCfgSection = sb.toString();
        QuorumPeerTestBase.MainThread[] mt = new QuorumPeerTestBase.MainThread[SERVER_COUNT];
        ZooKeeper[] zk = new ZooKeeper[SERVER_COUNT];
        for (int i = 0; i < SERVER_COUNT; ++i) {
            mt[i] = new QuorumPeerTestBase.MainThread(i, clientPorts[i], quorumCfgSection);
            mt[i].start();
            zk[i] = new ZooKeeper("127.0.0.1:" + clientPorts[i], ClientBase.CONNECTION_TIMEOUT, this);
        }
        this.waitForAll(zk, ZooKeeper.States.CONNECTED);
        svrs.mt = mt;
        svrs.zk = zk;
        return svrs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBadPeerAddressInQuorum() throws Exception {
        String line;
        ClientBase.setupTestEnv();
        Layout layout = Logger.getRootLogger().getAppender("CONSOLE").getLayout();
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        WriterAppender appender = new WriterAppender(layout, (OutputStream)os);
        appender.setThreshold((Priority)Level.WARN);
        Logger qlogger = Logger.getLogger("org.apache.hive.org.apache.zookeeper.server.quorum");
        qlogger.addAppender((Appender)appender);
        try {
            int CLIENT_PORT_QP1 = PortAssignment.unique();
            int CLIENT_PORT_QP2 = PortAssignment.unique();
            String quorumCfgSection = "server.1=127.0.0.1:" + PortAssignment.unique() + ":" + PortAssignment.unique() + "\nserver.2=fee.fii.foo.fum:" + PortAssignment.unique() + ":" + PortAssignment.unique();
            QuorumPeerTestBase.MainThread q1 = new QuorumPeerTestBase.MainThread(1, CLIENT_PORT_QP1, quorumCfgSection);
            q1.start();
            boolean isup = ClientBase.waitForServerUp("127.0.0.1:" + CLIENT_PORT_QP1, 30000L);
            Assert.assertFalse((String)"Server never came up", (boolean)isup);
            q1.shutdown();
            Assert.assertTrue((String)"waiting for server 1 down", (boolean)ClientBase.waitForServerDown("127.0.0.1:" + CLIENT_PORT_QP1, ClientBase.CONNECTION_TIMEOUT));
        }
        finally {
            qlogger.removeAppender((Appender)appender);
        }
        LineNumberReader r = new LineNumberReader(new StringReader(os.toString()));
        boolean found = false;
        Pattern p = Pattern.compile(".*Cannot open channel to .* at election address .*");
        while ((line = r.readLine()) != null && !(found = p.matcher(line).matches())) {
        }
        Assert.assertTrue((String)"complains about host", (boolean)found);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInconsistentPeerType() throws Exception {
        String line;
        ClientBase.setupTestEnv();
        Layout layout = Logger.getRootLogger().getAppender("CONSOLE").getLayout();
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        WriterAppender appender = new WriterAppender(layout, (OutputStream)os);
        appender.setThreshold((Priority)Level.INFO);
        Logger qlogger = Logger.getLogger("org.apache.hive.org.apache.zookeeper.server.quorum");
        qlogger.addAppender((Appender)appender);
        try {
            int CLIENT_PORT_QP1 = PortAssignment.unique();
            int CLIENT_PORT_QP2 = PortAssignment.unique();
            int CLIENT_PORT_QP3 = PortAssignment.unique();
            String quorumCfgSection = "server.1=127.0.0.1:" + PortAssignment.unique() + ":" + PortAssignment.unique() + "\nserver.2=127.0.0.1:" + PortAssignment.unique() + ":" + PortAssignment.unique() + "\nserver.3=127.0.0.1:" + PortAssignment.unique() + ":" + PortAssignment.unique() + ":observer";
            QuorumPeerTestBase.MainThread q1 = new QuorumPeerTestBase.MainThread(1, CLIENT_PORT_QP1, quorumCfgSection);
            QuorumPeerTestBase.MainThread q2 = new QuorumPeerTestBase.MainThread(2, CLIENT_PORT_QP2, quorumCfgSection);
            QuorumPeerTestBase.MainThread q3 = new QuorumPeerTestBase.MainThread(3, CLIENT_PORT_QP3, quorumCfgSection);
            q1.start();
            q2.start();
            q3.start();
            Assert.assertTrue((String)"waiting for server 1 being up", (boolean)ClientBase.waitForServerUp("127.0.0.1:" + CLIENT_PORT_QP1, ClientBase.CONNECTION_TIMEOUT));
            Assert.assertTrue((String)"waiting for server 2 being up", (boolean)ClientBase.waitForServerUp("127.0.0.1:" + CLIENT_PORT_QP2, ClientBase.CONNECTION_TIMEOUT));
            Assert.assertTrue((String)"waiting for server 3 being up", (boolean)ClientBase.waitForServerUp("127.0.0.1:" + CLIENT_PORT_QP3, ClientBase.CONNECTION_TIMEOUT));
            q1.shutdown();
            q2.shutdown();
            q3.shutdown();
            Assert.assertTrue((String)"waiting for server 1 down", (boolean)ClientBase.waitForServerDown("127.0.0.1:" + CLIENT_PORT_QP1, ClientBase.CONNECTION_TIMEOUT));
            Assert.assertTrue((String)"waiting for server 2 down", (boolean)ClientBase.waitForServerDown("127.0.0.1:" + CLIENT_PORT_QP2, ClientBase.CONNECTION_TIMEOUT));
            Assert.assertTrue((String)"waiting for server 3 down", (boolean)ClientBase.waitForServerDown("127.0.0.1:" + CLIENT_PORT_QP3, ClientBase.CONNECTION_TIMEOUT));
        }
        finally {
            qlogger.removeAppender((Appender)appender);
        }
        LineNumberReader r = new LineNumberReader(new StringReader(os.toString()));
        boolean warningPresent = false;
        boolean defaultedToObserver = false;
        Pattern pWarn = Pattern.compile(".*Peer type from servers list.* doesn't match peerType.*");
        Pattern pObserve = Pattern.compile(".*OBSERVING.*");
        while ((line = r.readLine()) != null) {
            if (pWarn.matcher(line).matches()) {
                warningPresent = true;
            }
            if (pObserve.matcher(line).matches()) {
                defaultedToObserver = true;
            }
            if (!warningPresent || !defaultedToObserver) continue;
        }
        Assert.assertTrue((String)"Should warn about inconsistent peer type", (warningPresent && defaultedToObserver ? 1 : 0) != 0);
    }

    @Test
    public void testBadPackets() throws Exception {
        ClientBase.setupTestEnv();
        int CLIENT_PORT_QP1 = PortAssignment.unique();
        int CLIENT_PORT_QP2 = PortAssignment.unique();
        int electionPort1 = PortAssignment.unique();
        int electionPort2 = PortAssignment.unique();
        String quorumCfgSection = "server.1=127.0.0.1:" + PortAssignment.unique() + ":" + electionPort1 + "\nserver.2=127.0.0.1:" + PortAssignment.unique() + ":" + electionPort2;
        QuorumPeerTestBase.MainThread q1 = new QuorumPeerTestBase.MainThread(1, CLIENT_PORT_QP1, quorumCfgSection);
        QuorumPeerTestBase.MainThread q2 = new QuorumPeerTestBase.MainThread(2, CLIENT_PORT_QP2, quorumCfgSection);
        q1.start();
        q2.start();
        Assert.assertTrue((String)"waiting for server 1 being up", (boolean)ClientBase.waitForServerUp("127.0.0.1:" + CLIENT_PORT_QP1, ClientBase.CONNECTION_TIMEOUT));
        Assert.assertTrue((String)"waiting for server 2 being up", (boolean)ClientBase.waitForServerUp("127.0.0.1:" + CLIENT_PORT_QP2, ClientBase.CONNECTION_TIMEOUT));
        byte[] b = new byte[4];
        int length = 0x40000000;
        ByteBuffer buff = ByteBuffer.wrap(b);
        buff.putInt(length);
        buff.position(0);
        SocketChannel s = SocketChannel.open(new InetSocketAddress("127.0.0.1", electionPort1));
        s.write(buff);
        s.close();
        buff.position(0);
        s = SocketChannel.open(new InetSocketAddress("127.0.0.1", electionPort2));
        s.write(buff);
        s.close();
        ZooKeeper zk = new ZooKeeper("127.0.0.1:" + CLIENT_PORT_QP1, ClientBase.CONNECTION_TIMEOUT, this);
        this.waitForOne(zk, ZooKeeper.States.CONNECTED);
        zk.create("/foo_q1", "foobar1".getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        Assert.assertEquals((Object)new String(zk.getData("/foo_q1", null, null)), (Object)"foobar1");
        zk.close();
        q1.shutdown();
        q2.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testQuorumDefaults() throws Exception {
        String line;
        ClientBase.setupTestEnv();
        Layout layout = Logger.getRootLogger().getAppender("CONSOLE").getLayout();
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        WriterAppender appender = new WriterAppender(layout, (OutputStream)os);
        appender.setImmediateFlush(true);
        appender.setThreshold((Priority)Level.INFO);
        Logger zlogger = Logger.getLogger("org.apache.hive.org.apache.zookeeper");
        zlogger.addAppender((Appender)appender);
        try {
            int CLIENT_PORT_QP1 = PortAssignment.unique();
            int CLIENT_PORT_QP2 = PortAssignment.unique();
            String quorumCfgSection = "server.1=127.0.0.1:" + PortAssignment.unique() + ":" + PortAssignment.unique() + "\nserver.2=127.0.0.1:" + PortAssignment.unique() + ":" + PortAssignment.unique();
            QuorumPeerTestBase.MainThread q1 = new QuorumPeerTestBase.MainThread(1, CLIENT_PORT_QP1, quorumCfgSection);
            QuorumPeerTestBase.MainThread q2 = new QuorumPeerTestBase.MainThread(2, CLIENT_PORT_QP2, quorumCfgSection);
            q1.start();
            q2.start();
            Assert.assertTrue((String)"waiting for server 1 being up", (boolean)ClientBase.waitForServerUp("127.0.0.1:" + CLIENT_PORT_QP1, ClientBase.CONNECTION_TIMEOUT));
            Assert.assertTrue((String)"waiting for server 2 being up", (boolean)ClientBase.waitForServerUp("127.0.0.1:" + CLIENT_PORT_QP2, ClientBase.CONNECTION_TIMEOUT));
            q1.shutdown();
            q2.shutdown();
            Assert.assertTrue((String)"waiting for server 1 down", (boolean)ClientBase.waitForServerDown("127.0.0.1:" + CLIENT_PORT_QP1, ClientBase.CONNECTION_TIMEOUT));
            Assert.assertTrue((String)"waiting for server 2 down", (boolean)ClientBase.waitForServerDown("127.0.0.1:" + CLIENT_PORT_QP2, ClientBase.CONNECTION_TIMEOUT));
        }
        finally {
            zlogger.removeAppender((Appender)appender);
        }
        os.close();
        LineNumberReader r = new LineNumberReader(new StringReader(os.toString()));
        boolean found = false;
        Pattern p = Pattern.compile(".*FastLeaderElection.*");
        while ((line = r.readLine()) != null && !(found = p.matcher(line).matches())) {
        }
        Assert.assertTrue((String)"fastleaderelection used", (boolean)found);
    }

    @Test
    public void testQuorumPeerExitTime() throws Exception {
        long maxwait = 3000L;
        int CLIENT_PORT_QP1 = PortAssignment.unique();
        String quorumCfgSection = "server.1=127.0.0.1:" + PortAssignment.unique() + ":" + PortAssignment.unique() + "\nserver.2=127.0.0.1:" + PortAssignment.unique() + ":" + PortAssignment.unique();
        QuorumPeerTestBase.MainThread q1 = new QuorumPeerTestBase.MainThread(1, CLIENT_PORT_QP1, quorumCfgSection);
        q1.start();
        Thread.sleep(30000L);
        long start = System.currentTimeMillis();
        q1.shutdown();
        long end = System.currentTimeMillis();
        if (end - start > maxwait) {
            Assert.fail((String)("QuorumPeer took " + (end - start) + " to shutdown, expected " + maxwait));
        }
    }

    static long readLongFromFile(File file) throws IOException {
        BufferedReader br = new BufferedReader(new FileReader(file));
        String line = "";
        try {
            line = br.readLine();
            long l = Long.parseLong(line);
            return l;
        }
        catch (NumberFormatException e) {
            throw new IOException("Found " + line + " in " + file);
        }
        finally {
            br.close();
        }
    }

    static void writeLongToFile(File file, long value) throws IOException {
        AtomicFileOutputStream out = new AtomicFileOutputStream(file);
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(out));
        try {
            bw.write(Long.toString(value));
            bw.flush();
            out.flush();
            out.close();
        }
        catch (IOException e) {
            LOG.error("Failed to write new file " + file, e);
            out.abort();
            throw e;
        }
    }

    @Test
    public void testUpdatingEpoch() throws Exception {
        File currentEpochFile;
        int i;
        this.numServers = 3;
        this.servers = this.LaunchServers(this.numServers);
        for (i = 0; i < 10; ++i) {
            int j;
            for (j = 0; j < this.numServers; ++j) {
                this.servers.mt[j].shutdown();
            }
            this.waitForAll(this.servers.zk, ZooKeeper.States.CONNECTING);
            for (j = 0; j < this.numServers; ++j) {
                this.servers.mt[j].start();
            }
            this.waitForAll(this.servers.zk, ZooKeeper.States.CONNECTED);
        }
        for (i = 0; i < this.numServers; ++i) {
            currentEpochFile = new File(new File(this.servers.mt[i].dataDir, "version-2"), "currentEpoch");
            LOG.info("Validating current epoch: " + this.servers.mt[i].dataDir);
            Assert.assertEquals((String)"Current epoch should be 11.", (long)11L, (long)QuorumPeerMainTest.readLongFromFile(currentEpochFile));
        }
        int followerIndex = -1;
        for (int i2 = 0; i2 < this.numServers; ++i2) {
            if (this.servers.mt[i2].main.quorumPeer.leader != null) continue;
            followerIndex = i2;
            break;
        }
        Assert.assertTrue((String)"Found a valid follower", (followerIndex >= 0 && followerIndex < this.numServers ? 1 : 0) != 0);
        QuorumPeerTestBase.MainThread follower = this.servers.mt[followerIndex];
        long zxid = follower.main.quorumPeer.getLastLoggedZxid();
        long epochFromZxid = ZxidUtils.getEpochFromZxid(zxid);
        for (int i3 = 0; i3 < this.numServers; ++i3) {
            this.servers.mt[i3].shutdown();
        }
        this.waitForAll(this.servers.zk, ZooKeeper.States.CONNECTING);
        File followerDataDir = new File(follower.dataDir, "version-2");
        currentEpochFile = new File(followerDataDir, "currentEpoch");
        QuorumPeerMainTest.writeLongToFile(currentEpochFile, epochFromZxid - 1L);
        follower.start();
        Assert.assertTrue((boolean)follower.mainFailed.await(10L, TimeUnit.SECONDS));
        File updatingEpochFile = new File(followerDataDir, "updatingEpoch");
        updatingEpochFile.createNewFile();
        for (int i4 = 0; i4 < this.numServers; ++i4) {
            this.servers.mt[i4].start();
        }
        this.waitForAll(this.servers.zk, ZooKeeper.States.CONNECTED);
        Assert.assertNotNull((String)"Make sure the server started with acceptEpoch", (Object)follower.main.quorumPeer.getActiveServer());
        Assert.assertFalse((String)"updatingEpoch file should get deleted", (boolean)updatingEpochFile.exists());
    }

    private class Servers {
        QuorumPeerTestBase.MainThread[] mt;
        ZooKeeper[] zk;

        private Servers() {
        }
    }
}

