/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.org.apache.zookeeper.server.quorum;

import java.io.PrintWriter;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hive.org.apache.zookeeper.server.SessionTracker;
import org.apache.hive.org.apache.zookeeper.server.SessionTrackerImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LearnerSessionTracker
implements SessionTracker {
    SessionTracker.SessionExpirer expirer;
    HashMap<Long, Integer> touchTable = new HashMap();
    long serverId = 1L;
    long nextSessionId = 0L;
    private ConcurrentHashMap<Long, Integer> sessionsWithTimeouts;

    public LearnerSessionTracker(SessionTracker.SessionExpirer expirer, ConcurrentHashMap<Long, Integer> sessionsWithTimeouts, long id) {
        this.expirer = expirer;
        this.sessionsWithTimeouts = sessionsWithTimeouts;
        this.serverId = id;
        this.nextSessionId = SessionTrackerImpl.initializeNextSession(this.serverId);
    }

    @Override
    public synchronized void removeSession(long sessionId) {
        this.sessionsWithTimeouts.remove(sessionId);
        this.touchTable.remove(sessionId);
    }

    @Override
    public void shutdown() {
    }

    @Override
    public synchronized void addSession(long sessionId, int sessionTimeout) {
        this.sessionsWithTimeouts.put(sessionId, sessionTimeout);
        this.touchTable.put(sessionId, sessionTimeout);
    }

    @Override
    public synchronized boolean touchSession(long sessionId, int sessionTimeout) {
        this.touchTable.put(sessionId, sessionTimeout);
        return true;
    }

    synchronized HashMap<Long, Integer> snapshot() {
        HashMap<Long, Integer> oldTouchTable = this.touchTable;
        this.touchTable = new HashMap();
        return oldTouchTable;
    }

    @Override
    public synchronized long createSession(int sessionTimeout) {
        return this.nextSessionId++;
    }

    @Override
    public void checkSession(long sessionId, Object owner) {
    }

    @Override
    public void setOwner(long sessionId, Object owner) {
    }

    @Override
    public void dumpSessions(PrintWriter pwriter) {
        pwriter.println(this.toString());
    }

    @Override
    public void setSessionClosing(long sessionId) {
    }
}

