/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.org.apache.zookeeper.server.quorum;

import java.nio.ByteBuffer;
import org.apache.hive.org.apache.zookeeper.server.quorum.FastLeaderElection;
import org.apache.hive.org.apache.zookeeper.server.quorum.QuorumPeer;
import org.apache.hive.org.apache.zookeeper.server.quorum.Vote;
import org.apache.hive.org.slf4j.Logger;
import org.apache.hive.org.slf4j.LoggerFactory;
import org.junit.Assert;

public class FLETestUtils {
    protected static final Logger LOG = LoggerFactory.getLogger(FLETestUtils.class);

    static ByteBuffer createMsg(int state, long leader, long zxid, long epoch) {
        return FastLeaderElection.buildMsg(state, leader, zxid, 1L, epoch);
    }

    static class LEThread
    extends Thread {
        private int i;
        private QuorumPeer peer;

        LEThread(QuorumPeer peer, int i) {
            this.i = i;
            this.peer = peer;
            LOG.info("Constructor: " + this.getName());
        }

        public void run() {
            try {
                Vote v = null;
                this.peer.setPeerState(QuorumPeer.ServerState.LOOKING);
                LOG.info("Going to call leader election: " + this.i);
                v = this.peer.getElectionAlg().lookForLeader();
                if (v == null) {
                    Assert.fail((String)("Thread " + this.i + " got a null vote"));
                }
                this.peer.setCurrentVote(v);
                LOG.info("Finished election: " + this.i + ", " + v.getId());
                Assert.assertTrue((String)"State is not leading.", (this.peer.getPeerState() == QuorumPeer.ServerState.LEADING ? 1 : 0) != 0);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            LOG.info("Joining");
        }
    }
}

