/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.org.apache.zookeeper.server.quorum;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.HashMap;
import org.apache.hive.org.apache.zookeeper.PortAssignment;
import org.apache.hive.org.apache.zookeeper.ZKTestCase;
import org.apache.hive.org.apache.zookeeper.server.quorum.FLETestUtils;
import org.apache.hive.org.apache.zookeeper.server.quorum.FastLeaderElection;
import org.apache.hive.org.apache.zookeeper.server.quorum.QuorumCnxManager;
import org.apache.hive.org.apache.zookeeper.server.quorum.QuorumPeer;
import org.apache.hive.org.apache.zookeeper.test.ClientBase;
import org.apache.hive.org.slf4j.Logger;
import org.apache.hive.org.slf4j.LoggerFactory;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FLELostMessageTest
extends ZKTestCase {
    protected static final Logger LOG = LoggerFactory.getLogger(FLELostMessageTest.class);
    int count;
    HashMap<Long, QuorumPeer.QuorumServer> peers;
    File[] tmpdir;
    int[] port;
    QuorumCnxManager cnxManager;

    @Before
    public void setUp() throws Exception {
        this.count = 3;
        this.peers = new HashMap(this.count);
        this.tmpdir = new File[this.count];
        this.port = new int[this.count];
    }

    @After
    public void tearDown() throws Exception {
        this.cnxManager.halt();
    }

    @Test
    public void testLostMessage() throws Exception {
        FastLeaderElection[] le = new FastLeaderElection[this.count];
        LOG.info("TestLE: " + this.getTestName() + ", " + this.count);
        for (int i = 0; i < this.count; ++i) {
            int clientport = PortAssignment.unique();
            this.peers.put(Long.valueOf(i), new QuorumPeer.QuorumServer(i, new InetSocketAddress(clientport), new InetSocketAddress(PortAssignment.unique())));
            this.tmpdir[i] = ClientBase.createTmpDir();
            this.port[i] = clientport;
        }
        QuorumPeer peer = new QuorumPeer(this.peers, this.tmpdir[1], this.tmpdir[1], this.port[1], 3, 1L, 1000, 2, 2);
        peer.startLeaderElection();
        FLETestUtils.LEThread thread = new FLETestUtils.LEThread(peer, 1);
        thread.start();
        this.mockServer();
        thread.join(5000L);
        if (thread.isAlive()) {
            Assert.fail((String)"Threads didn't join");
        }
    }

    void mockServer() throws InterruptedException, IOException {
        QuorumPeer peer = new QuorumPeer(this.peers, this.tmpdir[0], this.tmpdir[0], this.port[0], 3, 0L, 1000, 2, 2);
        this.cnxManager = new QuorumCnxManager(peer);
        QuorumCnxManager.Listener listener = this.cnxManager.listener;
        listener.start();
        this.cnxManager.toSend(1L, FLETestUtils.createMsg(QuorumPeer.ServerState.LOOKING.ordinal(), 0L, 0L, 0L));
        this.cnxManager.recvQueue.take();
        this.cnxManager.toSend(1L, FLETestUtils.createMsg(QuorumPeer.ServerState.FOLLOWING.ordinal(), 1L, 0L, 0L));
    }
}

