/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.org.apache.zookeeper.server.auth;

import org.apache.hive.org.apache.zookeeper.KeeperException;
import org.apache.hive.org.apache.zookeeper.server.ServerCnxn;
import org.apache.hive.org.apache.zookeeper.server.auth.AuthenticationProvider;
import org.apache.hive.org.apache.zookeeper.server.auth.KerberosName;

public class SASLAuthenticationProvider
implements AuthenticationProvider {
    public String getScheme() {
        return "sasl";
    }

    public KeeperException.Code handleAuthentication(ServerCnxn cnxn, byte[] authData) {
        return KeeperException.Code.AUTHFAILED;
    }

    public boolean matches(String id, String aclExpr) {
        if (System.getProperty("zookeeper.superUser") != null) {
            return id.equals(System.getProperty("zookeeper.superUser")) || id.equals(aclExpr);
        }
        return id.equals("super") || id.equals(aclExpr);
    }

    public boolean isAuthenticated() {
        return true;
    }

    public boolean isValid(String id) {
        try {
            new KerberosName(id);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }
}

