/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.org.apache.zookeeper.server;

import java.io.IOException;
import junit.framework.Assert;
import org.apache.hive.org.apache.zookeeper.CreateMode;
import org.apache.hive.org.apache.zookeeper.KeeperException;
import org.apache.hive.org.apache.zookeeper.TestableZooKeeper;
import org.apache.hive.org.apache.zookeeper.ZooDefs;
import org.apache.hive.org.apache.zookeeper.server.NIOServerCnxnFactory;
import org.apache.hive.org.apache.zookeeper.server.ServerCnxn;
import org.apache.hive.org.apache.zookeeper.test.ClientBase;
import org.apache.hive.org.slf4j.Logger;
import org.apache.hive.org.slf4j.LoggerFactory;
import org.junit.Test;

public class NIOServerCnxnTest
extends ClientBase {
    private static final Logger LOG = LoggerFactory.getLogger(NIOServerCnxnTest.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testOperationsAfterCnxnClose() throws IOException, InterruptedException, KeeperException {
        TestableZooKeeper zk = this.createClient();
        String path = "/a";
        try {
            zk.create("/a", "test".getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            Assert.assertNotNull((String)"Didn't create znode:/a", (Object)zk.exists("/a", false));
            Assert.assertTrue((String)"Didn't instantiate ServerCnxnFactory with NIOServerCnxnFactory!", (boolean)(this.serverFactory instanceof NIOServerCnxnFactory));
            Iterable<ServerCnxn> connections = this.serverFactory.getConnections();
            for (ServerCnxn serverCnxn : connections) {
                serverCnxn.close();
                try {
                    serverCnxn.toString();
                }
                catch (Exception e) {
                    LOG.error("Exception while getting connection details!", e);
                    Assert.fail((String)"Shouldn't throw exception while getting connection details!");
                }
            }
        }
        finally {
            zk.close();
        }
    }
}

