/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.org.apache.zookeeper.server;

import java.io.File;
import java.io.RandomAccessFile;
import org.apache.hive.org.apache.zookeeper.CreateMode;
import org.apache.hive.org.apache.zookeeper.TestableZooKeeper;
import org.apache.hive.org.apache.zookeeper.ZooDefs;
import org.apache.hive.org.apache.zookeeper.server.NIOServerCnxnFactory;
import org.apache.hive.org.apache.zookeeper.server.SyncRequestProcessor;
import org.apache.hive.org.apache.zookeeper.test.ClientBase;
import org.apache.hive.org.slf4j.Logger;
import org.apache.hive.org.slf4j.LoggerFactory;
import org.junit.Assert;
import org.junit.Test;

public class InvalidSnapshotTest
extends ClientBase {
    private static final Logger LOG = LoggerFactory.getLogger(InvalidSnapshotTest.class);

    public InvalidSnapshotTest() {
        SyncRequestProcessor.setSnapCount(100);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInvalidSnapshot() throws Exception {
        TestableZooKeeper zk = this.createClient();
        try {
            for (int i = 0; i < 2000; ++i) {
                zk.create("/invalidsnap-" + i, new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            }
        }
        finally {
            zk.close();
        }
        NIOServerCnxnFactory factory = (NIOServerCnxnFactory)this.serverFactory;
        this.stopServer();
        File snapFile = factory.zkServer.getTxnLogFactory().findMostRecentSnapshot();
        LOG.info("Corrupting " + snapFile);
        RandomAccessFile raf = new RandomAccessFile(snapFile, "rws");
        raf.setLength(3L);
        raf.close();
        this.startServer();
        zk = this.createClient();
        try {
            Assert.assertTrue((String)"the node should exist", (zk.exists("/invalidsnap-1999", false) != null ? 1 : 0) != 0);
        }
        finally {
            zk.close();
        }
    }
}

