/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.org.apache.zookeeper.server;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.zip.Adler32;
import java.util.zip.CheckedInputStream;
import org.apache.hive.org.apache.zookeeper.CreateMode;
import org.apache.hive.org.apache.zookeeper.PortAssignment;
import org.apache.hive.org.apache.zookeeper.WatchedEvent;
import org.apache.hive.org.apache.zookeeper.Watcher;
import org.apache.hive.org.apache.zookeeper.ZKTestCase;
import org.apache.hive.org.apache.zookeeper.ZooDefs;
import org.apache.hive.org.apache.zookeeper.ZooKeeper;
import org.apache.hive.org.apache.zookeeper.server.DataTree;
import org.apache.hive.org.apache.zookeeper.server.ServerCnxnFactory;
import org.apache.hive.org.apache.zookeeper.server.SyncRequestProcessor;
import org.apache.hive.org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.hive.org.apache.zookeeper.server.persistence.FileSnap;
import org.apache.hive.org.apache.zookeeper.server.persistence.FileTxnLog;
import org.apache.hive.org.apache.zookeeper.server.persistence.TxnLog;
import org.apache.hive.org.apache.zookeeper.test.ClientBase;
import org.apache.hive.org.slf4j.Logger;
import org.apache.hive.org.slf4j.LoggerFactory;
import org.apache.jute.BinaryInputArchive;
import org.junit.Assert;
import org.junit.Test;

public class CRCTest
extends ZKTestCase
implements Watcher {
    private static final Logger LOG = LoggerFactory.getLogger(CRCTest.class);
    private static final String HOSTPORT = "127.0.0.1:" + PortAssignment.unique();
    private volatile CountDownLatch startSignal;

    private void corruptFile(File file) throws IOException {
        RandomAccessFile raf = new RandomAccessFile(file, "rw");
        byte[] b = "mahadev".getBytes();
        long writeLen = 500L;
        raf.seek(writeLen);
        raf.write(b);
        raf.close();
    }

    private boolean getCheckSum(FileSnap snap, File snapFile) throws IOException {
        DataTree dt = new DataTree();
        ConcurrentHashMap<Long, Integer> sessions = new ConcurrentHashMap<Long, Integer>();
        BufferedInputStream snapIS = new BufferedInputStream(new FileInputStream(snapFile));
        CheckedInputStream crcIn = new CheckedInputStream(snapIS, new Adler32());
        BinaryInputArchive ia = BinaryInputArchive.getArchive(crcIn);
        try {
            snap.deserialize(dt, sessions, ia);
        }
        catch (IOException ie) {
            ((InputStream)snapIS).close();
            crcIn.close();
            throw ie;
        }
        long checksum = crcIn.getChecksum().getValue();
        long val = ia.readLong("val");
        ((InputStream)snapIS).close();
        crcIn.close();
        return val != checksum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testChecksums() throws Exception {
        File tmpDir = ClientBase.createTmpDir();
        ClientBase.setupTestEnv();
        ZooKeeperServer zks = new ZooKeeperServer(tmpDir, tmpDir, 3000);
        SyncRequestProcessor.setSnapCount(150);
        int PORT = Integer.parseInt(HOSTPORT.split(":")[1]);
        ServerCnxnFactory f = ServerCnxnFactory.createFactory(PORT, -1);
        f.startup(zks);
        LOG.info("starting up the zookeeper server .. waiting");
        Assert.assertTrue((String)"waiting for server being up", (boolean)ClientBase.waitForServerUp(HOSTPORT, ClientBase.CONNECTION_TIMEOUT));
        ZooKeeper zk = new ZooKeeper(HOSTPORT, ClientBase.CONNECTION_TIMEOUT, this);
        try {
            for (int i = 0; i < 2000; ++i) {
                zk.create("/crctest- " + i, ("/crctest- " + i).getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            }
        }
        finally {
            zk.close();
        }
        f.shutdown();
        zks.shutdown();
        Assert.assertTrue((String)"waiting for server down", (boolean)ClientBase.waitForServerDown(HOSTPORT, ClientBase.CONNECTION_TIMEOUT));
        File versionDir = new File(tmpDir, "version-2");
        File[] list = versionDir.listFiles();
        File snapFile = null;
        File logFile = null;
        for (File file : list) {
            LOG.info("file is " + file);
            if (!file.getName().startsWith("log")) continue;
            logFile = file;
            this.corruptFile(logFile);
        }
        FileTxnLog flog = new FileTxnLog(versionDir);
        TxnLog.TxnIterator itr = flog.read(1L);
        try {
            while (itr.next()) {
            }
            Assert.assertTrue((boolean)false);
        }
        catch (IOException ie) {
            LOG.info("crc corruption", ie);
        }
        itr.close();
        FileSnap snap = new FileSnap(versionDir);
        List<File> snapFiles = snap.findNRecentSnapshots(2);
        snapFile = snapFiles.get(0);
        this.corruptFile(snapFile);
        boolean cfile = false;
        try {
            cfile = this.getCheckSum(snap, snapFile);
        }
        catch (IOException ie) {
            snapFile = snapFiles.get(1);
            this.corruptFile(snapFile);
            cfile = this.getCheckSum(snap, snapFile);
        }
        Assert.assertTrue((boolean)cfile);
    }

    public void process(WatchedEvent event) {
        LOG.info("Event:" + (Object)((Object)event.getState()) + " " + (Object)((Object)event.getType()) + " " + event.getPath());
        if (event.getState() == Watcher.Event.KeeperState.SyncConnected && this.startSignal != null && this.startSignal.getCount() > 0L) {
            this.startSignal.countDown();
        }
    }
}

