/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.org.apache.zookeeper;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import junit.framework.TestCase;
import org.apache.hive.org.apache.zookeeper.MultiResponse;
import org.apache.hive.org.apache.zookeeper.OpResult;
import org.apache.hive.org.apache.zookeeper.data.Stat;
import org.apache.hive.org.apache.zookeeper.server.ByteBufferInputStream;
import org.apache.jute.BinaryInputArchive;
import org.apache.jute.BinaryOutputArchive;
import org.junit.Test;

public class MultiResponseTest
extends TestCase {
    public void testRoundTrip() throws IOException {
        MultiResponse response = new MultiResponse();
        response.add(new OpResult.CheckResult());
        response.add(new OpResult.CreateResult("foo-bar"));
        response.add(new OpResult.DeleteResult());
        Stat s = new Stat();
        s.setCzxid(546L);
        response.add(new OpResult.SetDataResult(s));
        MultiResponse decodedResponse = this.codeDecode(response);
        MultiResponseTest.assertEquals((Object)response, (Object)decodedResponse);
        MultiResponseTest.assertEquals((int)response.hashCode(), (int)decodedResponse.hashCode());
    }

    @Test
    public void testEmptyRoundTrip() throws IOException {
        MultiResponse result = new MultiResponse();
        MultiResponse decodedResult = this.codeDecode(result);
        MultiResponseTest.assertEquals((Object)result, (Object)decodedResult);
        MultiResponseTest.assertEquals((int)result.hashCode(), (int)decodedResult.hashCode());
    }

    private MultiResponse codeDecode(MultiResponse request) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BinaryOutputArchive boa = BinaryOutputArchive.getArchive(baos);
        request.serialize(boa, "result");
        baos.close();
        ByteBuffer bb = ByteBuffer.wrap(baos.toByteArray());
        bb.rewind();
        BinaryInputArchive bia = BinaryInputArchive.getArchive(new ByteBufferInputStream(bb));
        MultiResponse decodedRequest = new MultiResponse();
        decodedRequest.deserialize(bia, "result");
        return decodedRequest;
    }
}

