/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.org.apache.zookeeper;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.LinkedBlockingQueue;
import javax.security.auth.login.LoginException;
import javax.security.sasl.SaslException;
import org.apache.hive.org.apache.zookeeper.AsyncCallback;
import org.apache.hive.org.apache.zookeeper.ClientCnxnSocket;
import org.apache.hive.org.apache.zookeeper.ClientWatchManager;
import org.apache.hive.org.apache.zookeeper.KeeperException;
import org.apache.hive.org.apache.zookeeper.WatchedEvent;
import org.apache.hive.org.apache.zookeeper.Watcher;
import org.apache.hive.org.apache.zookeeper.ZooKeeper;
import org.apache.hive.org.apache.zookeeper.client.HostProvider;
import org.apache.hive.org.apache.zookeeper.client.ZooKeeperSaslClient;
import org.apache.hive.org.apache.zookeeper.proto.AuthPacket;
import org.apache.hive.org.apache.zookeeper.proto.ConnectRequest;
import org.apache.hive.org.apache.zookeeper.proto.CreateResponse;
import org.apache.hive.org.apache.zookeeper.proto.ExistsResponse;
import org.apache.hive.org.apache.zookeeper.proto.GetACLResponse;
import org.apache.hive.org.apache.zookeeper.proto.GetChildren2Response;
import org.apache.hive.org.apache.zookeeper.proto.GetChildrenResponse;
import org.apache.hive.org.apache.zookeeper.proto.GetDataResponse;
import org.apache.hive.org.apache.zookeeper.proto.GetSASLRequest;
import org.apache.hive.org.apache.zookeeper.proto.ReplyHeader;
import org.apache.hive.org.apache.zookeeper.proto.RequestHeader;
import org.apache.hive.org.apache.zookeeper.proto.SetACLResponse;
import org.apache.hive.org.apache.zookeeper.proto.SetDataResponse;
import org.apache.hive.org.apache.zookeeper.proto.SetWatches;
import org.apache.hive.org.apache.zookeeper.proto.WatcherEvent;
import org.apache.hive.org.apache.zookeeper.server.ByteBufferInputStream;
import org.apache.hive.org.apache.zookeeper.server.ZooTrace;
import org.apache.hive.org.slf4j.Logger;
import org.apache.hive.org.slf4j.LoggerFactory;
import org.apache.jute.BinaryInputArchive;
import org.apache.jute.BinaryOutputArchive;
import org.apache.jute.Record;

public class ClientCnxn {
    private static final Logger LOG = LoggerFactory.getLogger(ClientCnxn.class);
    private static final String ZK_SASL_CLIENT_USERNAME = "zookeeper.sasl.client.username";
    private static boolean disableAutoWatchReset = Boolean.getBoolean("zookeeper.disableAutoWatchReset");
    private final CopyOnWriteArraySet<AuthData> authInfo = new CopyOnWriteArraySet();
    private final LinkedList<Packet> pendingQueue = new LinkedList();
    private final LinkedList<Packet> outgoingQueue = new LinkedList();
    private int connectTimeout;
    private volatile int negotiatedSessionTimeout;
    private int readTimeout;
    private final int sessionTimeout;
    private final ZooKeeper zooKeeper;
    private final ClientWatchManager watcher;
    private long sessionId;
    private byte[] sessionPasswd = new byte[16];
    private boolean readOnly;
    final String chrootPath;
    final SendThread sendThread;
    final EventThread eventThread;
    private volatile boolean closing = false;
    private final HostProvider hostProvider;
    volatile boolean seenRwServerBefore = false;
    public ZooKeeperSaslClient zooKeeperSaslClient;
    private Object eventOfDeath = new Object();
    private static final Thread.UncaughtExceptionHandler uncaughtExceptionHandler;
    private volatile long lastZxid;
    public static final int packetLen;
    private int xid = 1;
    private volatile ZooKeeper.States state = ZooKeeper.States.NOT_CONNECTED;

    public long getSessionId() {
        return this.sessionId;
    }

    public byte[] getSessionPasswd() {
        return this.sessionPasswd;
    }

    public int getSessionTimeout() {
        return this.negotiatedSessionTimeout;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        SocketAddress local = this.sendThread.getClientCnxnSocket().getLocalSocketAddress();
        SocketAddress remote = this.sendThread.getClientCnxnSocket().getRemoteSocketAddress();
        sb.append("sessionid:0x").append(Long.toHexString(this.getSessionId())).append(" local:").append(local).append(" remoteserver:").append(remote).append(" lastZxid:").append(this.lastZxid).append(" xid:").append(this.xid).append(" sent:").append(this.sendThread.getClientCnxnSocket().getSentCount()).append(" recv:").append(this.sendThread.getClientCnxnSocket().getRecvCount()).append(" queuedpkts:").append(this.outgoingQueue.size()).append(" pendingresp:").append(this.pendingQueue.size()).append(" queuedevents:").append(this.eventThread.waitingEvents.size());
        return sb.toString();
    }

    public ClientCnxn(String chrootPath, HostProvider hostProvider, int sessionTimeout, ZooKeeper zooKeeper, ClientWatchManager watcher, ClientCnxnSocket clientCnxnSocket, boolean canBeReadOnly) throws IOException {
        this(chrootPath, hostProvider, sessionTimeout, zooKeeper, watcher, clientCnxnSocket, 0L, new byte[16], canBeReadOnly);
    }

    public ClientCnxn(String chrootPath, HostProvider hostProvider, int sessionTimeout, ZooKeeper zooKeeper, ClientWatchManager watcher, ClientCnxnSocket clientCnxnSocket, long sessionId, byte[] sessionPasswd, boolean canBeReadOnly) {
        this.zooKeeper = zooKeeper;
        this.watcher = watcher;
        this.sessionId = sessionId;
        this.sessionPasswd = sessionPasswd;
        this.sessionTimeout = sessionTimeout;
        this.hostProvider = hostProvider;
        this.chrootPath = chrootPath;
        this.connectTimeout = sessionTimeout / hostProvider.size();
        this.readTimeout = sessionTimeout * 2 / 3;
        this.readOnly = canBeReadOnly;
        this.sendThread = new SendThread(clientCnxnSocket);
        this.eventThread = new EventThread();
    }

    public static boolean getDisableAutoResetWatch() {
        return disableAutoWatchReset;
    }

    public static void setDisableAutoResetWatch(boolean b) {
        disableAutoWatchReset = b;
    }

    public void start() {
        this.sendThread.start();
        this.eventThread.start();
    }

    private static String makeThreadName(String suffix) {
        String name = Thread.currentThread().getName().replaceAll("-EventThread", "");
        return name + suffix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishPacket(Packet p) {
        if (p.watchRegistration != null) {
            p.watchRegistration.register(p.replyHeader.getErr());
        }
        if (p.cb == null) {
            Packet packet = p;
            synchronized (packet) {
                p.finished = true;
                p.notifyAll();
            }
        } else {
            p.finished = true;
            this.eventThread.queuePacket(p);
        }
    }

    private void conLossPacket(Packet p) {
        if (p.replyHeader == null) {
            return;
        }
        switch (this.state) {
            case AUTH_FAILED: {
                p.replyHeader.setErr(KeeperException.Code.AUTHFAILED.intValue());
                break;
            }
            case CLOSED: {
                p.replyHeader.setErr(KeeperException.Code.SESSIONEXPIRED.intValue());
                break;
            }
            default: {
                p.replyHeader.setErr(KeeperException.Code.CONNECTIONLOSS.intValue());
            }
        }
        this.finishPacket(p);
    }

    public long getLastZxid() {
        return this.lastZxid;
    }

    public void disconnect() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Disconnecting client for session: 0x" + Long.toHexString(this.getSessionId()));
        }
        this.sendThread.close();
        this.eventThread.queueEventOfDeath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Closing client for session: 0x" + Long.toHexString(this.getSessionId()));
        }
        try {
            RequestHeader h = new RequestHeader();
            h.setType(-11);
            this.submitRequest(h, null, null, null);
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this.disconnect();
        }
    }

    public synchronized int getXid() {
        return this.xid++;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReplyHeader submitRequest(RequestHeader h, Record request, Record response, ZooKeeper.WatchRegistration watchRegistration) throws InterruptedException {
        Packet packet;
        ReplyHeader r = new ReplyHeader();
        Packet packet2 = packet = this.queuePacket(h, r, request, response, null, null, null, null, watchRegistration);
        synchronized (packet2) {
            while (!packet.finished) {
                packet.wait();
            }
        }
        return r;
    }

    public void enableWrite() {
        this.sendThread.getClientCnxnSocket().enableWrite();
    }

    public void sendPacket(Record request, Record response, AsyncCallback cb, int opCode) throws IOException {
        int xid = this.getXid();
        RequestHeader h = new RequestHeader();
        h.setXid(xid);
        h.setType(opCode);
        ReplyHeader r = new ReplyHeader();
        r.setXid(xid);
        Packet p = new Packet(h, r, request, response, null, false);
        p.cb = cb;
        this.sendThread.sendPacket(p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Packet queuePacket(RequestHeader h, ReplyHeader r, Record request, Record response, AsyncCallback cb, String clientPath, String serverPath, Object ctx, ZooKeeper.WatchRegistration watchRegistration) {
        Packet packet = null;
        LinkedList<Packet> linkedList = this.outgoingQueue;
        synchronized (linkedList) {
            packet = new Packet(h, r, request, response, watchRegistration);
            packet.cb = cb;
            packet.ctx = ctx;
            packet.clientPath = clientPath;
            packet.serverPath = serverPath;
            if (!this.state.isAlive() || this.closing) {
                this.conLossPacket(packet);
            } else {
                if (h.getType() == -11) {
                    this.closing = true;
                }
                this.outgoingQueue.add(packet);
            }
        }
        this.sendThread.getClientCnxnSocket().wakeupCnxn();
        return packet;
    }

    public void addAuthInfo(String scheme, byte[] auth) {
        if (!this.state.isAlive()) {
            return;
        }
        this.authInfo.add(new AuthData(scheme, auth));
        this.queuePacket(new RequestHeader(-4, 100), null, new AuthPacket(0, scheme, auth), null, null, null, null, null, null);
    }

    ZooKeeper.States getState() {
        return this.state;
    }

    static /* synthetic */ byte[] access$1402(ClientCnxn x0, byte[] x1) {
        x0.sessionPasswd = x1;
        return x1;
    }

    static {
        if (LOG.isDebugEnabled()) {
            LOG.debug("zookeeper.disableAutoWatchReset is " + disableAutoWatchReset);
        }
        uncaughtExceptionHandler = new Thread.UncaughtExceptionHandler(){

            public void uncaughtException(Thread t, Throwable e) {
                LOG.error("from " + t.getName(), e);
            }
        };
        packetLen = Integer.getInteger("jute.maxbuffer", 0x400000);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class SendThread
    extends Thread {
        private long lastPingSentNs;
        private final ClientCnxnSocket clientCnxnSocket;
        private Random r;
        private boolean isFirstConnect;
        private InetSocketAddress rwServerAddress;
        private static final int minPingRwTimeout = 100;
        private static final int maxPingRwTimeout = 60000;
        private int pingRwTimeout;
        private boolean saslLoginFailed;
        private static final String RETRY_CONN_MSG = ", closing socket connection and attempting reconnect";

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void readResponse(ByteBuffer incomingBuffer) throws IOException {
            Packet packet;
            ByteBufferInputStream bbis = new ByteBufferInputStream(incomingBuffer);
            BinaryInputArchive bbia = BinaryInputArchive.getArchive(bbis);
            ReplyHeader replyHdr = new ReplyHeader();
            replyHdr.deserialize(bbia, "header");
            if (replyHdr.getXid() == -2) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Got ping response for sessionid: 0x" + Long.toHexString(ClientCnxn.this.sessionId) + " after " + (System.nanoTime() - this.lastPingSentNs) / 1000000L + "ms");
                }
                return;
            }
            if (replyHdr.getXid() == -4) {
                if (replyHdr.getErr() == KeeperException.Code.AUTHFAILED.intValue()) {
                    ClientCnxn.this.state = ZooKeeper.States.AUTH_FAILED;
                    ClientCnxn.this.eventThread.queueEvent(new WatchedEvent(Watcher.Event.EventType.None, Watcher.Event.KeeperState.AuthFailed, null));
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Got auth sessionid:0x" + Long.toHexString(ClientCnxn.this.sessionId));
                }
                return;
            }
            if (replyHdr.getXid() == -1) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Got notification sessionid:0x" + Long.toHexString(ClientCnxn.this.sessionId));
                }
                WatcherEvent event = new WatcherEvent();
                event.deserialize(bbia, "response");
                if (ClientCnxn.this.chrootPath != null) {
                    String serverPath = event.getPath();
                    if (serverPath.compareTo(ClientCnxn.this.chrootPath) == 0) {
                        event.setPath("/");
                    } else if (serverPath.length() > ClientCnxn.this.chrootPath.length()) {
                        event.setPath(serverPath.substring(ClientCnxn.this.chrootPath.length()));
                    } else {
                        LOG.warn("Got server path " + event.getPath() + " which is too short for chroot path " + ClientCnxn.this.chrootPath);
                    }
                }
                WatchedEvent we = new WatchedEvent(event);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Got " + we + " for sessionid 0x" + Long.toHexString(ClientCnxn.this.sessionId));
                }
                ClientCnxn.this.eventThread.queueEvent(we);
                return;
            }
            if (this.clientTunneledAuthenticationInProgress()) {
                GetSASLRequest request = new GetSASLRequest();
                request.deserialize(bbia, "token");
                ClientCnxn.this.zooKeeperSaslClient.respondToServer(request.getToken(), ClientCnxn.this);
                return;
            }
            LinkedList linkedList = ClientCnxn.this.pendingQueue;
            synchronized (linkedList) {
                if (ClientCnxn.this.pendingQueue.size() == 0) {
                    throw new IOException("Nothing in the queue, but got " + replyHdr.getXid());
                }
                packet = (Packet)ClientCnxn.this.pendingQueue.remove();
            }
            try {
                if (packet.requestHeader.getXid() != replyHdr.getXid()) {
                    packet.replyHeader.setErr(KeeperException.Code.CONNECTIONLOSS.intValue());
                    throw new IOException("Xid out of order. Got Xid " + replyHdr.getXid() + " with err " + replyHdr.getErr() + " expected Xid " + packet.requestHeader.getXid() + " for a packet with details: " + packet);
                }
                packet.replyHeader.setXid(replyHdr.getXid());
                packet.replyHeader.setErr(replyHdr.getErr());
                packet.replyHeader.setZxid(replyHdr.getZxid());
                if (replyHdr.getZxid() > 0L) {
                    ClientCnxn.this.lastZxid = replyHdr.getZxid();
                }
                if (packet.response != null && replyHdr.getErr() == 0) {
                    packet.response.deserialize(bbia, "response");
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Reading reply sessionid:0x" + Long.toHexString(ClientCnxn.this.sessionId) + ", packet:: " + packet);
                }
            }
            finally {
                ClientCnxn.this.finishPacket(packet);
            }
        }

        SendThread(ClientCnxnSocket clientCnxnSocket) {
            super(ClientCnxn.makeThreadName("-SendThread()"));
            this.r = new Random(System.nanoTime());
            this.isFirstConnect = true;
            this.rwServerAddress = null;
            this.pingRwTimeout = 100;
            this.saslLoginFailed = false;
            ClientCnxn.this.state = ZooKeeper.States.CONNECTING;
            this.clientCnxnSocket = clientCnxnSocket;
            this.setUncaughtExceptionHandler(uncaughtExceptionHandler);
            this.setDaemon(true);
        }

        ZooKeeper.States getZkState() {
            return ClientCnxn.this.state;
        }

        ClientCnxnSocket getClientCnxnSocket() {
            return this.clientCnxnSocket;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void primeConnection() throws IOException {
            LOG.info("Socket connection established to " + this.clientCnxnSocket.getRemoteSocketAddress() + ", initiating session");
            this.isFirstConnect = false;
            long sessId = ClientCnxn.this.seenRwServerBefore ? ClientCnxn.this.sessionId : 0L;
            ConnectRequest conReq = new ConnectRequest(0, ClientCnxn.this.lastZxid, ClientCnxn.this.sessionTimeout, sessId, ClientCnxn.this.sessionPasswd);
            LinkedList linkedList = ClientCnxn.this.outgoingQueue;
            synchronized (linkedList) {
                if (!disableAutoWatchReset) {
                    List<String> dataWatches = ClientCnxn.this.zooKeeper.getDataWatches();
                    List<String> existWatches = ClientCnxn.this.zooKeeper.getExistWatches();
                    List<String> childWatches = ClientCnxn.this.zooKeeper.getChildWatches();
                    if (!(dataWatches.isEmpty() && existWatches.isEmpty() && childWatches.isEmpty())) {
                        SetWatches sw = new SetWatches(ClientCnxn.this.lastZxid, this.prependChroot(dataWatches), this.prependChroot(existWatches), this.prependChroot(childWatches));
                        RequestHeader h = new RequestHeader();
                        h.setType(101);
                        h.setXid(-8);
                        Packet packet = new Packet(h, new ReplyHeader(), sw, null, null);
                        ClientCnxn.this.outgoingQueue.addFirst(packet);
                    }
                }
                for (AuthData id : ClientCnxn.this.authInfo) {
                    ClientCnxn.this.outgoingQueue.addFirst(new Packet(new RequestHeader(-4, 100), null, new AuthPacket(0, id.scheme, id.data), null, null));
                }
                ClientCnxn.this.outgoingQueue.addFirst(new Packet(null, null, conReq, null, null, ClientCnxn.this.readOnly));
            }
            this.clientCnxnSocket.enableReadWriteOnly();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Session establishment request sent on " + this.clientCnxnSocket.getRemoteSocketAddress());
            }
        }

        private List<String> prependChroot(List<String> paths) {
            if (ClientCnxn.this.chrootPath != null && !paths.isEmpty()) {
                for (int i = 0; i < paths.size(); ++i) {
                    String clientPath = paths.get(i);
                    String serverPath = clientPath.length() == 1 ? ClientCnxn.this.chrootPath : ClientCnxn.this.chrootPath + clientPath;
                    paths.set(i, serverPath);
                }
            }
            return paths;
        }

        private void sendPing() {
            this.lastPingSentNs = System.nanoTime();
            RequestHeader h = new RequestHeader(-2, 11);
            ClientCnxn.this.queuePacket(h, null, null, null, null, null, null, null, null);
        }

        private void startConnect() throws IOException {
            InetSocketAddress addr;
            ClientCnxn.this.state = ZooKeeper.States.CONNECTING;
            if (this.rwServerAddress != null) {
                addr = this.rwServerAddress;
                this.rwServerAddress = null;
            } else {
                addr = ClientCnxn.this.hostProvider.next(1000L);
            }
            this.setName(this.getName().replaceAll("\\(.*\\)", "(" + addr.getHostName() + ":" + addr.getPort() + ")"));
            if (ZooKeeperSaslClient.isEnabled()) {
                try {
                    String principalUserName = System.getProperty(ClientCnxn.ZK_SASL_CLIENT_USERNAME, "zookeeper");
                    ClientCnxn.this.zooKeeperSaslClient = new ZooKeeperSaslClient(principalUserName + "/" + addr.getHostName());
                }
                catch (LoginException e) {
                    LOG.warn("SASL configuration failed: " + e + " Will continue connection to Zookeeper server without " + "SASL authentication, if Zookeeper server allows it.");
                    ClientCnxn.this.eventThread.queueEvent(new WatchedEvent(Watcher.Event.EventType.None, Watcher.Event.KeeperState.AuthFailed, null));
                    this.saslLoginFailed = true;
                }
            }
            this.logStartConnect(addr);
            this.clientCnxnSocket.connect(addr);
        }

        private void logStartConnect(InetSocketAddress addr) {
            String msg = "Opening socket connection to server " + addr;
            if (ClientCnxn.this.zooKeeperSaslClient != null) {
                msg = msg + ". " + ClientCnxn.this.zooKeeperSaslClient.getConfigStatus();
            }
            LOG.info(msg);
        }

        @Override
        public void run() {
            this.clientCnxnSocket.introduce(this, ClientCnxn.this.sessionId);
            this.clientCnxnSocket.updateNow();
            this.clientCnxnSocket.updateLastSendAndHeard();
            long lastPingRwServer = System.currentTimeMillis();
            int MAX_SEND_PING_INTERVAL = 10000;
            while (ClientCnxn.this.state.isAlive()) {
                try {
                    int to;
                    if (!this.clientCnxnSocket.isConnected()) {
                        if (!this.isFirstConnect) {
                            try {
                                Thread.sleep(this.r.nextInt(1000));
                            }
                            catch (InterruptedException e) {
                                LOG.warn("Unexpected exception", e);
                            }
                        }
                        if (ClientCnxn.this.closing || !ClientCnxn.this.state.isAlive()) break;
                        this.startConnect();
                        this.clientCnxnSocket.updateLastSendAndHeard();
                    }
                    if (ClientCnxn.this.state.isConnected()) {
                        if (ClientCnxn.this.zooKeeperSaslClient != null) {
                            Watcher.Event.KeeperState authState;
                            boolean sendAuthEvent = false;
                            if (ClientCnxn.this.zooKeeperSaslClient.getSaslState() == ZooKeeperSaslClient.SaslState.INITIAL) {
                                try {
                                    ClientCnxn.this.zooKeeperSaslClient.initialize(ClientCnxn.this);
                                }
                                catch (SaslException e) {
                                    LOG.error("SASL authentication with Zookeeper Quorum member failed: " + e);
                                    ClientCnxn.this.state = ZooKeeper.States.AUTH_FAILED;
                                    sendAuthEvent = true;
                                }
                            }
                            if ((authState = ClientCnxn.this.zooKeeperSaslClient.getKeeperState()) != null) {
                                if (authState == Watcher.Event.KeeperState.AuthFailed) {
                                    ClientCnxn.this.state = ZooKeeper.States.AUTH_FAILED;
                                    sendAuthEvent = true;
                                } else if (authState == Watcher.Event.KeeperState.SaslAuthenticated) {
                                    sendAuthEvent = true;
                                }
                            }
                            if (sendAuthEvent) {
                                ClientCnxn.this.eventThread.queueEvent(new WatchedEvent(Watcher.Event.EventType.None, authState, null));
                            }
                        }
                        to = ClientCnxn.this.readTimeout - this.clientCnxnSocket.getIdleRecv();
                    } else {
                        to = ClientCnxn.this.connectTimeout - this.clientCnxnSocket.getIdleRecv();
                    }
                    if (to <= 0) {
                        throw new SessionTimeoutException("Client session timed out, have not heard from server in " + this.clientCnxnSocket.getIdleRecv() + "ms" + " for sessionid 0x" + Long.toHexString(ClientCnxn.this.sessionId));
                    }
                    if (ClientCnxn.this.state.isConnected()) {
                        int timeToNextPing = ClientCnxn.this.readTimeout / 2 - this.clientCnxnSocket.getIdleSend() - (this.clientCnxnSocket.getIdleSend() > 1000 ? 1000 : 0);
                        if (timeToNextPing <= 0 || this.clientCnxnSocket.getIdleSend() > 10000) {
                            this.sendPing();
                            this.clientCnxnSocket.updateLastSend();
                        } else if (timeToNextPing < to) {
                            to = timeToNextPing;
                        }
                    }
                    if (ClientCnxn.this.state == ZooKeeper.States.CONNECTEDREADONLY) {
                        long now = System.currentTimeMillis();
                        int idlePingRwServer = (int)(now - lastPingRwServer);
                        if (idlePingRwServer >= this.pingRwTimeout) {
                            lastPingRwServer = now;
                            idlePingRwServer = 0;
                            this.pingRwTimeout = Math.min(2 * this.pingRwTimeout, 60000);
                            this.pingRwServer();
                        }
                        to = Math.min(to, this.pingRwTimeout - idlePingRwServer);
                    }
                    this.clientCnxnSocket.doTransport(to, ClientCnxn.this.pendingQueue, ClientCnxn.this.outgoingQueue, ClientCnxn.this);
                }
                catch (Throwable e) {
                    if (ClientCnxn.this.closing) {
                        if (!LOG.isDebugEnabled()) break;
                        LOG.debug("An exception was thrown while closing send thread for session 0x" + Long.toHexString(ClientCnxn.this.getSessionId()) + " : " + e.getMessage());
                        break;
                    }
                    if (e instanceof SessionExpiredException) {
                        LOG.info(e.getMessage() + ", closing socket connection");
                    } else if (e instanceof SessionTimeoutException) {
                        LOG.info(e.getMessage() + RETRY_CONN_MSG);
                    } else if (e instanceof EndOfStreamException) {
                        LOG.info(e.getMessage() + RETRY_CONN_MSG);
                    } else if (e instanceof RWServerFoundException) {
                        LOG.info(e.getMessage());
                    } else {
                        LOG.warn("Session 0x" + Long.toHexString(ClientCnxn.this.getSessionId()) + " for server " + this.clientCnxnSocket.getRemoteSocketAddress() + ", unexpected error" + RETRY_CONN_MSG, e);
                    }
                    this.cleanup();
                    if (ClientCnxn.this.state.isAlive()) {
                        ClientCnxn.this.eventThread.queueEvent(new WatchedEvent(Watcher.Event.EventType.None, Watcher.Event.KeeperState.Disconnected, null));
                    }
                    this.clientCnxnSocket.updateNow();
                    this.clientCnxnSocket.updateLastSendAndHeard();
                }
            }
            this.cleanup();
            this.clientCnxnSocket.close();
            if (ClientCnxn.this.state.isAlive()) {
                ClientCnxn.this.eventThread.queueEvent(new WatchedEvent(Watcher.Event.EventType.None, Watcher.Event.KeeperState.Disconnected, null));
            }
            ZooTrace.logTraceMessage(LOG, ZooTrace.getTextTraceLevel(), "SendThread exitedloop.");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void pingRwServer() throws RWServerFoundException {
            String result = null;
            InetSocketAddress addr = ClientCnxn.this.hostProvider.next(0L);
            LOG.info("Checking server " + addr + " for being r/w." + " Timeout " + this.pingRwTimeout);
            Socket sock = null;
            BufferedReader br = null;
            try {
                sock = new Socket(addr.getHostName(), addr.getPort());
                sock.setSoLinger(false, -1);
                sock.setSoTimeout(1000);
                sock.setTcpNoDelay(true);
                sock.getOutputStream().write("isro".getBytes());
                sock.getOutputStream().flush();
                sock.shutdownOutput();
                br = new BufferedReader(new InputStreamReader(sock.getInputStream()));
                result = br.readLine();
            }
            catch (ConnectException e) {
            }
            catch (IOException e) {
                LOG.warn("Exception while seeking for r/w server " + e.getMessage(), e);
            }
            finally {
                if (sock != null) {
                    try {
                        sock.close();
                    }
                    catch (IOException e) {
                        LOG.warn("Unexpected exception", e);
                    }
                }
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException e) {
                        LOG.warn("Unexpected exception", e);
                    }
                }
            }
            if ("rw".equals(result)) {
                this.pingRwTimeout = 100;
                this.rwServerAddress = addr;
                throw new RWServerFoundException("Majority server found at " + addr.getHostName() + ":" + addr.getPort());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void cleanup() {
            this.clientCnxnSocket.cleanup();
            LinkedList linkedList = ClientCnxn.this.pendingQueue;
            synchronized (linkedList) {
                for (Packet p : ClientCnxn.this.pendingQueue) {
                    ClientCnxn.this.conLossPacket(p);
                }
                ClientCnxn.this.pendingQueue.clear();
            }
            linkedList = ClientCnxn.this.outgoingQueue;
            synchronized (linkedList) {
                for (Packet p : ClientCnxn.this.outgoingQueue) {
                    ClientCnxn.this.conLossPacket(p);
                }
                ClientCnxn.this.outgoingQueue.clear();
            }
        }

        void onConnected(int _negotiatedSessionTimeout, long _sessionId, byte[] _sessionPasswd, boolean isRO) throws IOException {
            ClientCnxn.this.negotiatedSessionTimeout = _negotiatedSessionTimeout;
            if (ClientCnxn.this.negotiatedSessionTimeout <= 0) {
                ClientCnxn.this.state = ZooKeeper.States.CLOSED;
                ClientCnxn.this.eventThread.queueEvent(new WatchedEvent(Watcher.Event.EventType.None, Watcher.Event.KeeperState.Expired, null));
                ClientCnxn.this.eventThread.queueEventOfDeath();
                throw new SessionExpiredException("Unable to reconnect to ZooKeeper service, session 0x" + Long.toHexString(ClientCnxn.this.sessionId) + " has expired");
            }
            if (!ClientCnxn.this.readOnly && isRO) {
                LOG.error("Read/write client got connected to read-only server");
            }
            ClientCnxn.this.readTimeout = ClientCnxn.this.negotiatedSessionTimeout * 2 / 3;
            ClientCnxn.this.connectTimeout = ClientCnxn.this.negotiatedSessionTimeout / ClientCnxn.this.hostProvider.size();
            ClientCnxn.this.hostProvider.onConnected();
            ClientCnxn.this.sessionId = _sessionId;
            ClientCnxn.access$1402(ClientCnxn.this, _sessionPasswd);
            ClientCnxn.this.state = isRO ? ZooKeeper.States.CONNECTEDREADONLY : ZooKeeper.States.CONNECTED;
            ClientCnxn.this.seenRwServerBefore = ClientCnxn.this.seenRwServerBefore | !isRO;
            LOG.info("Session establishment complete on server " + this.clientCnxnSocket.getRemoteSocketAddress() + ", sessionid = 0x" + Long.toHexString(ClientCnxn.this.sessionId) + ", negotiated timeout = " + ClientCnxn.this.negotiatedSessionTimeout + (isRO ? " (READ-ONLY mode)" : ""));
            Watcher.Event.KeeperState eventState = isRO ? Watcher.Event.KeeperState.ConnectedReadOnly : Watcher.Event.KeeperState.SyncConnected;
            ClientCnxn.this.eventThread.queueEvent(new WatchedEvent(Watcher.Event.EventType.None, eventState, null));
        }

        void close() {
            ClientCnxn.this.state = ZooKeeper.States.CLOSED;
            this.clientCnxnSocket.wakeupCnxn();
        }

        void testableCloseSocket() throws IOException {
            this.clientCnxnSocket.testableCloseSocket();
        }

        public boolean clientTunneledAuthenticationInProgress() {
            if (!ZooKeeperSaslClient.isEnabled()) {
                return false;
            }
            if (this.saslLoginFailed) {
                return false;
            }
            if (ClientCnxn.this.zooKeeperSaslClient == null) {
                return true;
            }
            return ClientCnxn.this.zooKeeperSaslClient.clientTunneledAuthenticationInProgress();
        }

        public void sendPacket(Packet p) throws IOException {
            this.clientCnxnSocket.sendPacket(p);
        }
    }

    private static class RWServerFoundException
    extends IOException {
        private static final long serialVersionUID = 90431199887158758L;

        public RWServerFoundException(String msg) {
            super(msg);
        }
    }

    private static class SessionExpiredException
    extends IOException {
        private static final long serialVersionUID = -1388816932076193249L;

        public SessionExpiredException(String msg) {
            super(msg);
        }
    }

    private static class SessionTimeoutException
    extends IOException {
        private static final long serialVersionUID = 824482094072071178L;

        public SessionTimeoutException(String msg) {
            super(msg);
        }
    }

    static class EndOfStreamException
    extends IOException {
        private static final long serialVersionUID = -5438877188796231422L;

        public EndOfStreamException(String msg) {
            super(msg);
        }

        public String toString() {
            return "EndOfStreamException: " + this.getMessage();
        }
    }

    class EventThread
    extends Thread {
        private final LinkedBlockingQueue<Object> waitingEvents;
        private volatile Watcher.Event.KeeperState sessionState;
        private volatile boolean wasKilled;
        private volatile boolean isRunning;

        EventThread() {
            super(ClientCnxn.makeThreadName("-EventThread"));
            this.waitingEvents = new LinkedBlockingQueue();
            this.sessionState = Watcher.Event.KeeperState.Disconnected;
            this.wasKilled = false;
            this.isRunning = false;
            this.setUncaughtExceptionHandler(uncaughtExceptionHandler);
            this.setDaemon(true);
        }

        public void queueEvent(WatchedEvent event) {
            if (event.getType() == Watcher.Event.EventType.None && this.sessionState == event.getState()) {
                return;
            }
            this.sessionState = event.getState();
            WatcherSetEventPair pair = new WatcherSetEventPair(ClientCnxn.this.watcher.materialize(event.getState(), event.getType(), event.getPath()), event);
            this.waitingEvents.add(pair);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void queuePacket(Packet packet) {
            if (this.wasKilled) {
                LinkedBlockingQueue<Object> linkedBlockingQueue = this.waitingEvents;
                synchronized (linkedBlockingQueue) {
                    if (this.isRunning) {
                        this.waitingEvents.add(packet);
                    } else {
                        this.processEvent(packet);
                    }
                }
            } else {
                this.waitingEvents.add(packet);
            }
        }

        public void queueEventOfDeath() {
            this.waitingEvents.add(ClientCnxn.this.eventOfDeath);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                this.isRunning = true;
                while (true) {
                    Object event;
                    if ((event = this.waitingEvents.take()) == ClientCnxn.this.eventOfDeath) {
                        this.wasKilled = true;
                    } else {
                        this.processEvent(event);
                    }
                    if (!this.wasKilled) continue;
                    LinkedBlockingQueue<Object> linkedBlockingQueue = this.waitingEvents;
                    synchronized (linkedBlockingQueue) {
                        if (this.waitingEvents.isEmpty()) {
                            this.isRunning = false;
                            break;
                        }
                    }
                }
            }
            catch (InterruptedException e) {
                LOG.error("Event thread exiting due to interruption", e);
            }
            LOG.info("EventThread shut down");
        }

        private void processEvent(Object event) {
            try {
                if (event instanceof WatcherSetEventPair) {
                    WatcherSetEventPair pair = (WatcherSetEventPair)event;
                    for (Watcher watcher : pair.watchers) {
                        try {
                            watcher.process(pair.event);
                        }
                        catch (Throwable t) {
                            LOG.error("Error while calling watcher ", t);
                        }
                    }
                } else {
                    Packet p = (Packet)event;
                    int rc = 0;
                    String clientPath = p.clientPath;
                    if (p.replyHeader.getErr() != 0) {
                        rc = p.replyHeader.getErr();
                    }
                    if (p.cb == null) {
                        LOG.warn("Somehow a null cb got to EventThread!");
                    } else if (p.response instanceof ExistsResponse || p.response instanceof SetDataResponse || p.response instanceof SetACLResponse) {
                        AsyncCallback.StatCallback cb = (AsyncCallback.StatCallback)p.cb;
                        if (rc == 0) {
                            if (p.response instanceof ExistsResponse) {
                                cb.processResult(rc, clientPath, p.ctx, ((ExistsResponse)p.response).getStat());
                            } else if (p.response instanceof SetDataResponse) {
                                cb.processResult(rc, clientPath, p.ctx, ((SetDataResponse)p.response).getStat());
                            } else if (p.response instanceof SetACLResponse) {
                                cb.processResult(rc, clientPath, p.ctx, ((SetACLResponse)p.response).getStat());
                            }
                        } else {
                            cb.processResult(rc, clientPath, p.ctx, null);
                        }
                    } else if (p.response instanceof GetDataResponse) {
                        AsyncCallback.DataCallback cb = (AsyncCallback.DataCallback)p.cb;
                        GetDataResponse rsp = (GetDataResponse)p.response;
                        if (rc == 0) {
                            cb.processResult(rc, clientPath, p.ctx, rsp.getData(), rsp.getStat());
                        } else {
                            cb.processResult(rc, clientPath, p.ctx, null, null);
                        }
                    } else if (p.response instanceof GetACLResponse) {
                        AsyncCallback.ACLCallback cb = (AsyncCallback.ACLCallback)p.cb;
                        GetACLResponse rsp = (GetACLResponse)p.response;
                        if (rc == 0) {
                            cb.processResult(rc, clientPath, p.ctx, rsp.getAcl(), rsp.getStat());
                        } else {
                            cb.processResult(rc, clientPath, p.ctx, null, null);
                        }
                    } else if (p.response instanceof GetChildrenResponse) {
                        AsyncCallback.ChildrenCallback cb = (AsyncCallback.ChildrenCallback)p.cb;
                        GetChildrenResponse rsp = (GetChildrenResponse)p.response;
                        if (rc == 0) {
                            cb.processResult(rc, clientPath, p.ctx, rsp.getChildren());
                        } else {
                            cb.processResult(rc, clientPath, p.ctx, null);
                        }
                    } else if (p.response instanceof GetChildren2Response) {
                        AsyncCallback.Children2Callback cb = (AsyncCallback.Children2Callback)p.cb;
                        GetChildren2Response rsp = (GetChildren2Response)p.response;
                        if (rc == 0) {
                            cb.processResult(rc, clientPath, p.ctx, rsp.getChildren(), rsp.getStat());
                        } else {
                            cb.processResult(rc, clientPath, p.ctx, null, null);
                        }
                    } else if (p.response instanceof CreateResponse) {
                        AsyncCallback.StringCallback cb = (AsyncCallback.StringCallback)p.cb;
                        CreateResponse rsp = (CreateResponse)p.response;
                        if (rc == 0) {
                            cb.processResult(rc, clientPath, p.ctx, ClientCnxn.this.chrootPath == null ? rsp.getPath() : rsp.getPath().substring(ClientCnxn.this.chrootPath.length()));
                        } else {
                            cb.processResult(rc, clientPath, p.ctx, null);
                        }
                    } else if (p.cb instanceof AsyncCallback.VoidCallback) {
                        AsyncCallback.VoidCallback cb = (AsyncCallback.VoidCallback)p.cb;
                        cb.processResult(rc, clientPath, p.ctx);
                    }
                }
            }
            catch (Throwable t) {
                LOG.error("Caught unexpected throwable", t);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class WatcherSetEventPair {
        private final Set<Watcher> watchers;
        private final WatchedEvent event;

        public WatcherSetEventPair(Set<Watcher> watchers, WatchedEvent event) {
            this.watchers = watchers;
            this.event = event;
        }
    }

    static class Packet {
        RequestHeader requestHeader;
        ReplyHeader replyHeader;
        Record request;
        Record response;
        ByteBuffer bb;
        String clientPath;
        String serverPath;
        boolean finished;
        AsyncCallback cb;
        Object ctx;
        ZooKeeper.WatchRegistration watchRegistration;
        public boolean readOnly;

        Packet(RequestHeader requestHeader, ReplyHeader replyHeader, Record request, Record response, ZooKeeper.WatchRegistration watchRegistration) {
            this(requestHeader, replyHeader, request, response, watchRegistration, false);
        }

        Packet(RequestHeader requestHeader, ReplyHeader replyHeader, Record request, Record response, ZooKeeper.WatchRegistration watchRegistration, boolean readOnly) {
            this.requestHeader = requestHeader;
            this.replyHeader = replyHeader;
            this.request = request;
            this.response = response;
            this.readOnly = readOnly;
            this.watchRegistration = watchRegistration;
        }

        public void createBB() {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                BinaryOutputArchive boa = BinaryOutputArchive.getArchive(baos);
                boa.writeInt(-1, "len");
                if (this.requestHeader != null) {
                    this.requestHeader.serialize(boa, "header");
                }
                if (this.request instanceof ConnectRequest) {
                    this.request.serialize(boa, "connect");
                    boa.writeBool(this.readOnly, "readOnly");
                } else if (this.request != null) {
                    this.request.serialize(boa, "request");
                }
                baos.close();
                this.bb = ByteBuffer.wrap(baos.toByteArray());
                this.bb.putInt(this.bb.capacity() - 4);
                this.bb.rewind();
            }
            catch (IOException e) {
                LOG.warn("Ignoring unexpected exception", e);
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("clientPath:" + this.clientPath);
            sb.append(" serverPath:" + this.serverPath);
            sb.append(" finished:" + this.finished);
            sb.append(" header:: " + this.requestHeader);
            sb.append(" replyHeader:: " + this.replyHeader);
            sb.append(" request:: " + this.request);
            sb.append(" response:: " + this.response);
            return sb.toString().replaceAll("\r*\n+", " ");
        }
    }

    static class AuthData {
        String scheme;
        byte[] data;

        AuthData(String scheme, byte[] data) {
            this.scheme = scheme;
            this.data = data;
        }
    }
}

