/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.org.apache.commons.math.stat.regression;

import org.apache.hive.org.apache.commons.math.linear.Array2DRowRealMatrix;
import org.apache.hive.org.apache.commons.math.linear.LUDecompositionImpl;
import org.apache.hive.org.apache.commons.math.linear.RealMatrix;
import org.apache.hive.org.apache.commons.math.linear.RealVector;
import org.apache.hive.org.apache.commons.math.stat.regression.AbstractMultipleLinearRegression;

public class GLSMultipleLinearRegression
extends AbstractMultipleLinearRegression {
    private RealMatrix Omega;
    private RealMatrix OmegaInverse;

    public void newSampleData(double[] y, double[][] x, double[][] covariance) {
        this.validateSampleData(x, y);
        this.newYSampleData(y);
        this.newXSampleData(x);
        this.validateCovarianceData(x, covariance);
        this.newCovarianceData(covariance);
    }

    protected void newCovarianceData(double[][] omega) {
        this.Omega = new Array2DRowRealMatrix(omega);
        this.OmegaInverse = null;
    }

    protected RealMatrix getOmegaInverse() {
        if (this.OmegaInverse == null) {
            this.OmegaInverse = new LUDecompositionImpl(this.Omega).getSolver().getInverse();
        }
        return this.OmegaInverse;
    }

    protected RealVector calculateBeta() {
        RealMatrix OI = this.getOmegaInverse();
        RealMatrix XT = this.X.transpose();
        RealMatrix XTOIX = XT.multiply(OI).multiply(this.X);
        RealMatrix inverse = new LUDecompositionImpl(XTOIX).getSolver().getInverse();
        return inverse.multiply(XT).multiply(OI).operate(this.Y);
    }

    protected RealMatrix calculateBetaVariance() {
        RealMatrix OI = this.getOmegaInverse();
        RealMatrix XTOIX = this.X.transpose().multiply(OI).multiply(this.X);
        return new LUDecompositionImpl(XTOIX).getSolver().getInverse();
    }

    protected double calculateErrorVariance() {
        RealVector residuals = this.calculateResiduals();
        double t = residuals.dotProduct(this.getOmegaInverse().operate(residuals));
        return t / (double)(this.X.getRowDimension() - this.X.getColumnDimension());
    }
}

