/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.org.apache.commons.math;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.Locale;
import org.apache.hive.org.apache.commons.math.exception.MathThrowable;
import org.apache.hive.org.apache.commons.math.exception.util.DummyLocalizable;
import org.apache.hive.org.apache.commons.math.exception.util.Localizable;
import org.apache.hive.org.apache.commons.math.exception.util.LocalizedFormats;

public class MathException
extends Exception
implements MathThrowable {
    private static final long serialVersionUID = 7428019509644517071L;
    private final Localizable pattern;
    private final Object[] arguments;

    public MathException() {
        this.pattern = LocalizedFormats.SIMPLE_MESSAGE;
        this.arguments = new Object[]{""};
    }

    @Deprecated
    public MathException(String pattern, Object ... arguments) {
        this(new DummyLocalizable(pattern), arguments);
    }

    public MathException(Localizable pattern, Object ... arguments) {
        this.pattern = pattern;
        this.arguments = arguments == null ? new Object[]{} : (Object[])arguments.clone();
    }

    public MathException(Throwable rootCause) {
        super(rootCause);
        this.pattern = LocalizedFormats.SIMPLE_MESSAGE;
        this.arguments = new Object[]{rootCause == null ? "" : rootCause.getMessage()};
    }

    @Deprecated
    public MathException(Throwable rootCause, String pattern, Object ... arguments) {
        this(rootCause, new DummyLocalizable(pattern), arguments);
    }

    public MathException(Throwable rootCause, Localizable pattern, Object ... arguments) {
        super(rootCause);
        this.pattern = pattern;
        this.arguments = arguments == null ? new Object[]{} : (Object[])arguments.clone();
    }

    @Deprecated
    public String getPattern() {
        return this.pattern.getSourceString();
    }

    public Localizable getSpecificPattern() {
        return null;
    }

    public Localizable getGeneralPattern() {
        return this.pattern;
    }

    public Object[] getArguments() {
        return (Object[])this.arguments.clone();
    }

    public String getMessage(Locale locale) {
        if (this.pattern != null) {
            return new MessageFormat(this.pattern.getLocalizedString(locale), locale).format(this.arguments);
        }
        return "";
    }

    public String getMessage() {
        return this.getMessage(Locale.US);
    }

    public String getLocalizedMessage() {
        return this.getMessage(Locale.getDefault());
    }

    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStackTrace(PrintStream out) {
        PrintStream printStream = out;
        synchronized (printStream) {
            PrintWriter pw = new PrintWriter(out, false);
            this.printStackTrace(pw);
            pw.flush();
        }
    }
}

