/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.org.apache.commons.configuration;

import java.io.File;
import java.io.FilterWriter;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.hive.org.apache.commons.configuration.AbstractConfiguration;
import org.apache.hive.org.apache.commons.configuration.AbstractFileConfiguration;
import org.apache.hive.org.apache.commons.configuration.ConfigurationException;
import org.apache.hive.org.apache.commons.configuration.ConfigurationRuntimeException;
import org.apache.hive.org.apache.commons.configuration.ConfigurationUtils;
import org.apache.hive.org.apache.commons.configuration.PropertiesConfigurationLayout;
import org.apache.hive.org.apache.commons.lang.ArrayUtils;
import org.apache.hive.org.apache.commons.lang.StringEscapeUtils;
import org.apache.hive.org.apache.commons.lang.StringUtils;

public class PropertiesConfiguration
extends AbstractFileConfiguration {
    static final String COMMENT_CHARS = "#!";
    private static String include = "include";
    private static final char[] SEPARATORS = new char[]{'=', ':'};
    private static final char[] WHITE_SPACE = new char[]{' ', '\t', '\f'};
    private static final String DEFAULT_ENCODING = "ISO-8859-1";
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final String ESCAPE = "\\";
    private static final int HEX_RADIX = 16;
    private static final int UNICODE_LEN = 4;
    private PropertiesConfigurationLayout layout;
    private boolean includesAllowed;

    public PropertiesConfiguration() {
        this.layout = this.createLayout();
        this.setIncludesAllowed(false);
    }

    public PropertiesConfiguration(String fileName) throws ConfigurationException {
        super(fileName);
    }

    public PropertiesConfiguration(File file) throws ConfigurationException {
        super(file);
        this.getLayout();
    }

    public PropertiesConfiguration(URL url) throws ConfigurationException {
        super(url);
    }

    public static String getInclude() {
        return include;
    }

    public static void setInclude(String inc) {
        include = inc;
    }

    protected void setIncludesAllowed(boolean includesAllowed) {
        this.includesAllowed = includesAllowed;
    }

    public boolean getIncludesAllowed() {
        return this.includesAllowed;
    }

    public String getHeader() {
        return this.getLayout().getHeaderComment();
    }

    public void setHeader(String header) {
        this.getLayout().setHeaderComment(header);
    }

    public String getEncoding() {
        String enc = super.getEncoding();
        return enc != null ? enc : DEFAULT_ENCODING;
    }

    public synchronized PropertiesConfigurationLayout getLayout() {
        if (this.layout == null) {
            this.layout = this.createLayout();
        }
        return this.layout;
    }

    public synchronized void setLayout(PropertiesConfigurationLayout layout) {
        if (this.layout != null) {
            this.removeConfigurationListener(this.layout);
        }
        this.layout = layout == null ? this.createLayout() : layout;
    }

    protected PropertiesConfigurationLayout createLayout() {
        return new PropertiesConfigurationLayout(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void load(Reader in) throws ConfigurationException {
        boolean oldAutoSave = this.isAutoSave();
        this.setAutoSave(false);
        try {
            this.getLayout().load(in);
        }
        finally {
            this.setAutoSave(oldAutoSave);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(Writer writer) throws ConfigurationException {
        this.enterNoReload();
        try {
            this.getLayout().save(writer);
        }
        finally {
            this.exitNoReload();
        }
    }

    public void setBasePath(String basePath) {
        super.setBasePath(basePath);
        this.setIncludesAllowed(StringUtils.isNotEmpty(basePath));
    }

    public Object clone() {
        PropertiesConfiguration copy = (PropertiesConfiguration)super.clone();
        if (this.layout != null) {
            copy.setLayout(new PropertiesConfigurationLayout(copy, this.layout));
        }
        return copy;
    }

    boolean propertyLoaded(String key, String value) throws ConfigurationException {
        boolean result;
        if (StringUtils.isNotEmpty(PropertiesConfiguration.getInclude()) && key.equalsIgnoreCase(PropertiesConfiguration.getInclude())) {
            if (this.getIncludesAllowed()) {
                String[] files = !this.isDelimiterParsingDisabled() ? StringUtils.split(value, this.getListDelimiter()) : new String[]{value};
                for (int i = 0; i < files.length; ++i) {
                    this.loadIncludeFile(this.interpolate(files[i].trim()));
                }
            }
            result = false;
        } else {
            this.addProperty(key, value);
            result = true;
        }
        return result;
    }

    static boolean isCommentLine(String line) {
        String s = line.trim();
        return s.length() < 1 || COMMENT_CHARS.indexOf(s.charAt(0)) >= 0;
    }

    protected static String unescapeJava(String str, char delimiter) {
        if (str == null) {
            return null;
        }
        int sz = str.length();
        StringBuffer out = new StringBuffer(sz);
        StringBuffer unicode = new StringBuffer(4);
        boolean hadSlash = false;
        boolean inUnicode = false;
        for (int i = 0; i < sz; ++i) {
            char ch = str.charAt(i);
            if (inUnicode) {
                unicode.append(ch);
                if (unicode.length() != 4) continue;
                try {
                    int value = Integer.parseInt(unicode.toString(), 16);
                    out.append((char)value);
                    unicode.setLength(0);
                    inUnicode = false;
                    hadSlash = false;
                    continue;
                }
                catch (NumberFormatException nfe) {
                    throw new ConfigurationRuntimeException("Unable to parse unicode value: " + unicode, nfe);
                }
            }
            if (hadSlash) {
                hadSlash = false;
                if (ch == '\\') {
                    out.append('\\');
                    continue;
                }
                if (ch == '\'') {
                    out.append('\'');
                    continue;
                }
                if (ch == '\"') {
                    out.append('\"');
                    continue;
                }
                if (ch == 'r') {
                    out.append('\r');
                    continue;
                }
                if (ch == 'f') {
                    out.append('\f');
                    continue;
                }
                if (ch == 't') {
                    out.append('\t');
                    continue;
                }
                if (ch == 'n') {
                    out.append('\n');
                    continue;
                }
                if (ch == 'b') {
                    out.append('\b');
                    continue;
                }
                if (ch == delimiter) {
                    out.append('\\');
                    out.append(delimiter);
                    continue;
                }
                if (ch == 'u') {
                    inUnicode = true;
                    continue;
                }
                out.append(ch);
                continue;
            }
            if (ch == '\\') {
                hadSlash = true;
                continue;
            }
            out.append(ch);
        }
        if (hadSlash) {
            out.append('\\');
        }
        return out.toString();
    }

    private void loadIncludeFile(String fileName) throws ConfigurationException {
        URL baseURL;
        URL url = ConfigurationUtils.locate(this.getBasePath(), fileName);
        if (url == null && (baseURL = this.getURL()) != null) {
            url = ConfigurationUtils.locate(baseURL.toString(), fileName);
        }
        if (url == null) {
            throw new ConfigurationException("Cannot resolve include file " + fileName);
        }
        this.load(url);
    }

    public static class PropertiesWriter
    extends FilterWriter {
        private char delimiter;

        public PropertiesWriter(Writer writer, char delimiter) {
            super(writer);
            this.delimiter = delimiter;
        }

        public void writeProperty(String key, Object value) throws IOException {
            this.writeProperty(key, value, false);
        }

        public void writeProperty(String key, List values) throws IOException {
            for (int i = 0; i < values.size(); ++i) {
                this.writeProperty(key, values.get(i));
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        public void writeProperty(String key, Object value, boolean forceSingleLine) throws IOException {
            String v;
            if (value instanceof List) {
                List values = (List)value;
                if (!forceSingleLine) {
                    this.writeProperty(key, values);
                    return;
                }
                v = this.makeSingleLineValue(values);
            } else {
                v = this.escapeValue(value);
            }
            this.write(this.escapeKey(key));
            this.write(" = ");
            this.write(v);
            this.writeln(null);
        }

        public void writeComment(String comment) throws IOException {
            this.writeln("# " + comment);
        }

        private String escapeKey(String key) {
            StringBuffer newkey = new StringBuffer();
            for (int i = 0; i < key.length(); ++i) {
                char c = key.charAt(i);
                if (ArrayUtils.contains(SEPARATORS, c) || ArrayUtils.contains(WHITE_SPACE, c)) {
                    newkey.append('\\');
                    newkey.append(c);
                    continue;
                }
                newkey.append(c);
            }
            return newkey.toString();
        }

        private String escapeValue(Object value) {
            String escapedValue = StringEscapeUtils.escapeJava(String.valueOf(value));
            if (this.delimiter != '\u0000') {
                escapedValue = StringUtils.replace(escapedValue, String.valueOf(this.delimiter), PropertiesConfiguration.ESCAPE + this.delimiter);
            }
            return escapedValue;
        }

        private String makeSingleLineValue(List values) {
            if (!values.isEmpty()) {
                Iterator it = values.iterator();
                String lastValue = this.escapeValue(it.next());
                StringBuffer buf = new StringBuffer(lastValue);
                while (it.hasNext()) {
                    if (lastValue.endsWith(PropertiesConfiguration.ESCAPE)) {
                        buf.append(PropertiesConfiguration.ESCAPE).append(PropertiesConfiguration.ESCAPE);
                    }
                    buf.append(this.delimiter);
                    lastValue = this.escapeValue(it.next());
                    buf.append(lastValue);
                }
                return buf.toString();
            }
            return null;
        }

        public void writeln(String s) throws IOException {
            if (s != null) {
                this.write(s);
            }
            this.write(LINE_SEPARATOR);
        }
    }

    public static class PropertiesReader
    extends LineNumberReader {
        private List commentLines = new ArrayList();
        private String propertyName;
        private String propertyValue;
        private char delimiter;

        public PropertiesReader(Reader reader) {
            this(reader, AbstractConfiguration.getDefaultListDelimiter());
        }

        public PropertiesReader(Reader reader, char listDelimiter) {
            super(reader);
            this.delimiter = listDelimiter;
        }

        public String readProperty() throws IOException {
            String line;
            this.commentLines.clear();
            StringBuffer buffer = new StringBuffer();
            while (true) {
                if ((line = this.readLine()) == null) {
                    return null;
                }
                if (PropertiesConfiguration.isCommentLine(line)) {
                    this.commentLines.add(line);
                    continue;
                }
                if (!PropertiesReader.checkCombineLines(line = line.trim())) break;
                line = line.substring(0, line.length() - 1);
                buffer.append(line);
            }
            buffer.append(line);
            return buffer.toString();
        }

        public boolean nextProperty() throws IOException {
            String line = this.readProperty();
            if (line == null) {
                return false;
            }
            String[] property = PropertiesReader.parseProperty(line);
            this.propertyName = StringEscapeUtils.unescapeJava(property[0]);
            this.propertyValue = PropertiesConfiguration.unescapeJava(property[1], this.delimiter);
            return true;
        }

        public List getCommentLines() {
            return this.commentLines;
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public String getPropertyValue() {
            return this.propertyValue;
        }

        private static boolean checkCombineLines(String line) {
            int bsCount = 0;
            for (int idx = line.length() - 1; idx >= 0 && line.charAt(idx) == '\\'; --idx) {
                ++bsCount;
            }
            return bsCount % 2 != 0;
        }

        private static String[] parseProperty(String line) {
            String[] result = new String[2];
            StringBuffer key = new StringBuffer();
            StringBuffer value = new StringBuffer();
            int state = 0;
            block6: for (int pos = 0; pos < line.length(); ++pos) {
                char c = line.charAt(pos);
                switch (state) {
                    case 0: {
                        if (c == '\\') {
                            state = 1;
                            continue block6;
                        }
                        if (ArrayUtils.contains(WHITE_SPACE, c)) {
                            state = 2;
                            continue block6;
                        }
                        if (ArrayUtils.contains(SEPARATORS, c)) {
                            state = 3;
                            continue block6;
                        }
                        key.append(c);
                        continue block6;
                    }
                    case 1: {
                        if (ArrayUtils.contains(SEPARATORS, c) || ArrayUtils.contains(WHITE_SPACE, c)) {
                            key.append(c);
                        } else {
                            key.append('\\');
                            key.append(c);
                        }
                        state = 0;
                        continue block6;
                    }
                    case 2: {
                        if (ArrayUtils.contains(WHITE_SPACE, c)) {
                            state = 2;
                            continue block6;
                        }
                        if (ArrayUtils.contains(SEPARATORS, c)) {
                            state = 3;
                            continue block6;
                        }
                        value.append(c);
                        state = 3;
                        continue block6;
                    }
                    case 3: {
                        value.append(c);
                    }
                }
            }
            result[0] = key.toString().trim();
            result[1] = value.toString().trim();
            return result;
        }
    }
}

