/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.javolution.text;

import java.text.ParsePosition;
import org.apache.hive.javolution.context.ObjectFactory;
import org.apache.hive.javolution.lang.Reusable;
import org.apache.hive.javolution.text.CharSet;

public class Cursor
extends ParsePosition
implements Reusable {
    private static final ObjectFactory FACTORY = new ObjectFactory(){

        protected Object create() {
            return new Cursor();
        }
    };

    public Cursor() {
        super(0);
    }

    public static Cursor newInstance() {
        return (Cursor)FACTORY.object();
    }

    public static void recycle(Cursor cursor) {
        FACTORY.recycle(cursor);
    }

    public final int getIndex() {
        return super.getIndex();
    }

    public void setIndex(int i) {
        super.setIndex(i);
    }

    public final boolean atEnd(CharSequence csq) {
        return this.getIndex() >= csq.length();
    }

    public final boolean at(char c, CharSequence csq) {
        int i = this.getIndex();
        return i < csq.length() ? csq.charAt(i) == c : false;
    }

    public final boolean at(CharSet charSet, CharSequence csq) {
        int i = this.getIndex();
        return i < csq.length() ? charSet.contains(csq.charAt(i)) : false;
    }

    public final boolean at(String str, CharSequence csq) {
        int i = this.getIndex();
        int length = csq.length();
        int j = 0;
        while (j < str.length()) {
            if (i < length && str.charAt(j++) == csq.charAt(i++)) continue;
            return false;
        }
        return true;
    }

    public final char nextChar(CharSequence csq) {
        int i = this.getIndex();
        this.setIndex(i + 1);
        return csq.charAt(i);
    }

    public final boolean skipAny(char c, CharSequence csq) {
        int i;
        int n = csq.length();
        for (i = this.getIndex(); i < n && csq.charAt(i) == c; ++i) {
        }
        if (i == this.getIndex()) {
            return false;
        }
        this.setIndex(i);
        return true;
    }

    public final boolean skipAny(CharSet charSet, CharSequence csq) {
        int i;
        int n = csq.length();
        for (i = this.getIndex(); i < n && charSet.contains(csq.charAt(i)); ++i) {
        }
        if (i == this.getIndex()) {
            return false;
        }
        this.setIndex(i);
        return true;
    }

    public final boolean skip(char c, CharSequence csq) {
        if (this.at(c, csq)) {
            this.increment();
            return true;
        }
        return false;
    }

    public final boolean skip(CharSet charSet, CharSequence csq) {
        if (this.at(charSet, csq)) {
            this.increment();
            return true;
        }
        return false;
    }

    public final boolean skip(String str, CharSequence csq) {
        if (this.at(str, csq)) {
            this.increment(str.length());
            return true;
        }
        return false;
    }

    public final CharSequence nextToken(CharSequence csq, char c) {
        int n = csq.length();
        for (int i = this.getIndex(); i < n; ++i) {
            if (csq.charAt(i) == c) continue;
            int j = i;
            while (++j < n && csq.charAt(j) != c) {
            }
            this.setIndex(j);
            return csq.subSequence(i, j);
        }
        this.setIndex(n);
        return null;
    }

    public final CharSequence nextToken(CharSequence csq, CharSet charSet) {
        int n = csq.length();
        for (int i = this.getIndex(); i < n; ++i) {
            if (charSet.contains(csq.charAt(i))) continue;
            int j = i;
            while (++j < n && !charSet.contains(csq.charAt(j))) {
            }
            this.setIndex(j);
            return csq.subSequence(i, j);
        }
        this.setIndex(n);
        return null;
    }

    public final Cursor increment() {
        return this.increment(1);
    }

    public final Cursor increment(int i) {
        this.setIndex(this.getIndex() + i);
        return this;
    }

    public String toString() {
        return "Index: " + this.getIndex();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Cursor)) {
            return false;
        }
        return this.getIndex() == ((Cursor)obj).getIndex();
    }

    public int hashCode() {
        return this.getIndex();
    }

    public void reset() {
        super.setIndex(0);
        super.setErrorIndex(-1);
    }
}

