/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.javolution.context;

import org.apache.hive.javolution.context.ObjectFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ArrayFactory<T> {
    public static final ArrayFactory<boolean[]> BOOLEANS_FACTORY = new ArrayFactory(){

        protected Object create(int size) {
            return new boolean[size];
        }

        public void recycle(Object array) {
            this.recycle(array, ((boolean[])array).length);
        }
    };
    public static final ArrayFactory<byte[]> BYTES_FACTORY = new ArrayFactory(){

        protected Object create(int size) {
            return new byte[size];
        }

        public void recycle(Object array) {
            this.recycle(array, ((byte[])array).length);
        }
    };
    public static final ArrayFactory<char[]> CHARS_FACTORY = new ArrayFactory(){

        protected Object create(int size) {
            return new char[size];
        }

        public void recycle(Object array) {
            this.recycle(array, ((char[])array).length);
        }
    };
    public static final ArrayFactory<short[]> SHORTS_FACTORY = new ArrayFactory(){

        protected Object create(int size) {
            return new short[size];
        }

        public void recycle(Object array) {
            this.recycle(array, ((short[])array).length);
        }
    };
    public static final ArrayFactory<int[]> INTS_FACTORY = new ArrayFactory(){

        protected Object create(int size) {
            return new int[size];
        }

        public void recycle(Object array) {
            this.recycle(array, ((int[])array).length);
        }
    };
    public static final ArrayFactory<long[]> LONGS_FACTORY = new ArrayFactory(){

        protected Object create(int size) {
            return new long[size];
        }

        public void recycle(Object array) {
            this.recycle(array, ((long[])array).length);
        }
    };
    public static final ArrayFactory<float[]> FLOATS_FACTORY = new ArrayFactory(){

        protected Object create(int size) {
            return new float[size];
        }

        public void recycle(Object array) {
            this.recycle(array, ((float[])array).length);
        }
    };
    public static final ArrayFactory<double[]> DOUBLES_FACTORY = new ArrayFactory(){

        protected Object create(int size) {
            return new double[size];
        }

        public void recycle(Object array) {
            this.recycle(array, ((double[])array).length);
        }
    };
    public static final ArrayFactory<Object[]> OBJECTS_FACTORY = new ArrayFactory(){

        protected Object create(int size) {
            return new Object[size];
        }

        public void recycle(Object array) {
            this.recycle(array, ((Object[])array).length);
        }
    };
    private final ObjectFactory _factory4 = new ObjectFactory(){

        protected Object create() {
            return ArrayFactory.this.create(4);
        }
    };
    private final ObjectFactory _factory8 = new ObjectFactory(){

        protected Object create() {
            return ArrayFactory.this.create(8);
        }
    };
    private final ObjectFactory _factory16 = new ObjectFactory(){

        protected Object create() {
            return ArrayFactory.this.create(16);
        }
    };
    private final ObjectFactory _factory32 = new ObjectFactory(){

        protected Object create() {
            return ArrayFactory.this.create(32);
        }
    };
    private final ObjectFactory _factory64 = new ObjectFactory(){

        protected Object create() {
            return ArrayFactory.this.create(64);
        }
    };
    private final ObjectFactory _factory128 = new ObjectFactory(){

        protected Object create() {
            return ArrayFactory.this.create(128);
        }
    };
    private final ObjectFactory _factory256 = new ObjectFactory(){

        protected Object create() {
            return ArrayFactory.this.create(256);
        }
    };
    private final ObjectFactory _factory512 = new ObjectFactory(){

        protected Object create() {
            return ArrayFactory.this.create(512);
        }
    };
    private final ObjectFactory _factory1024 = new ObjectFactory(){

        protected Object create() {
            return ArrayFactory.this.create(1024);
        }
    };
    private final ObjectFactory _factory2048 = new ObjectFactory(){

        protected Object create() {
            return ArrayFactory.this.create(2048);
        }
    };
    private final ObjectFactory _factory4096 = new ObjectFactory(){

        protected Object create() {
            return ArrayFactory.this.create(4096);
        }
    };
    private final ObjectFactory _factory8192 = new ObjectFactory(){

        protected Object create() {
            return ArrayFactory.this.create(8192);
        }
    };
    private final ObjectFactory _factory16384 = new ObjectFactory(){

        protected Object create() {
            return ArrayFactory.this.create(16384);
        }
    };
    private final ObjectFactory _factory32768 = new ObjectFactory(){

        protected Object create() {
            return ArrayFactory.this.create(32768);
        }
    };
    private final ObjectFactory _factory65536 = new ObjectFactory(){

        protected Object create() {
            return ArrayFactory.this.create(65536);
        }
    };

    public final T array(int capacity) {
        return capacity <= 4 ? this._factory4.object() : this.largeArray(capacity);
    }

    private final T largeArray(int capacity) {
        if (capacity <= 8) {
            return this._factory8.object();
        }
        if (capacity <= 16) {
            return this._factory16.object();
        }
        if (capacity <= 32) {
            return this._factory32.object();
        }
        if (capacity <= 64) {
            return this._factory64.object();
        }
        if (capacity <= 128) {
            return this._factory128.object();
        }
        if (capacity <= 256) {
            return this._factory256.object();
        }
        if (capacity <= 512) {
            return this._factory512.object();
        }
        if (capacity <= 1024) {
            return this._factory1024.object();
        }
        if (capacity <= 2048) {
            return this._factory2048.object();
        }
        if (capacity <= 4096) {
            return this._factory4096.object();
        }
        if (capacity <= 8192) {
            return this._factory8192.object();
        }
        if (capacity <= 16384) {
            return this._factory16384.object();
        }
        if (capacity <= 32768) {
            return this._factory32768.object();
        }
        if (capacity <= 65536) {
            return this._factory65536.object();
        }
        return this.create(capacity);
    }

    public void recycle(T array) {
        int length = ((Object[])array).length;
        if (length <= 4) {
            this._factory4.recycle(array);
        } else {
            this.recycle(array, length);
        }
    }

    final void recycle(Object array, int length) {
        if (length <= 8) {
            this._factory8.recycle(array);
        } else if (length <= 16) {
            this._factory16.recycle(array);
        } else if (length <= 32) {
            this._factory32.recycle(array);
        } else if (length <= 64) {
            this._factory64.recycle(array);
        } else if (length <= 128) {
            this._factory128.recycle(array);
        } else if (length <= 256) {
            this._factory256.recycle(array);
        } else if (length <= 512) {
            this._factory512.recycle(array);
        } else if (length <= 1024) {
            this._factory1024.recycle(array);
        } else if (length <= 2048) {
            this._factory2048.recycle(array);
        } else if (length <= 4096) {
            this._factory4096.recycle(array);
        } else if (length <= 8192) {
            this._factory8192.recycle(array);
        } else if (length <= 16384) {
            this._factory16384.recycle(array);
        } else if (length <= 32768) {
            this._factory32768.recycle(array);
        } else if (length <= 65536) {
            this._factory65536.recycle(array);
        }
    }

    protected abstract T create(int var1);
}

