/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.api;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.apache.hive.org.apache.thrift.EncodingUtils;
import org.apache.hive.org.apache.thrift.TBase;
import org.apache.hive.org.apache.thrift.TBaseHelper;
import org.apache.hive.org.apache.thrift.TException;
import org.apache.hive.org.apache.thrift.TFieldIdEnum;
import org.apache.hive.org.apache.thrift.meta_data.FieldMetaData;
import org.apache.hive.org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.hive.org.apache.thrift.protocol.TCompactProtocol;
import org.apache.hive.org.apache.thrift.protocol.TField;
import org.apache.hive.org.apache.thrift.protocol.TProtocol;
import org.apache.hive.org.apache.thrift.protocol.TProtocolException;
import org.apache.hive.org.apache.thrift.protocol.TProtocolUtil;
import org.apache.hive.org.apache.thrift.protocol.TStruct;
import org.apache.hive.org.apache.thrift.protocol.TTupleProtocol;
import org.apache.hive.org.apache.thrift.scheme.IScheme;
import org.apache.hive.org.apache.thrift.scheme.SchemeFactory;
import org.apache.hive.org.apache.thrift.scheme.StandardScheme;
import org.apache.hive.org.apache.thrift.scheme.TupleScheme;
import org.apache.hive.org.apache.thrift.transport.TIOStreamTransport;

public class PartitionsByExprRequest
implements TBase<PartitionsByExprRequest, _Fields>,
Serializable,
Cloneable,
Comparable<PartitionsByExprRequest> {
    private static final TStruct STRUCT_DESC = new TStruct("PartitionsByExprRequest");
    private static final TField DB_NAME_FIELD_DESC = new TField("dbName", 11, 1);
    private static final TField TBL_NAME_FIELD_DESC = new TField("tblName", 11, 2);
    private static final TField EXPR_FIELD_DESC = new TField("expr", 11, 3);
    private static final TField DEFAULT_PARTITION_NAME_FIELD_DESC = new TField("defaultPartitionName", 11, 4);
    private static final TField MAX_PARTS_FIELD_DESC = new TField("maxParts", 6, 5);
    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    private String dbName;
    private String tblName;
    private ByteBuffer expr;
    private String defaultPartitionName;
    private short maxParts;
    private static final int __MAXPARTS_ISSET_ID = 0;
    private byte __isset_bitfield = 0;
    private static final _Fields[] optionals;
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public PartitionsByExprRequest() {
        this.maxParts = (short)-1;
    }

    public PartitionsByExprRequest(String dbName, String tblName, ByteBuffer expr) {
        this();
        this.dbName = dbName;
        this.tblName = tblName;
        this.expr = TBaseHelper.copyBinary(expr);
    }

    public PartitionsByExprRequest(PartitionsByExprRequest other) {
        this.__isset_bitfield = other.__isset_bitfield;
        if (other.isSetDbName()) {
            this.dbName = other.dbName;
        }
        if (other.isSetTblName()) {
            this.tblName = other.tblName;
        }
        if (other.isSetExpr()) {
            this.expr = TBaseHelper.copyBinary(other.expr);
        }
        if (other.isSetDefaultPartitionName()) {
            this.defaultPartitionName = other.defaultPartitionName;
        }
        this.maxParts = other.maxParts;
    }

    public PartitionsByExprRequest deepCopy() {
        return new PartitionsByExprRequest(this);
    }

    @Override
    public void clear() {
        this.dbName = null;
        this.tblName = null;
        this.expr = null;
        this.defaultPartitionName = null;
        this.maxParts = (short)-1;
    }

    public String getDbName() {
        return this.dbName;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    public void unsetDbName() {
        this.dbName = null;
    }

    public boolean isSetDbName() {
        return this.dbName != null;
    }

    public void setDbNameIsSet(boolean value) {
        if (!value) {
            this.dbName = null;
        }
    }

    public String getTblName() {
        return this.tblName;
    }

    public void setTblName(String tblName) {
        this.tblName = tblName;
    }

    public void unsetTblName() {
        this.tblName = null;
    }

    public boolean isSetTblName() {
        return this.tblName != null;
    }

    public void setTblNameIsSet(boolean value) {
        if (!value) {
            this.tblName = null;
        }
    }

    public byte[] getExpr() {
        this.setExpr(TBaseHelper.rightSize(this.expr));
        return this.expr == null ? null : this.expr.array();
    }

    public ByteBuffer bufferForExpr() {
        return TBaseHelper.copyBinary(this.expr);
    }

    public void setExpr(byte[] expr) {
        this.expr = expr == null ? (ByteBuffer)null : ByteBuffer.wrap(Arrays.copyOf(expr, expr.length));
    }

    public void setExpr(ByteBuffer expr) {
        this.expr = TBaseHelper.copyBinary(expr);
    }

    public void unsetExpr() {
        this.expr = null;
    }

    public boolean isSetExpr() {
        return this.expr != null;
    }

    public void setExprIsSet(boolean value) {
        if (!value) {
            this.expr = null;
        }
    }

    public String getDefaultPartitionName() {
        return this.defaultPartitionName;
    }

    public void setDefaultPartitionName(String defaultPartitionName) {
        this.defaultPartitionName = defaultPartitionName;
    }

    public void unsetDefaultPartitionName() {
        this.defaultPartitionName = null;
    }

    public boolean isSetDefaultPartitionName() {
        return this.defaultPartitionName != null;
    }

    public void setDefaultPartitionNameIsSet(boolean value) {
        if (!value) {
            this.defaultPartitionName = null;
        }
    }

    public short getMaxParts() {
        return this.maxParts;
    }

    public void setMaxParts(short maxParts) {
        this.maxParts = maxParts;
        this.setMaxPartsIsSet(true);
    }

    public void unsetMaxParts() {
        this.__isset_bitfield = EncodingUtils.clearBit(this.__isset_bitfield, 0);
    }

    public boolean isSetMaxParts() {
        return EncodingUtils.testBit(this.__isset_bitfield, 0);
    }

    public void setMaxPartsIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit(this.__isset_bitfield, 0, value);
    }

    @Override
    public void setFieldValue(_Fields field, Object value) {
        switch (field) {
            case DB_NAME: {
                if (value == null) {
                    this.unsetDbName();
                    break;
                }
                this.setDbName((String)value);
                break;
            }
            case TBL_NAME: {
                if (value == null) {
                    this.unsetTblName();
                    break;
                }
                this.setTblName((String)value);
                break;
            }
            case EXPR: {
                if (value == null) {
                    this.unsetExpr();
                    break;
                }
                this.setExpr((ByteBuffer)value);
                break;
            }
            case DEFAULT_PARTITION_NAME: {
                if (value == null) {
                    this.unsetDefaultPartitionName();
                    break;
                }
                this.setDefaultPartitionName((String)value);
                break;
            }
            case MAX_PARTS: {
                if (value == null) {
                    this.unsetMaxParts();
                    break;
                }
                this.setMaxParts((Short)value);
            }
        }
    }

    @Override
    public Object getFieldValue(_Fields field) {
        switch (field) {
            case DB_NAME: {
                return this.getDbName();
            }
            case TBL_NAME: {
                return this.getTblName();
            }
            case EXPR: {
                return this.getExpr();
            }
            case DEFAULT_PARTITION_NAME: {
                return this.getDefaultPartitionName();
            }
            case MAX_PARTS: {
                return this.getMaxParts();
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case DB_NAME: {
                return this.isSetDbName();
            }
            case TBL_NAME: {
                return this.isSetTblName();
            }
            case EXPR: {
                return this.isSetExpr();
            }
            case DEFAULT_PARTITION_NAME: {
                return this.isSetDefaultPartitionName();
            }
            case MAX_PARTS: {
                return this.isSetMaxParts();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (that instanceof PartitionsByExprRequest) {
            return this.equals((PartitionsByExprRequest)that);
        }
        return false;
    }

    public boolean equals(PartitionsByExprRequest that) {
        if (that == null) {
            return false;
        }
        boolean this_present_dbName = this.isSetDbName();
        boolean that_present_dbName = that.isSetDbName();
        if (this_present_dbName || that_present_dbName) {
            if (!this_present_dbName || !that_present_dbName) {
                return false;
            }
            if (!this.dbName.equals(that.dbName)) {
                return false;
            }
        }
        boolean this_present_tblName = this.isSetTblName();
        boolean that_present_tblName = that.isSetTblName();
        if (this_present_tblName || that_present_tblName) {
            if (!this_present_tblName || !that_present_tblName) {
                return false;
            }
            if (!this.tblName.equals(that.tblName)) {
                return false;
            }
        }
        boolean this_present_expr = this.isSetExpr();
        boolean that_present_expr = that.isSetExpr();
        if (this_present_expr || that_present_expr) {
            if (!this_present_expr || !that_present_expr) {
                return false;
            }
            if (!this.expr.equals(that.expr)) {
                return false;
            }
        }
        boolean this_present_defaultPartitionName = this.isSetDefaultPartitionName();
        boolean that_present_defaultPartitionName = that.isSetDefaultPartitionName();
        if (this_present_defaultPartitionName || that_present_defaultPartitionName) {
            if (!this_present_defaultPartitionName || !that_present_defaultPartitionName) {
                return false;
            }
            if (!this.defaultPartitionName.equals(that.defaultPartitionName)) {
                return false;
            }
        }
        boolean this_present_maxParts = this.isSetMaxParts();
        boolean that_present_maxParts = that.isSetMaxParts();
        if (this_present_maxParts || that_present_maxParts) {
            if (!this_present_maxParts || !that_present_maxParts) {
                return false;
            }
            if (this.maxParts != that.maxParts) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        ArrayList<Object> list = new ArrayList<Object>();
        boolean present_dbName = this.isSetDbName();
        list.add(present_dbName);
        if (present_dbName) {
            list.add(this.dbName);
        }
        boolean present_tblName = this.isSetTblName();
        list.add(present_tblName);
        if (present_tblName) {
            list.add(this.tblName);
        }
        boolean present_expr = this.isSetExpr();
        list.add(present_expr);
        if (present_expr) {
            list.add(this.expr);
        }
        boolean present_defaultPartitionName = this.isSetDefaultPartitionName();
        list.add(present_defaultPartitionName);
        if (present_defaultPartitionName) {
            list.add(this.defaultPartitionName);
        }
        boolean present_maxParts = this.isSetMaxParts();
        list.add(present_maxParts);
        if (present_maxParts) {
            list.add(this.maxParts);
        }
        return list.hashCode();
    }

    @Override
    public int compareTo(PartitionsByExprRequest other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        lastComparison = Boolean.valueOf(this.isSetDbName()).compareTo(other.isSetDbName());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetDbName() && (lastComparison = TBaseHelper.compareTo(this.dbName, other.dbName)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetTblName()).compareTo(other.isSetTblName());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetTblName() && (lastComparison = TBaseHelper.compareTo(this.tblName, other.tblName)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetExpr()).compareTo(other.isSetExpr());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetExpr() && (lastComparison = TBaseHelper.compareTo(this.expr, other.expr)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetDefaultPartitionName()).compareTo(other.isSetDefaultPartitionName());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetDefaultPartitionName() && (lastComparison = TBaseHelper.compareTo(this.defaultPartitionName, other.defaultPartitionName)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetMaxParts()).compareTo(other.isSetMaxParts());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetMaxParts() && (lastComparison = TBaseHelper.compareTo(this.maxParts, other.maxParts)) != 0) {
            return lastComparison;
        }
        return 0;
    }

    @Override
    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    @Override
    public void read(TProtocol iprot) throws TException {
        schemes.get(iprot.getScheme()).getScheme().read(iprot, (PartitionsByExprRequest)this);
    }

    @Override
    public void write(TProtocol oprot) throws TException {
        schemes.get(oprot.getScheme()).getScheme().write(oprot, (PartitionsByExprRequest)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("PartitionsByExprRequest(");
        boolean first = true;
        sb.append("dbName:");
        if (this.dbName == null) {
            sb.append("null");
        } else {
            sb.append(this.dbName);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("tblName:");
        if (this.tblName == null) {
            sb.append("null");
        } else {
            sb.append(this.tblName);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("expr:");
        if (this.expr == null) {
            sb.append("null");
        } else {
            TBaseHelper.toString(this.expr, sb);
        }
        first = false;
        if (this.isSetDefaultPartitionName()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("defaultPartitionName:");
            if (this.defaultPartitionName == null) {
                sb.append("null");
            } else {
                sb.append(this.defaultPartitionName);
            }
            first = false;
        }
        if (this.isSetMaxParts()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("maxParts:");
            sb.append(this.maxParts);
            first = false;
        }
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
        if (!this.isSetDbName()) {
            throw new TProtocolException("Required field 'dbName' is unset! Struct:" + this.toString());
        }
        if (!this.isSetTblName()) {
            throw new TProtocolException("Required field 'tblName' is unset! Struct:" + this.toString());
        }
        if (!this.isSetExpr()) {
            throw new TProtocolException("Required field 'expr' is unset! Struct:" + this.toString());
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write(new TCompactProtocol(new TIOStreamTransport(out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.__isset_bitfield = 0;
            this.read(new TCompactProtocol(new TIOStreamTransport(in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    static {
        schemes.put(StandardScheme.class, new PartitionsByExprRequestStandardSchemeFactory());
        schemes.put(TupleScheme.class, new PartitionsByExprRequestTupleSchemeFactory());
        optionals = new _Fields[]{_Fields.DEFAULT_PARTITION_NAME, _Fields.MAX_PARTS};
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.DB_NAME, new FieldMetaData("dbName", 1, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.TBL_NAME, new FieldMetaData("tblName", 1, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.EXPR, new FieldMetaData("expr", 1, new FieldValueMetaData(11, true)));
        tmpMap.put(_Fields.DEFAULT_PARTITION_NAME, new FieldMetaData("defaultPartitionName", 2, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.MAX_PARTS, new FieldMetaData("maxParts", 2, new FieldValueMetaData(6)));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(PartitionsByExprRequest.class, metaDataMap);
    }

    private static class PartitionsByExprRequestTupleScheme
    extends TupleScheme<PartitionsByExprRequest> {
        private PartitionsByExprRequestTupleScheme() {
        }

        @Override
        public void write(TProtocol prot, PartitionsByExprRequest struct) throws TException {
            TTupleProtocol oprot = (TTupleProtocol)prot;
            oprot.writeString(struct.dbName);
            oprot.writeString(struct.tblName);
            oprot.writeBinary(struct.expr);
            BitSet optionals = new BitSet();
            if (struct.isSetDefaultPartitionName()) {
                optionals.set(0);
            }
            if (struct.isSetMaxParts()) {
                optionals.set(1);
            }
            oprot.writeBitSet(optionals, 2);
            if (struct.isSetDefaultPartitionName()) {
                oprot.writeString(struct.defaultPartitionName);
            }
            if (struct.isSetMaxParts()) {
                oprot.writeI16(struct.maxParts);
            }
        }

        @Override
        public void read(TProtocol prot, PartitionsByExprRequest struct) throws TException {
            TTupleProtocol iprot = (TTupleProtocol)prot;
            struct.dbName = iprot.readString();
            struct.setDbNameIsSet(true);
            struct.tblName = iprot.readString();
            struct.setTblNameIsSet(true);
            struct.expr = iprot.readBinary();
            struct.setExprIsSet(true);
            BitSet incoming = iprot.readBitSet(2);
            if (incoming.get(0)) {
                struct.defaultPartitionName = iprot.readString();
                struct.setDefaultPartitionNameIsSet(true);
            }
            if (incoming.get(1)) {
                struct.maxParts = iprot.readI16();
                struct.setMaxPartsIsSet(true);
            }
        }
    }

    private static class PartitionsByExprRequestTupleSchemeFactory
    implements SchemeFactory {
        private PartitionsByExprRequestTupleSchemeFactory() {
        }

        public PartitionsByExprRequestTupleScheme getScheme() {
            return new PartitionsByExprRequestTupleScheme();
        }
    }

    private static class PartitionsByExprRequestStandardScheme
    extends StandardScheme<PartitionsByExprRequest> {
        private PartitionsByExprRequestStandardScheme() {
        }

        @Override
        public void read(TProtocol iprot, PartitionsByExprRequest struct) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField schemeField = iprot.readFieldBegin();
                if (schemeField.type == 0) break;
                switch (schemeField.id) {
                    case 1: {
                        if (schemeField.type == 11) {
                            struct.dbName = iprot.readString();
                            struct.setDbNameIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 2: {
                        if (schemeField.type == 11) {
                            struct.tblName = iprot.readString();
                            struct.setTblNameIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 3: {
                        if (schemeField.type == 11) {
                            struct.expr = iprot.readBinary();
                            struct.setExprIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 4: {
                        if (schemeField.type == 11) {
                            struct.defaultPartitionName = iprot.readString();
                            struct.setDefaultPartitionNameIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 5: {
                        if (schemeField.type == 6) {
                            struct.maxParts = iprot.readI16();
                            struct.setMaxPartsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, schemeField.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            struct.validate();
        }

        @Override
        public void write(TProtocol oprot, PartitionsByExprRequest struct) throws TException {
            struct.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (struct.dbName != null) {
                oprot.writeFieldBegin(DB_NAME_FIELD_DESC);
                oprot.writeString(struct.dbName);
                oprot.writeFieldEnd();
            }
            if (struct.tblName != null) {
                oprot.writeFieldBegin(TBL_NAME_FIELD_DESC);
                oprot.writeString(struct.tblName);
                oprot.writeFieldEnd();
            }
            if (struct.expr != null) {
                oprot.writeFieldBegin(EXPR_FIELD_DESC);
                oprot.writeBinary(struct.expr);
                oprot.writeFieldEnd();
            }
            if (struct.defaultPartitionName != null && struct.isSetDefaultPartitionName()) {
                oprot.writeFieldBegin(DEFAULT_PARTITION_NAME_FIELD_DESC);
                oprot.writeString(struct.defaultPartitionName);
                oprot.writeFieldEnd();
            }
            if (struct.isSetMaxParts()) {
                oprot.writeFieldBegin(MAX_PARTS_FIELD_DESC);
                oprot.writeI16(struct.maxParts);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }
    }

    private static class PartitionsByExprRequestStandardSchemeFactory
    implements SchemeFactory {
        private PartitionsByExprRequestStandardSchemeFactory() {
        }

        public PartitionsByExprRequestStandardScheme getScheme() {
            return new PartitionsByExprRequestStandardScheme();
        }
    }

    public static enum _Fields implements TFieldIdEnum
    {
        DB_NAME(1, "dbName"),
        TBL_NAME(2, "tblName"),
        EXPR(3, "expr"),
        DEFAULT_PARTITION_NAME(4, "defaultPartitionName"),
        MAX_PARTS(5, "maxParts");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return DB_NAME;
                }
                case 2: {
                    return TBL_NAME;
                }
                case 3: {
                    return EXPR;
                }
                case 4: {
                    return DEFAULT_PARTITION_NAME;
                }
                case 5: {
                    return MAX_PARTS;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        @Override
        public short getThriftFieldId() {
            return this._thriftId;
        }

        @Override
        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

