/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.tez;

import com.google.protobuf.ByteString;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.apache.hadoop.hive.llap.daemon.rpc.LlapDaemonProtocolProtos;
import org.apache.hadoop.hive.llap.tez.Converters;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hive.com.google.common.collect.Lists;
import org.apache.tez.dag.api.InputDescriptor;
import org.apache.tez.dag.api.OutputDescriptor;
import org.apache.tez.dag.api.ProcessorDescriptor;
import org.apache.tez.dag.api.UserPayload;
import org.apache.tez.dag.records.TezDAGID;
import org.apache.tez.dag.records.TezTaskAttemptID;
import org.apache.tez.dag.records.TezTaskID;
import org.apache.tez.dag.records.TezVertexID;
import org.apache.tez.runtime.api.impl.InputSpec;
import org.apache.tez.runtime.api.impl.OutputSpec;
import org.apache.tez.runtime.api.impl.TaskSpec;
import org.junit.Assert;
import org.junit.Test;

public class TestConverters {
    @Test(timeout=10000L)
    public void testTaskSpecToFragmentSpec() {
        ByteBuffer procBb = ByteBuffer.allocate(4);
        procBb.putInt(0, 200);
        UserPayload processorPayload = UserPayload.create((ByteBuffer)procBb);
        ProcessorDescriptor processorDescriptor = (ProcessorDescriptor)ProcessorDescriptor.create((String)"fakeProcessorName").setUserPayload(processorPayload);
        ByteBuffer input1Bb = ByteBuffer.allocate(4);
        input1Bb.putInt(0, 300);
        UserPayload input1Payload = UserPayload.create((ByteBuffer)input1Bb);
        InputDescriptor id1 = (InputDescriptor)InputDescriptor.create((String)"input1ClassName").setUserPayload(input1Payload);
        InputSpec inputSpec1 = new InputSpec("sourceVertexName1", id1, 33);
        InputSpec inputSpec2 = new InputSpec("sourceVertexName2", id1, 44);
        ArrayList<InputSpec> inputSpecList = Lists.newArrayList(inputSpec1, inputSpec2);
        ByteBuffer output1Bb = ByteBuffer.allocate(4);
        output1Bb.putInt(0, 400);
        UserPayload output1Payload = UserPayload.create((ByteBuffer)output1Bb);
        OutputDescriptor od1 = (OutputDescriptor)OutputDescriptor.create((String)"output1ClassName").setUserPayload(output1Payload);
        OutputSpec outputSpec1 = new OutputSpec("destVertexName1", od1, 55);
        OutputSpec outputSpec2 = new OutputSpec("destVertexName2", od1, 66);
        ArrayList<OutputSpec> outputSpecList = Lists.newArrayList(outputSpec1, outputSpec2);
        ApplicationId appId = ApplicationId.newInstance((long)1000L, (int)100);
        TezDAGID tezDagId = TezDAGID.getInstance((ApplicationId)appId, (int)300);
        TezVertexID tezVertexId = TezVertexID.getInstance((TezDAGID)tezDagId, (int)400);
        TezTaskID tezTaskId = TezTaskID.getInstance((TezVertexID)tezVertexId, (int)500);
        TezTaskAttemptID tezTaskAttemptId = TezTaskAttemptID.getInstance((TezTaskID)tezTaskId, (int)600);
        TaskSpec taskSpec = new TaskSpec(tezTaskAttemptId, "dagName", "vertexName", 10, processorDescriptor, inputSpecList, outputSpecList, null);
        LlapDaemonProtocolProtos.QueryIdentifierProto queryIdentifierProto = LlapDaemonProtocolProtos.QueryIdentifierProto.newBuilder().setApplicationIdString(appId.toString()).setAppAttemptNumber(333).setDagIndex(300).build();
        LlapDaemonProtocolProtos.SignableVertexSpec vertexProto = Converters.constructSignableVertexSpec(taskSpec, queryIdentifierProto, "", "", "hiveQueryId").build();
        Assert.assertEquals((Object)"dagName", (Object)vertexProto.getDagName());
        Assert.assertEquals((Object)"vertexName", (Object)vertexProto.getVertexName());
        Assert.assertEquals((Object)"hiveQueryId", (Object)vertexProto.getHiveQueryId());
        Assert.assertEquals((Object)appId.toString(), (Object)vertexProto.getQueryIdentifier().getApplicationIdString());
        Assert.assertEquals((long)tezDagId.getId(), (long)vertexProto.getQueryIdentifier().getDagIndex());
        Assert.assertEquals((long)333L, (long)vertexProto.getQueryIdentifier().getAppAttemptNumber());
        Assert.assertEquals((long)tezVertexId.getId(), (long)vertexProto.getVertexIndex());
        Assert.assertEquals((Object)processorDescriptor.getClassName(), (Object)vertexProto.getProcessorDescriptor().getClassName());
        Assert.assertEquals((Object)processorDescriptor.getUserPayload().getPayload(), (Object)vertexProto.getProcessorDescriptor().getUserPayload().getUserPayload().asReadOnlyByteBuffer());
        Assert.assertEquals((long)2L, (long)vertexProto.getInputSpecsCount());
        Assert.assertEquals((long)2L, (long)vertexProto.getOutputSpecsCount());
        this.verifyInputSpecAndProto(inputSpec1, vertexProto.getInputSpecs(0));
        this.verifyInputSpecAndProto(inputSpec2, vertexProto.getInputSpecs(1));
        this.verifyOutputSpecAndProto(outputSpec1, vertexProto.getOutputSpecs(0));
        this.verifyOutputSpecAndProto(outputSpec2, vertexProto.getOutputSpecs(1));
    }

    @Test(timeout=10000L)
    public void testFragmentSpecToTaskSpec() {
        ByteBuffer procBb = ByteBuffer.allocate(4);
        procBb.putInt(0, 200);
        ByteBuffer input1Bb = ByteBuffer.allocate(4);
        input1Bb.putInt(0, 300);
        ByteBuffer output1Bb = ByteBuffer.allocate(4);
        output1Bb.putInt(0, 400);
        ApplicationId appId = ApplicationId.newInstance((long)1000L, (int)100);
        TezDAGID tezDagId = TezDAGID.getInstance((ApplicationId)appId, (int)300);
        TezVertexID tezVertexId = TezVertexID.getInstance((TezDAGID)tezDagId, (int)400);
        TezTaskID tezTaskId = TezTaskID.getInstance((TezVertexID)tezVertexId, (int)500);
        TezTaskAttemptID tezTaskAttemptId = TezTaskAttemptID.getInstance((TezTaskID)tezTaskId, (int)600);
        LlapDaemonProtocolProtos.QueryIdentifierProto queryIdentifierProto = LlapDaemonProtocolProtos.QueryIdentifierProto.newBuilder().setApplicationIdString(appId.toString()).setAppAttemptNumber(333).setDagIndex(tezDagId.getId()).build();
        LlapDaemonProtocolProtos.SignableVertexSpec.Builder builder = LlapDaemonProtocolProtos.SignableVertexSpec.newBuilder();
        builder.setQueryIdentifier(queryIdentifierProto);
        builder.setHiveQueryId("hiveQueryId");
        builder.setVertexIndex(tezVertexId.getId());
        builder.setDagName("dagName");
        builder.setVertexName("vertexName");
        builder.setProcessorDescriptor(LlapDaemonProtocolProtos.EntityDescriptorProto.newBuilder().setClassName("fakeProcessorName").setUserPayload(LlapDaemonProtocolProtos.UserPayloadProto.newBuilder().setUserPayload(ByteString.copyFrom((ByteBuffer)procBb))));
        builder.addInputSpecs(LlapDaemonProtocolProtos.IOSpecProto.newBuilder().setConnectedVertexName("sourceVertexName1").setPhysicalEdgeCount(33).setIoDescriptor(LlapDaemonProtocolProtos.EntityDescriptorProto.newBuilder().setClassName("input1ClassName").setUserPayload(LlapDaemonProtocolProtos.UserPayloadProto.newBuilder().setUserPayload(ByteString.copyFrom((ByteBuffer)input1Bb)))));
        builder.addInputSpecs(LlapDaemonProtocolProtos.IOSpecProto.newBuilder().setConnectedVertexName("sourceVertexName2").setPhysicalEdgeCount(44).setIoDescriptor(LlapDaemonProtocolProtos.EntityDescriptorProto.newBuilder().setClassName("input1ClassName").setUserPayload(LlapDaemonProtocolProtos.UserPayloadProto.newBuilder().setUserPayload(ByteString.copyFrom((ByteBuffer)input1Bb)))));
        builder.addOutputSpecs(LlapDaemonProtocolProtos.IOSpecProto.newBuilder().setConnectedVertexName("destVertexName1").setPhysicalEdgeCount(55).setIoDescriptor(LlapDaemonProtocolProtos.EntityDescriptorProto.newBuilder().setClassName("outputClassName").setUserPayload(LlapDaemonProtocolProtos.UserPayloadProto.newBuilder().setUserPayload(ByteString.copyFrom((ByteBuffer)output1Bb)))));
        builder.addOutputSpecs(LlapDaemonProtocolProtos.IOSpecProto.newBuilder().setConnectedVertexName("destVertexName2").setPhysicalEdgeCount(66).setIoDescriptor(LlapDaemonProtocolProtos.EntityDescriptorProto.newBuilder().setClassName("outputClassName").setUserPayload(LlapDaemonProtocolProtos.UserPayloadProto.newBuilder().setUserPayload(ByteString.copyFrom((ByteBuffer)output1Bb)))));
        LlapDaemonProtocolProtos.SignableVertexSpec vertexProto = builder.build();
        TaskSpec taskSpec = Converters.getTaskSpecfromProto(vertexProto, 0, 0, tezTaskAttemptId);
        Assert.assertEquals((Object)"dagName", (Object)taskSpec.getDAGName());
        Assert.assertEquals((Object)"vertexName", (Object)taskSpec.getVertexName());
        Assert.assertEquals((Object)tezTaskAttemptId, (Object)taskSpec.getTaskAttemptID());
        Assert.assertEquals((Object)"fakeProcessorName", (Object)taskSpec.getProcessorDescriptor().getClassName());
        byte[] serialized = new byte[taskSpec.getProcessorDescriptor().getUserPayload().getPayload().remaining()];
        taskSpec.getProcessorDescriptor().getUserPayload().getPayload().get(serialized);
        Assert.assertArrayEquals((byte[])procBb.array(), (byte[])serialized);
        Assert.assertEquals((long)2L, (long)taskSpec.getInputs().size());
        Assert.assertEquals((long)2L, (long)taskSpec.getOutputs().size());
        this.verifyInputSpecAndProto((InputSpec)taskSpec.getInputs().get(0), vertexProto.getInputSpecs(0));
        this.verifyInputSpecAndProto((InputSpec)taskSpec.getInputs().get(1), vertexProto.getInputSpecs(1));
        this.verifyOutputSpecAndProto((OutputSpec)taskSpec.getOutputs().get(0), vertexProto.getOutputSpecs(0));
        this.verifyOutputSpecAndProto((OutputSpec)taskSpec.getOutputs().get(1), vertexProto.getOutputSpecs(1));
    }

    private void verifyInputSpecAndProto(InputSpec inputSpec, LlapDaemonProtocolProtos.IOSpecProto inputSpecProto) {
        Assert.assertEquals((long)inputSpec.getPhysicalEdgeCount(), (long)inputSpecProto.getPhysicalEdgeCount());
        Assert.assertEquals((Object)inputSpec.getSourceVertexName(), (Object)inputSpecProto.getConnectedVertexName());
        Assert.assertEquals((Object)inputSpec.getInputDescriptor().getClassName(), (Object)inputSpecProto.getIoDescriptor().getClassName());
        Assert.assertEquals((Object)inputSpec.getInputDescriptor().getUserPayload().getPayload(), (Object)inputSpecProto.getIoDescriptor().getUserPayload().getUserPayload().asReadOnlyByteBuffer());
    }

    private void verifyOutputSpecAndProto(OutputSpec outputSpec, LlapDaemonProtocolProtos.IOSpecProto outputSpecProto) {
        Assert.assertEquals((long)outputSpec.getPhysicalEdgeCount(), (long)outputSpecProto.getPhysicalEdgeCount());
        Assert.assertEquals((Object)outputSpec.getDestinationVertexName(), (Object)outputSpecProto.getConnectedVertexName());
        Assert.assertEquals((Object)outputSpec.getOutputDescriptor().getClassName(), (Object)outputSpecProto.getIoDescriptor().getClassName());
        Assert.assertEquals((Object)outputSpec.getOutputDescriptor().getUserPayload().getPayload(), (Object)outputSpecProto.getIoDescriptor().getUserPayload().getUserPayload().asReadOnlyByteBuffer());
    }
}

