/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.metrics;

import org.apache.hadoop.hive.llap.metrics.LlapDaemonIOInfo;
import org.apache.hadoop.hive.llap.metrics.LlapMetricsSystem;
import org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.hadoop.metrics2.MetricsInfo;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.MetricsSource;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.impl.MsInfo;
import org.apache.hadoop.metrics2.lib.MetricsRegistry;
import org.apache.hadoop.metrics2.lib.MutableGaugeLong;
import org.apache.hadoop.metrics2.lib.MutableQuantiles;
import org.apache.hadoop.metrics2.lib.MutableRate;
import org.apache.hive.org.slf4j.Logger;
import org.apache.hive.org.slf4j.LoggerFactory;

@Metrics(about="LlapDaemon IO Metrics", context="io")
public class LlapDaemonIOMetrics
implements MetricsSource {
    protected static final Logger LOG = LoggerFactory.getLogger(LlapDaemonIOMetrics.class);
    private final String name;
    private final String sessionId;
    private final MetricsRegistry registry;
    private long maxTime = Long.MIN_VALUE;
    @Metric
    MutableRate rateOfDecoding;
    final MutableQuantiles[] decodingTimes;
    @Metric
    MutableGaugeLong maxDecodingTime;

    private LlapDaemonIOMetrics(String displayName, String sessionId, int[] intervals) {
        this.name = displayName;
        this.sessionId = sessionId;
        this.registry = new MetricsRegistry("LlapDaemonIORegistry");
        this.registry.tag((MetricsInfo)MsInfo.ProcessName, "LlapDaemon").tag((MetricsInfo)MsInfo.SessionId, sessionId);
        int len = intervals == null ? 0 : intervals.length;
        this.decodingTimes = new MutableQuantiles[len];
        for (int i = 0; i < len; ++i) {
            int interval = intervals[i];
            LOG.info("Created interval " + LlapDaemonIOInfo.PercentileDecodingTime.name() + "_" + interval + "s");
            this.decodingTimes[i] = this.registry.newQuantiles(LlapDaemonIOInfo.PercentileDecodingTime.name() + "_" + interval + "s", LlapDaemonIOInfo.PercentileDecodingTime.description(), "ops", "latency", interval);
        }
    }

    public static LlapDaemonIOMetrics create(String displayName, String sessionId, int[] intervals) {
        MetricsSystem ms = LlapMetricsSystem.instance();
        return (LlapDaemonIOMetrics)ms.register(displayName, null, (Object)new LlapDaemonIOMetrics(displayName, sessionId, intervals));
    }

    public void getMetrics(MetricsCollector collector, boolean b) {
        MetricsRecordBuilder rb = collector.addRecord((MetricsInfo)LlapDaemonIOInfo.IOMetrics).setContext("io").tag((MetricsInfo)MsInfo.ProcessName, "LlapDaemon").tag((MetricsInfo)MsInfo.SessionId, this.sessionId);
        this.getIoStats(rb);
    }

    public String getName() {
        return this.name;
    }

    public void addDecodeBatchTime(long latency) {
        this.rateOfDecoding.add(latency);
        if (latency > this.maxTime) {
            this.maxTime = latency;
            this.maxDecodingTime.set(this.maxTime);
        }
        for (MutableQuantiles q : this.decodingTimes) {
            q.add(latency);
        }
    }

    private void getIoStats(MetricsRecordBuilder rb) {
        rb.addGauge((MetricsInfo)LlapDaemonIOInfo.MaxDecodingTime, this.maxDecodingTime.value());
        this.rateOfDecoding.snapshot(rb, true);
        for (MutableQuantiles q : this.decodingTimes) {
            q.snapshot(rb, true);
        }
    }
}

