/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.io.decode;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.hive.common.io.encoded.EncodedColumnBatch;
import org.apache.hadoop.hive.llap.counters.LlapIOCounters;
import org.apache.hadoop.hive.llap.counters.QueryFragmentCounters;
import org.apache.hadoop.hive.llap.io.api.impl.ColumnVectorBatch;
import org.apache.hadoop.hive.llap.io.api.impl.LlapIoImpl;
import org.apache.hadoop.hive.llap.io.decode.EncodedDataConsumer;
import org.apache.hadoop.hive.llap.io.metadata.ConsumerFileMetadata;
import org.apache.hadoop.hive.llap.io.metadata.ConsumerStripeMetadata;
import org.apache.hadoop.hive.llap.metrics.LlapDaemonIOMetrics;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ListColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.MapColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.StructColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.TimestampColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.UnionColumnVector;
import org.apache.hadoop.hive.ql.io.orc.encoded.Consumer;
import org.apache.hadoop.hive.ql.io.orc.encoded.EncodedTreeReaderFactory;
import org.apache.hadoop.hive.ql.io.orc.encoded.OrcBatchKey;
import org.apache.hadoop.hive.ql.io.orc.encoded.Reader;
import org.apache.orc.CompressionCodec;
import org.apache.orc.CompressionKind;
import org.apache.orc.OrcProto;
import org.apache.orc.TypeDescription;
import org.apache.orc.impl.PositionProvider;
import org.apache.orc.impl.RecordReaderImpl;
import org.apache.orc.impl.SchemaEvolution;
import org.apache.orc.impl.TreeReaderFactory;
import org.apache.orc.impl.WriterImpl;

public class OrcEncodedDataConsumer
extends EncodedDataConsumer<OrcBatchKey, Reader.OrcEncodedColumnBatch> {
    private TreeReaderFactory.TreeReader[] columnReaders;
    private int[] columnMapping;
    private int previousStripeIndex = -1;
    private ConsumerFileMetadata fileMetadata;
    private CompressionCodec codec;
    private List<ConsumerStripeMetadata> stripes;
    private final boolean skipCorrupt;
    private final QueryFragmentCounters counters;
    private boolean[] includedColumns;
    private SchemaEvolution evolution;

    public OrcEncodedDataConsumer(Consumer<ColumnVectorBatch> consumer, int colCount, boolean skipCorrupt, QueryFragmentCounters counters, LlapDaemonIOMetrics ioMetrics) {
        super(consumer, colCount, ioMetrics);
        this.skipCorrupt = skipCorrupt;
        this.counters = counters;
    }

    public void setFileMetadata(ConsumerFileMetadata f) {
        assert (this.fileMetadata == null);
        this.fileMetadata = f;
        this.stripes = new ArrayList<ConsumerStripeMetadata>(f.getStripeCount());
        this.codec = WriterImpl.createCodec((CompressionKind)this.fileMetadata.getCompressionKind());
    }

    public void setStripeMetadata(ConsumerStripeMetadata m) {
        assert (this.stripes != null);
        int newIx = m.getStripeIx();
        for (int i = this.stripes.size(); i <= newIx; ++i) {
            this.stripes.add(null);
        }
        assert (this.stripes.get(newIx) == null);
        this.stripes.set(newIx, m);
    }

    @Override
    protected void decodeBatch(Reader.OrcEncodedColumnBatch batch, Consumer<ColumnVectorBatch> downstreamConsumer) {
        long startTime = this.counters.startTimeCounter();
        int currentStripeIndex = ((OrcBatchKey)batch.getBatchKey()).stripeIx;
        boolean sameStripe = currentStripeIndex == this.previousStripeIndex;
        try {
            ConsumerStripeMetadata stripeMetadata = this.stripes.get(currentStripeIndex);
            int rgIdx = ((OrcBatchKey)batch.getBatchKey()).rgIx;
            long nonNullRowCount = -1L;
            if (rgIdx == -1) {
                nonNullRowCount = stripeMetadata.getRowCount();
            } else {
                OrcProto.RowIndexEntry rowIndex = stripeMetadata.getRowIndexEntry(0, rgIdx);
                nonNullRowCount = this.getRowCount(rowIndex);
            }
            int maxBatchesRG = (int)(nonNullRowCount / 1024L + 1L);
            int batchSize = 1024;
            TypeDescription schema = this.fileMetadata.getSchema();
            if (this.columnReaders == null || !sameStripe) {
                int[] columnMapping = new int[schema.getChildren().size()];
                TreeReaderFactory.ReaderContext context = new TreeReaderFactory.ReaderContext().setSchemaEvolution(this.evolution).writerTimeZone(stripeMetadata.getWriterTimezone()).skipCorrupt(this.skipCorrupt);
                TreeReaderFactory.StructTreeReader treeReader = EncodedTreeReaderFactory.createRootTreeReader((TypeDescription)schema, stripeMetadata.getEncodings(), (Reader.OrcEncodedColumnBatch)batch, (CompressionCodec)this.codec, (TreeReaderFactory.Context)context, (int[])columnMapping);
                this.columnReaders = treeReader.getChildReaders();
                this.columnMapping = Arrays.copyOf(columnMapping, this.columnReaders.length);
                this.positionInStreams(this.columnReaders, (OrcBatchKey)batch.getBatchKey(), stripeMetadata);
            } else {
                this.repositionInStreams(this.columnReaders, (EncodedColumnBatch<OrcBatchKey>)batch, sameStripe, stripeMetadata);
            }
            this.previousStripeIndex = currentStripeIndex;
            for (int i = 0; i < maxBatchesRG && (i != maxBatchesRG - 1 || (batchSize = (int)(nonNullRowCount % 1024L)) != 0); ++i) {
                ColumnVectorBatch cvb = (ColumnVectorBatch)this.cvbPool.take();
                cvb.size = batchSize;
                for (int idx = 0; idx < this.columnReaders.length; ++idx) {
                    TreeReaderFactory.TreeReader reader = this.columnReaders[idx];
                    if (cvb.cols[idx] == null) {
                        cvb.cols[idx] = this.createColumn((TypeDescription)schema.getChildren().get(this.columnMapping[idx]), batchSize);
                    }
                    cvb.cols[idx].ensureSize(batchSize, false);
                    reader.nextVector(cvb.cols[idx], null, batchSize);
                }
                downstreamConsumer.consumeData((Object)cvb);
                this.counters.incrCounter(LlapIOCounters.ROWS_EMITTED, batchSize);
            }
            LlapIoImpl.ORC_LOGGER.debug("Done with decode");
            this.counters.incrTimeCounter(LlapIOCounters.DECODE_TIME_NS, startTime);
            this.counters.incrCounter(LlapIOCounters.NUM_VECTOR_BATCHES, maxBatchesRG);
            this.counters.incrCounter(LlapIOCounters.NUM_DECODED_BATCHES);
        }
        catch (IOException e) {
            downstreamConsumer.setError((Throwable)e);
        }
    }

    private ColumnVector createColumn(TypeDescription type, int batchSize) {
        switch (type.getCategory()) {
            case BOOLEAN: 
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: 
            case DATE: {
                return new LongColumnVector(batchSize);
            }
            case FLOAT: 
            case DOUBLE: {
                return new DoubleColumnVector(batchSize);
            }
            case BINARY: 
            case STRING: 
            case CHAR: 
            case VARCHAR: {
                return new BytesColumnVector(batchSize);
            }
            case TIMESTAMP: {
                return new TimestampColumnVector(batchSize);
            }
            case DECIMAL: {
                return new DecimalColumnVector(batchSize, type.getPrecision(), type.getScale());
            }
            case STRUCT: {
                List subtypeIdxs = type.getChildren();
                ColumnVector[] fieldVector = new ColumnVector[subtypeIdxs.size()];
                for (int i = 0; i < fieldVector.length; ++i) {
                    fieldVector[i] = this.createColumn((TypeDescription)subtypeIdxs.get(i), batchSize);
                }
                return new StructColumnVector(batchSize, fieldVector);
            }
            case UNION: {
                List subtypeIdxs = type.getChildren();
                ColumnVector[] fieldVector = new ColumnVector[subtypeIdxs.size()];
                for (int i = 0; i < fieldVector.length; ++i) {
                    fieldVector[i] = this.createColumn((TypeDescription)subtypeIdxs.get(i), batchSize);
                }
                return new UnionColumnVector(batchSize, fieldVector);
            }
            case LIST: {
                return new ListColumnVector(batchSize, this.createColumn((TypeDescription)type.getChildren().get(0), batchSize));
            }
            case MAP: {
                List subtypeIdxs = type.getChildren();
                return new MapColumnVector(batchSize, this.createColumn((TypeDescription)subtypeIdxs.get(0), batchSize), this.createColumn((TypeDescription)subtypeIdxs.get(1), batchSize));
            }
        }
        throw new IllegalArgumentException("LLAP does not support " + type.getCategory());
    }

    private void positionInStreams(TreeReaderFactory.TreeReader[] columnReaders, OrcBatchKey batchKey, ConsumerStripeMetadata stripeMetadata) throws IOException {
        PositionProvider[] pps = this.createPositionProviders(columnReaders, batchKey, stripeMetadata);
        if (pps == null) {
            return;
        }
        for (int i = 0; i < columnReaders.length; ++i) {
            columnReaders[i].seek(pps);
        }
    }

    private void repositionInStreams(TreeReaderFactory.TreeReader[] columnReaders, EncodedColumnBatch<OrcBatchKey> batch, boolean sameStripe, ConsumerStripeMetadata stripeMetadata) throws IOException {
        PositionProvider[] pps = this.createPositionProviders(columnReaders, batch.getBatchKey(), stripeMetadata);
        if (pps == null) {
            return;
        }
        for (int i = 0; i < columnReaders.length; ++i) {
            TreeReaderFactory.TreeReader reader = columnReaders[i];
            ((EncodedTreeReaderFactory.SettableTreeReader)reader).setBuffers(batch, sameStripe);
            if (reader instanceof EncodedTreeReaderFactory.TimestampStreamReader && !sameStripe) {
                ((EncodedTreeReaderFactory.TimestampStreamReader)reader).updateTimezone(stripeMetadata.getWriterTimezone());
            }
            reader.seek(pps);
        }
    }

    private PositionProvider[] createPositionProviders(TreeReaderFactory.TreeReader[] columnReaders, OrcBatchKey batchKey, ConsumerStripeMetadata stripeMetadata) throws IOException {
        if (columnReaders.length == 0) {
            return null;
        }
        PositionProvider[] pps = null;
        if (!stripeMetadata.supportsRowIndexes()) {
            IndexlessPositionProvider singleRgPp = new IndexlessPositionProvider();
            pps = new PositionProvider[stripeMetadata.getEncodings().size()];
            for (int i = 0; i < pps.length; ++i) {
                pps[i] = singleRgPp;
            }
        } else {
            int rowGroupIndex = batchKey.rgIx;
            if (rowGroupIndex == -1) {
                throw new IOException("Cannot position readers without RG information");
            }
            OrcProto.RowIndex[] ris = stripeMetadata.getRowIndexes();
            pps = new PositionProvider[ris.length];
            for (int i = 0; i < ris.length; ++i) {
                OrcProto.RowIndex ri = ris[i];
                if (ri == null) continue;
                pps[i] = new RecordReaderImpl.PositionProviderImpl(ri.getEntry(rowGroupIndex));
            }
        }
        return pps;
    }

    private long getRowCount(OrcProto.RowIndexEntry rowIndexEntry) {
        return rowIndexEntry.getStatistics().getNumberOfValues();
    }

    @Override
    public boolean[] getIncludedColumns() {
        return this.includedColumns;
    }

    public void setIncludedColumns(boolean[] includedColumns) {
        this.includedColumns = includedColumns;
    }

    public void setSchemaEvolution(SchemaEvolution evolution) {
        this.evolution = evolution;
    }

    @Override
    public SchemaEvolution getSchemaEvolution() {
        return this.evolution;
    }

    private static final class IndexlessPositionProvider
    implements PositionProvider {
        private IndexlessPositionProvider() {
        }

        public long getNext() {
            return 0L;
        }

        public String toString() {
            return "indexes not supported";
        }
    }
}

