/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.daemon.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hive.llap.security.LlapTokenIdentifier;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hive.com.google.common.annotations.VisibleForTesting;
import org.apache.hive.com.google.common.base.Preconditions;
import org.apache.hive.org.apache.commons.lang3.StringUtils;
import org.apache.hive.org.slf4j.Logger;
import org.apache.hive.org.slf4j.LoggerFactory;

public final class LlapTokenChecker {
    private static final Logger LOG = LoggerFactory.getLogger(LlapTokenChecker.class);
    private static final LlapTokenInfo NO_SECURITY = new LlapTokenInfo(null, null, false);

    public static LlapTokenInfo getTokenInfo(String clusterId) throws IOException {
        if (!UserGroupInformation.isSecurityEnabled()) {
            return NO_SECURITY;
        }
        UserGroupInformation current = UserGroupInformation.getCurrentUser();
        String kerberosName = current.hasKerberosCredentials() ? current.getShortUserName() : null;
        List<LlapTokenIdentifier> tokens = LlapTokenChecker.getLlapTokens(current, clusterId);
        if ((tokens == null || tokens.isEmpty()) && kerberosName == null) {
            throw new SecurityException("No tokens or kerberos for " + current);
        }
        LlapTokenChecker.warnMultipleTokens(tokens);
        return LlapTokenChecker.getTokenInfoInternal(kerberosName, tokens);
    }

    public static void warnMultipleTokens(List<LlapTokenIdentifier> tokens) {
        if (tokens != null && tokens.size() > 1) {
            StringBuilder sb = new StringBuilder("Found multiple LLAP tokens: [");
            boolean isFirst = true;
            for (LlapTokenIdentifier ti : tokens) {
                if (!isFirst) {
                    sb.append(", ");
                }
                isFirst = false;
                sb.append((Object)ti);
            }
            LOG.warn(sb.append("]").toString());
        }
    }

    static List<LlapTokenIdentifier> getLlapTokens(UserGroupInformation ugi, String clusterId) {
        ArrayList<LlapTokenIdentifier> tokens = null;
        for (TokenIdentifier id : ugi.getTokenIdentifiers()) {
            if (!LlapTokenIdentifier.KIND_NAME.equals((Object)id.getKind())) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Token {}", (Object)id);
            }
            LlapTokenIdentifier llapId = (LlapTokenIdentifier)id;
            if (clusterId != null && !clusterId.equals(llapId.getClusterId())) continue;
            if (tokens == null) {
                tokens = new ArrayList<LlapTokenIdentifier>();
            }
            tokens.add((LlapTokenIdentifier)id);
        }
        return tokens;
    }

    @VisibleForTesting
    static LlapTokenInfo getTokenInfoInternal(String kerberosName, List<LlapTokenIdentifier> tokens) {
        assert (tokens != null && !tokens.isEmpty() || kerberosName != null);
        if (tokens == null) {
            return new LlapTokenInfo(kerberosName, null, true);
        }
        String userName = kerberosName;
        String appId = null;
        boolean isSigningRequired = false;
        for (LlapTokenIdentifier llapId : tokens) {
            String newUserName = llapId.getOwner().toString();
            if (userName != null && !userName.equals(newUserName)) {
                throw new SecurityException("Ambiguous user name from credentials - " + userName + " and " + newUserName + " from " + (Object)((Object)llapId) + (kerberosName == null ? "; has kerberos credentials for " + kerberosName : ""));
            }
            userName = newUserName;
            String newAppId = llapId.getAppId();
            if (!StringUtils.isEmpty(newAppId)) {
                if (!StringUtils.isEmpty(appId) && !appId.equals(newAppId)) {
                    throw new SecurityException("Ambiguous app ID from credentials - " + appId + " and " + newAppId + " from " + (Object)((Object)llapId));
                }
                appId = newAppId;
            }
            isSigningRequired = isSigningRequired || llapId.isSigningRequired();
        }
        assert (userName != null);
        return new LlapTokenInfo(userName, appId, isSigningRequired);
    }

    public static void checkPermissions(String clusterId, String userName, String appId, Object hint) throws IOException {
        if (!UserGroupInformation.isSecurityEnabled()) {
            return;
        }
        Preconditions.checkNotNull(userName);
        UserGroupInformation current = UserGroupInformation.getCurrentUser();
        String kerberosName = current.hasKerberosCredentials() ? current.getShortUserName() : null;
        List<LlapTokenIdentifier> tokens = LlapTokenChecker.getLlapTokens(current, clusterId);
        LlapTokenChecker.checkPermissionsInternal(kerberosName, tokens, userName, appId, hint);
    }

    @VisibleForTesting
    static void checkPermissionsInternal(String kerberosName, List<LlapTokenIdentifier> tokens, String userName, String appId, Object hint) {
        if (appId == null) {
            appId = "";
        }
        if (kerberosName != null && StringUtils.isBlank(appId) && kerberosName.equals(userName)) {
            return;
        }
        if (tokens != null) {
            for (LlapTokenIdentifier llapId : tokens) {
                String tokenAppId;
                String tokenUser = llapId.getOwner().toString();
                if (!LlapTokenChecker.checkTokenPermissions(userName, appId, tokenUser, tokenAppId = llapId.getAppId())) continue;
                return;
            }
        }
        throw new SecurityException("Unauthorized to access " + userName + ", " + appId + " (" + hint + ")");
    }

    public static void checkPermissions(LlapTokenInfo prm, String userName, String appId, Object hint) {
        if (userName == null) {
            assert (StringUtils.isEmpty(appId));
            return;
        }
        if (!LlapTokenChecker.checkTokenPermissions(userName, appId, prm.userName, prm.appId)) {
            throw new SecurityException("Unauthorized to access " + userName + ", " + appId + " (" + hint + ")");
        }
    }

    private static boolean checkTokenPermissions(String userName, String appId, String tokenUser, String tokenAppId) {
        return userName.equals(tokenUser) && (StringUtils.isBlank(appId) || appId.equals(tokenAppId));
    }

    public static final class LlapTokenInfo {
        public final String userName;
        public final String appId;
        public final boolean isSigningRequired;

        public LlapTokenInfo(String userName, String appId, boolean isSigningRequired) {
            this.userName = userName;
            this.appId = appId;
            this.isSigningRequired = isSigningRequired;
        }
    }
}

