/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.cache;

import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.llap.cache.EvictionListener;
import org.apache.hadoop.hive.llap.cache.LlapCacheableBuffer;
import org.apache.hadoop.hive.llap.cache.LlapDataBuffer;
import org.apache.hadoop.hive.llap.cache.LlapOomDebugDump;
import org.apache.hadoop.hive.llap.cache.LowLevelCache;
import org.apache.hadoop.hive.llap.cache.LowLevelCachePolicy;
import org.apache.hadoop.hive.llap.io.api.impl.LlapIoImpl;
import org.apache.hive.org.apache.commons.lang.StringUtils;

public class LowLevelLrfuCachePolicy
implements LowLevelCachePolicy {
    private final double lambda;
    private static final double F0 = 1.0;
    private final AtomicLong timer = new AtomicLong(0L);
    private final LlapCacheableBuffer[] heap;
    private final ReentrantLock listLock = new ReentrantLock();
    private LlapCacheableBuffer listHead;
    private LlapCacheableBuffer listTail;
    private int heapSize = 0;
    private EvictionListener evictionListener;
    private LlapOomDebugDump parentDebugDump;

    private final double f(long x) {
        return Math.pow(0.5, this.lambda * (double)x);
    }

    private final double touchPriority(long time, long lastAccess, double previous) {
        return 1.0 + this.f(time - lastAccess) * previous;
    }

    private final double expirePriority(long time, long lastAccess, double previous) {
        return this.f(time - lastAccess) * previous;
    }

    public LowLevelLrfuCachePolicy(int minBufferSize, long maxSize, Configuration conf) {
        this.lambda = HiveConf.getFloatVar(conf, HiveConf.ConfVars.LLAP_LRFU_LAMBDA);
        int maxBuffers = (int)Math.ceil((double)maxSize * 1.0 / (double)minBufferSize);
        int maxHeapSize = -1;
        if (this.lambda == 0.0) {
            maxHeapSize = maxBuffers;
        } else {
            int lrfuThreshold = (int)(Math.log(1.0 - Math.pow(0.5, this.lambda)) / Math.log(0.5) / this.lambda);
            maxHeapSize = Math.min(lrfuThreshold, maxBuffers);
        }
        LlapIoImpl.LOG.info("LRFU cache policy with min buffer size {} and lambda {} (heap size {})", minBufferSize, this.lambda, maxHeapSize);
        this.heap = new LlapCacheableBuffer[maxHeapSize];
        this.listTail = null;
        this.listHead = null;
    }

    @Override
    public void cache(LlapCacheableBuffer buffer, LowLevelCache.Priority priority) {
        assert (buffer.lastUpdate == -1L);
        long time = this.timer.incrementAndGet();
        buffer.priority = 1.0;
        buffer.lastUpdate = time;
        if (priority == LowLevelCache.Priority.HIGH) {
            buffer.priority *= 3.0;
        } else assert (priority == LowLevelCache.Priority.NORMAL);
    }

    @Override
    public void notifyLock(LlapCacheableBuffer buffer) {
        if (buffer.indexInHeap != -2) {
            return;
        }
        if (!this.listLock.tryLock()) {
            return;
        }
        this.removeFromListAndUnlock(buffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyUnlock(LlapCacheableBuffer buffer) {
        long time = this.timer.incrementAndGet();
        if (LlapIoImpl.CACHE_LOGGER.isTraceEnabled()) {
            LlapIoImpl.CACHE_LOGGER.trace("Touching {} at {}", (Object)buffer, (Object)time);
        }
        LlapCacheableBuffer[] llapCacheableBufferArray = this.heap;
        synchronized (this.heap) {
            buffer.priority = buffer.lastUpdate == -1L ? 1.0 : this.touchPriority(time, buffer.lastUpdate, buffer.priority);
            buffer.lastUpdate = time;
            if (buffer.indexInHeap == -2) {
                this.listLock.lock();
                this.removeFromListAndUnlock(buffer);
            }
            if (buffer.indexInHeap >= 0) {
                this.heapifyDownUnderLock(buffer, time);
            } else if (this.heapSize == this.heap.length) {
                LlapCacheableBuffer demoted = this.heap[0];
                this.listLock.lock();
                try {
                    assert (demoted.indexInHeap == 0);
                    demoted.indexInHeap = -2;
                    demoted.prev = null;
                    if (this.listHead != null) {
                        demoted.next = this.listHead;
                        this.listHead.prev = demoted;
                        this.listHead = demoted;
                    } else {
                        this.listHead = this.listTail = demoted;
                        demoted.next = null;
                    }
                }
                finally {
                    this.listLock.unlock();
                }
                buffer.indexInHeap = 0;
                this.heapifyDownUnderLock(buffer, time);
            } else {
                assert (this.heapSize < this.heap.length) : this.heap.length + " < " + this.heapSize;
                buffer.indexInHeap = this.heapSize++;
                this.heapifyUpUnderLock(buffer, time);
            }
            // ** MonitorExit[var4_3] (shouldn't be in output)
            return;
        }
    }

    @Override
    public void setEvictionListener(EvictionListener listener) {
        this.evictionListener = listener;
    }

    @Override
    public void setParentDebugDumper(LlapOomDebugDump dumper) {
        this.parentDebugDump = dumper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public long evictSomeBlocks(long memoryToReserve) {
        long evicted = this.evictFromList(memoryToReserve);
        if (evicted >= memoryToReserve) {
            return evicted;
        }
        long time = this.timer.get();
        while (evicted < memoryToReserve) {
            LlapCacheableBuffer buffer = null;
            LlapCacheableBuffer[] llapCacheableBufferArray = this.heap;
            // MONITORENTER : this.heap
            buffer = this.evictFromHeapUnderLock(time);
            // MONITOREXIT : llapCacheableBufferArray
            if (buffer == null) {
                return evicted;
            }
            evicted += buffer.getMemoryUsage();
            this.evictionListener.notifyEvicted(buffer);
        }
        return evicted;
    }

    @Override
    public long tryEvictContiguousData(int allocationSize, int count) {
        int evicted = this.evictDataFromList(allocationSize, count);
        if (count <= evicted) {
            return evicted * allocationSize;
        }
        evicted += this.evictDataFromHeap(this.timer.get(), count - evicted, allocationSize);
        long evictedBytes = evicted * allocationSize;
        if (count <= evicted) {
            return evictedBytes;
        }
        return evictedBytes += this.evictSomeBlocks(allocationSize * (count - evicted));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long evictFromList(long memoryToReserve) {
        long evicted = 0L;
        LlapCacheableBuffer nextCandidate = null;
        LlapCacheableBuffer firstCandidate = null;
        this.listLock.lock();
        try {
            nextCandidate = firstCandidate = this.listTail;
            while (evicted < memoryToReserve && nextCandidate != null) {
                if (!nextCandidate.invalidate()) {
                    LlapCacheableBuffer lockedBuffer = nextCandidate;
                    if (firstCandidate == nextCandidate) {
                        firstCandidate = nextCandidate.prev;
                    }
                    nextCandidate = nextCandidate.prev;
                    this.removeFromListUnderLock(lockedBuffer);
                    continue;
                }
                nextCandidate.indexInHeap = -1;
                evicted += nextCandidate.getMemoryUsage();
                nextCandidate = nextCandidate.prev;
            }
            if (firstCandidate != nextCandidate) {
                if (nextCandidate == null) {
                    this.listTail = null;
                    this.listHead = null;
                } else {
                    this.removeFromListUnderLockNoStateUpdate(nextCandidate.next, firstCandidate);
                }
            }
        }
        finally {
            this.listLock.unlock();
        }
        while (firstCandidate != nextCandidate) {
            this.evictionListener.notifyEvicted(firstCandidate);
            firstCandidate = firstCandidate.prev;
        }
        return evicted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int evictDataFromList(int minSize, int count) {
        int evictedCount = 0;
        ArrayList<LlapCacheableBuffer> evictedBuffers = new ArrayList<LlapCacheableBuffer>(count);
        this.listLock.lock();
        try {
            LlapCacheableBuffer candidate = this.listTail;
            while (evictedCount < count && candidate != null) {
                LlapCacheableBuffer current = candidate;
                candidate = candidate.prev;
                long memUsage = current.getMemoryUsage();
                if (memUsage < (long)minSize || !(current instanceof LlapDataBuffer)) continue;
                if (!current.invalidate()) {
                    this.removeFromListUnderLock(current);
                    continue;
                }
                this.removeFromListUnderLock(current);
                assert (memUsage % (long)minSize == 0L);
                evictedCount = (int)((long)evictedCount + memUsage / (long)minSize);
                evictedBuffers.add(current);
            }
        }
        finally {
            this.listLock.unlock();
        }
        for (LlapCacheableBuffer buffer : evictedBuffers) {
            this.evictionListener.notifyEvicted(buffer);
        }
        return evictedCount;
    }

    private LlapCacheableBuffer evictFromHeapUnderLock(long time) {
        LlapCacheableBuffer result;
        do {
            if (this.heapSize != 0) continue;
            return null;
        } while ((result = this.evictHeapElementUnderLock(time, 0)) == null);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int evictDataFromHeap(long time, int count, int minSize) {
        LlapCacheableBuffer evicted = null;
        int evictedCount = 0;
        LlapCacheableBuffer[] llapCacheableBufferArray = this.heap;
        synchronized (this.heap) {
            int index = 0;
            while (index < this.heapSize && evictedCount < count) {
                LlapCacheableBuffer buffer = this.heap[index];
                long memUsage = buffer.getMemoryUsage();
                if (memUsage < (long)minSize || !(buffer instanceof LlapDataBuffer)) {
                    ++index;
                    continue;
                }
                LlapCacheableBuffer result = this.evictHeapElementUnderLock(time, index);
                if (result == null) continue;
                assert (memUsage % (long)minSize == 0L);
                evictedCount = (int)((long)evictedCount + memUsage / (long)minSize);
                if (evicted != null) {
                    this.evictionListener.notifyEvicted(evicted);
                }
                evicted = result;
            }
            // ** MonitorExit[var7_6] (shouldn't be in output)
            if (evicted != null) {
                this.evictionListener.notifyEvicted(evicted);
            }
            return evictedCount;
        }
    }

    private void heapifyUpUnderLock(LlapCacheableBuffer buffer, long time) {
        int parentIx;
        LlapCacheableBuffer parent;
        double parentPri;
        int ix = buffer.indexInHeap;
        double priority = buffer.priority;
        while (ix != 0 && !(priority >= (parentPri = this.getHeapifyPriority(parent = this.heap[parentIx = ix - 1 >>> 1], time)))) {
            this.heap[ix] = parent;
            parent.indexInHeap = ix;
            ix = parentIx;
        }
        buffer.indexInHeap = ix;
        this.heap[ix] = buffer;
    }

    private LlapCacheableBuffer evictHeapElementUnderLock(long time, int ix) {
        LlapCacheableBuffer result = this.heap[ix];
        if (LlapIoImpl.CACHE_LOGGER.isTraceEnabled()) {
            LlapIoImpl.CACHE_LOGGER.trace("Evicting {} at {}", (Object)result, (Object)time);
        }
        result.indexInHeap = -1;
        --this.heapSize;
        boolean canEvict = result.invalidate();
        if (this.heapSize > 0) {
            LlapCacheableBuffer newRoot = this.heap[this.heapSize];
            newRoot.indexInHeap = ix;
            if (newRoot.lastUpdate != time) {
                newRoot.priority = this.expirePriority(time, newRoot.lastUpdate, newRoot.priority);
                newRoot.lastUpdate = time;
            }
            this.heapifyDownUnderLock(newRoot, time);
        }
        return canEvict ? result : null;
    }

    private void heapifyDownUnderLock(LlapCacheableBuffer buffer, long time) {
        int newIx;
        int ix = buffer.indexInHeap;
        double priority = buffer.priority;
        while ((newIx = this.moveMinChildUp(ix, time, priority)) != -1) {
            ix = newIx;
        }
        buffer.indexInHeap = ix;
        this.heap[ix] = buffer;
    }

    private int moveMinChildUp(int targetPos, long time, double comparePri) {
        int leftIx = (targetPos << 1) + 1;
        int rightIx = leftIx + 1;
        if (leftIx >= this.heapSize) {
            return -1;
        }
        LlapCacheableBuffer left = this.heap[leftIx];
        LlapCacheableBuffer right = null;
        if (rightIx < this.heapSize) {
            right = this.heap[rightIx];
        }
        double leftPri = this.getHeapifyPriority(left, time);
        double rightPri = this.getHeapifyPriority(right, time);
        if (comparePri >= 0.0 && comparePri <= leftPri && comparePri <= rightPri) {
            return -1;
        }
        if (leftPri <= rightPri) {
            this.heap[targetPos] = left;
            left.indexInHeap = targetPos;
            return leftIx;
        }
        this.heap[targetPos] = right;
        right.indexInHeap = targetPos;
        return rightIx;
    }

    private double getHeapifyPriority(LlapCacheableBuffer buf, long time) {
        if (buf == null) {
            return Double.MAX_VALUE;
        }
        if (buf.lastUpdate != time && time >= 0L) {
            buf.priority = this.expirePriority(time, buf.lastUpdate, buf.priority);
            buf.lastUpdate = time;
        }
        return buf.priority;
    }

    private void removeFromListAndUnlock(LlapCacheableBuffer buffer) {
        try {
            if (buffer.indexInHeap != -2) {
                return;
            }
            this.removeFromListUnderLock(buffer);
        }
        finally {
            this.listLock.unlock();
        }
    }

    private void removeFromListUnderLock(LlapCacheableBuffer buffer) {
        buffer.indexInHeap = -1;
        boolean isTail = buffer == this.listTail;
        boolean isHead = buffer == this.listHead;
        if (isTail != (buffer.next == null) || isHead != (buffer.prev == null)) {
            this.debugDumpListOnError(buffer);
            throw new AssertionError((Object)"LRFU list is corrupted.");
        }
        if (isTail) {
            this.listTail = buffer.prev;
        } else {
            buffer.next.prev = buffer.prev;
        }
        if (isHead) {
            this.listHead = buffer.next;
        } else {
            buffer.prev.next = buffer.next;
        }
    }

    private void removeFromListUnderLockNoStateUpdate(LlapCacheableBuffer from, LlapCacheableBuffer to) {
        boolean isToTail = to == this.listTail;
        boolean isFromHead = from == this.listHead;
        if (isToTail != (to.next == null) || isFromHead != (from.prev == null)) {
            this.debugDumpListOnError(from, to);
            throw new AssertionError((Object)"LRFU list is corrupted.");
        }
        if (isToTail) {
            this.listTail = from.prev;
        } else {
            to.next.prev = from.prev;
        }
        if (isFromHead) {
            this.listHead = to.next;
        } else {
            from.prev.next = to.next;
        }
    }

    private void debugDumpListOnError(LlapCacheableBuffer ... buffers) {
        StringBuilder listDump = new StringBuilder("Invalid list removal. List: ");
        try {
            LowLevelLrfuCachePolicy.dumpList(listDump, this.listHead, this.listTail);
            int i = 0;
            for (LlapCacheableBuffer buffer : buffers) {
                listDump.append("; list from the buffer #").append(i).append(" being removed: ");
                LowLevelLrfuCachePolicy.dumpList(listDump, buffer, null);
            }
        }
        catch (Throwable t) {
            LlapIoImpl.LOG.error("Error dumping the lists on error", t);
        }
        LlapIoImpl.LOG.error(listDump.toString());
    }

    public String debugDumpHeap() {
        StringBuilder result = new StringBuilder("List: ");
        LowLevelLrfuCachePolicy.dumpList(result, this.listHead, this.listTail);
        result.append("\nHeap:");
        if (this.heapSize == 0) {
            result.append(" <empty>\n");
            return result.toString();
        }
        result.append("\n");
        int levels = 32 - Integer.numberOfLeadingZeros(this.heapSize);
        int ix = 0;
        int spacesCount = this.heap[0].toStringForCache().length() + 3;
        String full = StringUtils.repeat(" ", spacesCount);
        String half = StringUtils.repeat(" ", spacesCount / 2);
        int maxWidth = 1 << levels - 1;
        for (int i = 0; i < levels; ++i) {
            int j;
            int width = 1 << i;
            int middleGap = (maxWidth - width) / width;
            for (j = 0; j < middleGap >>> 1; ++j) {
                result.append(full);
            }
            if ((middleGap & 1) == 1) {
                result.append(half);
            }
            for (j = 0; j < width && ix < this.heapSize; ++j, ++ix) {
                if (j != 0) {
                    for (int k = 0; k < middleGap; ++k) {
                        result.append(full);
                    }
                    if (middleGap == 0) {
                        result.append(" ");
                    }
                }
                if ((j & 1) == 0) {
                    result.append("(");
                }
                result.append(this.heap[ix].toStringForCache());
                if ((j & 1) != 1) continue;
                result.append(")");
            }
            result.append("\n");
        }
        return result.toString();
    }

    private static void dumpList(StringBuilder result, LlapCacheableBuffer listHeadLocal, LlapCacheableBuffer listTailLocal) {
        if (listHeadLocal == null) {
            result.append("<empty>");
            return;
        }
        LlapCacheableBuffer listItem = listHeadLocal;
        while (listItem.prev != null) {
            listItem = listItem.prev;
        }
        while (listItem != null) {
            result.append(listItem.toStringForCache());
            if (listItem == listTailLocal) {
                result.append("(tail)");
            }
            if (listItem == listHeadLocal) {
                result.append("(head)");
            }
            result.append(" -> ");
            listItem = listItem.next;
        }
    }

    @Override
    public String debugDumpForOom() {
        String result = this.debugDumpHeap();
        if (this.parentDebugDump != null) {
            result = result + "\n" + this.parentDebugDump.debugDumpForOom();
        }
        return result;
    }
}

