/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.wal;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.regionserver.wal.WALActionsListener;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALFactory;
import org.apache.hadoop.hbase.wal.WALProvider;
import org.apache.hive.org.apache.commons.logging.Log;
import org.apache.hive.org.apache.commons.logging.LogFactory;

@InterfaceAudience.Private
class RegionGroupingProvider
implements WALProvider {
    private static final Log LOG = LogFactory.getLog(RegionGroupingProvider.class);
    private static final String REGION_GROUPING_STRATEGY = "hbase.wal.regiongrouping.strategy";
    private static final String DEFAULT_REGION_GROUPING_STRATEGY = Strategies.defaultStrategy.name();
    static final String DELEGATE_PROVIDER = "hbase.wal.regiongrouping.delegate";
    static final String DEFAULT_DELEGATE_PROVIDER = WALFactory.Providers.defaultProvider.name();
    protected final ConcurrentMap<byte[], WALProvider> cached = new ConcurrentHashMap<byte[], WALProvider>();
    protected RegionGroupingStrategy strategy = null;
    private WALFactory factory = null;
    private List<WALActionsListener> listeners = null;
    private String providerId = null;

    RegionGroupingProvider() {
    }

    RegionGroupingStrategy getStrategy(Configuration conf, String key, String defaultValue) throws IOException {
        Class clazz;
        try {
            clazz = Strategies.valueOf((String)conf.get((String)key, (String)defaultValue)).clazz;
        }
        catch (IllegalArgumentException exception) {
            clazz = conf.getClass(key, IdentityGroupingStrategy.class, RegionGroupingStrategy.class);
        }
        LOG.info("Instantiating RegionGroupingStrategy of type " + clazz);
        try {
            RegionGroupingStrategy result = (RegionGroupingStrategy)clazz.newInstance();
            result.init(conf);
            return result;
        }
        catch (InstantiationException exception) {
            LOG.error("couldn't set up region grouping strategy, check config key hbase.wal.regiongrouping.strategy");
            LOG.debug("Exception details for failure to load region grouping strategy.", exception);
            throw new IOException("couldn't set up region grouping strategy", exception);
        }
        catch (IllegalAccessException exception) {
            LOG.error("couldn't set up region grouping strategy, check config key hbase.wal.regiongrouping.strategy");
            LOG.debug("Exception details for failure to load region grouping strategy.", exception);
            throw new IOException("couldn't set up region grouping strategy", exception);
        }
    }

    @Override
    public void init(WALFactory factory, Configuration conf, List<WALActionsListener> listeners, String providerId) throws IOException {
        if (null != this.strategy) {
            throw new IllegalStateException("WALProvider.init should only be called once.");
        }
        this.factory = factory;
        this.listeners = null == listeners ? null : Collections.unmodifiableList(listeners);
        this.providerId = providerId;
        this.strategy = this.getStrategy(conf, REGION_GROUPING_STRATEGY, DEFAULT_REGION_GROUPING_STRATEGY);
    }

    WALProvider populateCache(byte[] group) throws IOException {
        WALProvider temp = this.factory.getProvider(DELEGATE_PROVIDER, DEFAULT_DELEGATE_PROVIDER, this.listeners, this.providerId + "-" + UUID.randomUUID());
        WALProvider extant = this.cached.putIfAbsent(group, temp);
        if (null != extant) {
            temp.close();
            return extant;
        }
        return temp;
    }

    @Override
    public WAL getWAL(byte[] identifier) throws IOException {
        byte[] group = this.strategy.group(identifier);
        WALProvider provider = (WALProvider)this.cached.get(group);
        if (null == provider) {
            provider = this.populateCache(group);
        }
        return provider.getWAL(identifier);
    }

    @Override
    public void shutdown() throws IOException {
        IOException failure = null;
        for (WALProvider provider : this.cached.values()) {
            try {
                provider.shutdown();
            }
            catch (IOException exception) {
                LOG.error("Problem shutting down provider '" + provider + "': " + exception.getMessage());
                LOG.debug("Details of problem shutting down provider '" + provider + "'", exception);
                failure = exception;
            }
        }
        if (failure != null) {
            throw failure;
        }
    }

    @Override
    public void close() throws IOException {
        IOException failure = null;
        for (WALProvider provider : this.cached.values()) {
            try {
                provider.close();
            }
            catch (IOException exception) {
                LOG.error("Problem closing provider '" + provider + "': " + exception.getMessage());
                LOG.debug("Details of problem shutting down provider '" + provider + "'", exception);
                failure = exception;
            }
        }
        if (failure != null) {
            throw failure;
        }
    }

    static class IdentityGroupingStrategy
    implements RegionGroupingStrategy {
        IdentityGroupingStrategy() {
        }

        @Override
        public void init(Configuration config) {
        }

        @Override
        public byte[] group(byte[] identifier) {
            return identifier;
        }
    }

    static enum Strategies {
        defaultStrategy(IdentityGroupingStrategy.class),
        identity(IdentityGroupingStrategy.class);

        final Class<? extends RegionGroupingStrategy> clazz;

        private Strategies(Class<? extends RegionGroupingStrategy> clazz) {
            this.clazz = clazz;
        }
    }

    public static interface RegionGroupingStrategy {
        public byte[] group(byte[] var1);

        public void init(Configuration var1);
    }
}

