/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.Closeable;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Array;
import java.util.Set;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.RuntimeErrorException;
import javax.management.RuntimeMBeanException;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.TabularData;
import org.apache.hive.org.apache.commons.logging.Log;
import org.apache.hive.org.apache.commons.logging.LogFactory;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonGenerator;

public class JSONBean {
    private static final Log LOG = LogFactory.getLog(JSONBean.class);
    private final JsonFactory jsonFactory = new JsonFactory();

    public Writer open(PrintWriter writer) throws IOException {
        final JsonGenerator jg = this.jsonFactory.createJsonGenerator((java.io.Writer)writer);
        jg.disable(JsonGenerator.Feature.AUTO_CLOSE_TARGET);
        jg.useDefaultPrettyPrinter();
        jg.writeStartObject();
        return new Writer(){

            @Override
            public void flush() throws IOException {
                jg.flush();
            }

            @Override
            public void close() throws IOException {
                jg.close();
            }

            @Override
            public void write(String key, String value) throws JsonGenerationException, IOException {
                jg.writeStringField(key, value);
            }

            @Override
            public int write(MBeanServer mBeanServer, ObjectName qry, String attribute, boolean description) throws IOException {
                return JSONBean.write(jg, mBeanServer, qry, attribute, description);
            }
        };
    }

    private static int write(JsonGenerator jg, MBeanServer mBeanServer, ObjectName qry, String attribute, boolean description) throws IOException {
        LOG.trace("Listing beans for " + qry);
        Set<ObjectName> names = null;
        names = mBeanServer.queryNames(qry, null);
        jg.writeArrayFieldStart("beans");
        for (ObjectName oname : names) {
            MBeanInfo minfo;
            Object attributeinfo;
            String descriptionStr;
            String code;
            block21: {
                code = "";
                descriptionStr = null;
                attributeinfo = null;
                try {
                    minfo = mBeanServer.getMBeanInfo(oname);
                    code = minfo.getClassName();
                    if (description) {
                        descriptionStr = minfo.getDescription();
                    }
                    String prs = "";
                    try {
                        if ("org.apache.hive.org.apache.commons.modeler.BaseModelMBean".equals(code)) {
                            prs = "modelerType";
                            code = (String)mBeanServer.getAttribute(oname, prs);
                        }
                        if (attribute == null) break block21;
                        prs = attribute;
                        attributeinfo = mBeanServer.getAttribute(oname, prs);
                    }
                    catch (RuntimeMBeanException e) {
                        if (e.getCause() instanceof UnsupportedOperationException) {
                            if (LOG.isTraceEnabled()) {
                                LOG.trace("Getting attribute " + prs + " of " + oname + " threw " + e);
                            }
                        } else {
                            LOG.error("Getting attribute " + prs + " of " + oname + " threw an exception", e);
                        }
                        return 0;
                    }
                    catch (AttributeNotFoundException e) {
                        LOG.error("getting attribute " + prs + " of " + oname + " threw an exception", e);
                    }
                    catch (MBeanException e) {
                        LOG.error("getting attribute " + prs + " of " + oname + " threw an exception", e);
                    }
                    catch (RuntimeException e) {
                        LOG.error("getting attribute " + prs + " of " + oname + " threw an exception", e);
                    }
                    catch (ReflectionException e) {
                        LOG.error("getting attribute " + prs + " of " + oname + " threw an exception", e);
                    }
                }
                catch (InstanceNotFoundException e) {
                    continue;
                }
                catch (IntrospectionException e) {
                    LOG.error("Problem while trying to process JMX query: " + qry + " with MBean " + oname, e);
                    continue;
                }
                catch (ReflectionException e) {
                    LOG.error("Problem while trying to process JMX query: " + qry + " with MBean " + oname, e);
                    continue;
                }
            }
            jg.writeStartObject();
            jg.writeStringField("name", oname.toString());
            if (description && descriptionStr != null && descriptionStr.length() > 0) {
                jg.writeStringField("description", descriptionStr);
            }
            jg.writeStringField("modelerType", code);
            if (attribute != null && attributeinfo == null) {
                jg.writeStringField("result", "ERROR");
                jg.writeStringField("message", "No attribute with name " + attribute + " was found.");
                jg.writeEndObject();
                jg.writeEndArray();
                jg.close();
                return -1;
            }
            if (attribute != null) {
                JSONBean.writeAttribute(jg, attribute, descriptionStr, attributeinfo);
            } else {
                MBeanAttributeInfo[] attrs = minfo.getAttributes();
                for (int i = 0; i < attrs.length; ++i) {
                    JSONBean.writeAttribute(jg, mBeanServer, oname, description, attrs[i]);
                }
            }
            jg.writeEndObject();
        }
        jg.writeEndArray();
        return 0;
    }

    private static void writeAttribute(JsonGenerator jg, MBeanServer mBeanServer, ObjectName oname, boolean description, MBeanAttributeInfo attr) throws IOException {
        if (!attr.isReadable()) {
            return;
        }
        String attName = attr.getName();
        if ("modelerType".equals(attName)) {
            return;
        }
        if (attName.indexOf("=") >= 0 || attName.indexOf(":") >= 0 || attName.indexOf(" ") >= 0) {
            return;
        }
        String descriptionStr = description ? attr.getDescription() : null;
        Object value = null;
        try {
            value = mBeanServer.getAttribute(oname, attName);
        }
        catch (RuntimeMBeanException e) {
            if (e.getCause() instanceof UnsupportedOperationException) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Getting attribute " + attName + " of " + oname + " threw " + e);
                }
            } else {
                LOG.error("getting attribute " + attName + " of " + oname + " threw an exception", e);
            }
            return;
        }
        catch (RuntimeErrorException e) {
            LOG.debug("getting attribute " + attName + " of " + oname + " threw an exception", e);
            return;
        }
        catch (AttributeNotFoundException e) {
            return;
        }
        catch (MBeanException e) {
            LOG.error("getting attribute " + attName + " of " + oname + " threw an exception", e);
            return;
        }
        catch (RuntimeException e) {
            LOG.error("getting attribute " + attName + " of " + oname + " threw an exception", e);
            return;
        }
        catch (ReflectionException e) {
            LOG.error("getting attribute " + attName + " of " + oname + " threw an exception", e);
            return;
        }
        catch (InstanceNotFoundException e) {
            return;
        }
        JSONBean.writeAttribute(jg, attName, descriptionStr, value);
    }

    private static void writeAttribute(JsonGenerator jg, String attName, String descriptionStr, Object value) throws IOException {
        boolean description = false;
        if (descriptionStr != null && descriptionStr.length() > 0 && !attName.equals(descriptionStr)) {
            description = true;
            jg.writeFieldName(attName);
            jg.writeStartObject();
            jg.writeFieldName("description");
            jg.writeString(descriptionStr);
            jg.writeFieldName("value");
            JSONBean.writeObject(jg, description, value);
            jg.writeEndObject();
        } else {
            jg.writeFieldName(attName);
            JSONBean.writeObject(jg, description, value);
        }
    }

    private static void writeObject(JsonGenerator jg, boolean description, Object value) throws IOException {
        if (value == null) {
            jg.writeNull();
        } else {
            Class<?> c = value.getClass();
            if (c.isArray()) {
                jg.writeStartArray();
                int len = Array.getLength(value);
                for (int j = 0; j < len; ++j) {
                    Object item = Array.get(value, j);
                    JSONBean.writeObject(jg, description, item);
                }
                jg.writeEndArray();
            } else if (value instanceof Number) {
                Number n = (Number)value;
                jg.writeNumber(n.toString());
            } else if (value instanceof Boolean) {
                Boolean b = (Boolean)value;
                jg.writeBoolean(b.booleanValue());
            } else if (value instanceof CompositeData) {
                CompositeData cds = (CompositeData)value;
                CompositeType comp = cds.getCompositeType();
                Set<String> keys = comp.keySet();
                jg.writeStartObject();
                for (String key : keys) {
                    JSONBean.writeAttribute(jg, key, null, cds.get(key));
                }
                jg.writeEndObject();
            } else if (value instanceof TabularData) {
                TabularData tds = (TabularData)value;
                jg.writeStartArray();
                for (Object entry : tds.values()) {
                    JSONBean.writeObject(jg, description, entry);
                }
                jg.writeEndArray();
            } else {
                jg.writeString(value.toString());
            }
        }
    }

    public static String dumpRegionServerMetrics() throws MalformedObjectNameException, IOException {
        StringWriter sw = new StringWriter(102400);
        try (PrintWriter writer = new PrintWriter(sw);){
            JSONBean dumper = new JSONBean();
            try (Writer jsonBeanWriter = dumper.open(writer);){
                MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
                jsonBeanWriter.write(mbeanServer, new ObjectName("java.lang:type=Memory"), null, false);
                jsonBeanWriter.write(mbeanServer, new ObjectName("Hadoop:service=HBase,name=RegionServer,sub=IPC"), null, false);
                jsonBeanWriter.write(mbeanServer, new ObjectName("Hadoop:service=HBase,name=RegionServer,sub=Replication"), null, false);
                jsonBeanWriter.write(mbeanServer, new ObjectName("Hadoop:service=HBase,name=RegionServer,sub=Server"), null, false);
            }
        }
        sw.close();
        return sw.toString();
    }

    public static void dumpAllBeans() throws IOException, MalformedObjectNameException {
        try (PrintWriter writer = new PrintWriter(System.out);){
            JSONBean dumper = new JSONBean();
            try (Writer jsonBeanWriter = dumper.open(writer);){
                MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
                jsonBeanWriter.write(mbeanServer, new ObjectName("*:*"), null, false);
            }
        }
    }

    public static void main(String[] args) throws IOException, MalformedObjectNameException {
        String str = JSONBean.dumpRegionServerMetrics();
        System.out.println(str);
    }

    public static interface Writer
    extends Closeable {
        public void write(String var1, String var2) throws JsonGenerationException, IOException;

        public int write(MBeanServer var1, ObjectName var2, String var3, boolean var4) throws IOException;

        public void flush() throws IOException;
    }
}

