/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.access;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.security.access.AccessControlLists;
import org.apache.hadoop.hbase.security.access.TableAuthManager;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperListener;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.hive.org.apache.commons.logging.Log;
import org.apache.hive.org.apache.commons.logging.LogFactory;
import org.apache.hive.org.apache.zookeeper.KeeperException;

@InterfaceAudience.Private
public class ZKPermissionWatcher
extends ZooKeeperListener {
    private static Log LOG = LogFactory.getLog(ZKPermissionWatcher.class);
    static final String ACL_NODE = "acl";
    TableAuthManager authManager;
    String aclZNode;
    CountDownLatch initialized = new CountDownLatch(1);

    public ZKPermissionWatcher(ZooKeeperWatcher watcher, TableAuthManager authManager, Configuration conf) {
        super(watcher);
        this.authManager = authManager;
        String aclZnodeParent = conf.get("zookeeper.znode.acl.parent", ACL_NODE);
        this.aclZNode = ZKUtil.joinZNode(watcher.baseZNode, aclZnodeParent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws KeeperException {
        try {
            List<ZKUtil.NodeAndData> existing;
            this.watcher.registerListener(this);
            if (ZKUtil.watchAndCheckExists(this.watcher, this.aclZNode) && (existing = ZKUtil.getChildDataAndWatchForNewChildren(this.watcher, this.aclZNode)) != null) {
                this.refreshNodes(existing);
            }
        }
        finally {
            this.initialized.countDown();
        }
    }

    private void waitUntilStarted() {
        try {
            this.initialized.await();
        }
        catch (InterruptedException e) {
            LOG.warn("Interrupted while waiting", e);
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public void nodeCreated(String path) {
        this.waitUntilStarted();
        if (path.equals(this.aclZNode)) {
            try {
                List<ZKUtil.NodeAndData> nodes = ZKUtil.getChildDataAndWatchForNewChildren(this.watcher, this.aclZNode);
                this.refreshNodes(nodes);
            }
            catch (KeeperException ke) {
                LOG.error("Error reading data from zookeeper", ke);
                this.watcher.abort("Zookeeper error obtaining acl node children", ke);
            }
        }
    }

    @Override
    public void nodeDeleted(String path) {
        this.waitUntilStarted();
        if (this.aclZNode.equals(ZKUtil.getParent(path))) {
            String table = ZKUtil.getNodeName(path);
            if (AccessControlLists.isNamespaceEntry(table)) {
                this.authManager.removeNamespace(Bytes.toBytes(table));
            } else {
                this.authManager.removeTable(TableName.valueOf(table));
            }
        }
    }

    @Override
    public void nodeDataChanged(String path) {
        this.waitUntilStarted();
        if (this.aclZNode.equals(ZKUtil.getParent(path))) {
            String entry = ZKUtil.getNodeName(path);
            try {
                byte[] data = ZKUtil.getDataAndWatch(this.watcher, path);
                this.refreshAuthManager(entry, data);
            }
            catch (KeeperException ke) {
                LOG.error("Error reading data from zookeeper for node " + entry, ke);
                this.watcher.abort("Zookeeper error getting data for node " + entry, ke);
            }
            catch (IOException ioe) {
                LOG.error("Error reading permissions writables", ioe);
            }
        }
    }

    @Override
    public void nodeChildrenChanged(String path) {
        this.waitUntilStarted();
        if (path.equals(this.aclZNode)) {
            try {
                List<ZKUtil.NodeAndData> nodes = ZKUtil.getChildDataAndWatchForNewChildren(this.watcher, this.aclZNode);
                this.refreshNodes(nodes);
            }
            catch (KeeperException ke) {
                LOG.error("Error reading data from zookeeper for path " + path, ke);
                this.watcher.abort("Zookeeper error get node children for path " + path, ke);
            }
        }
    }

    private void refreshNodes(List<ZKUtil.NodeAndData> nodes) {
        for (ZKUtil.NodeAndData n : nodes) {
            if (n.isEmpty()) continue;
            String path = n.getNode();
            String entry = ZKUtil.getNodeName(path);
            try {
                this.refreshAuthManager(entry, n.getData());
            }
            catch (IOException ioe) {
                LOG.error("Failed parsing permissions for table '" + entry + "' from zk", ioe);
            }
        }
    }

    private void refreshAuthManager(String entry, byte[] nodeData) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Updating permissions cache from node " + entry + " with data: " + Bytes.toStringBinary(nodeData));
        }
        if (AccessControlLists.isNamespaceEntry(entry)) {
            this.authManager.refreshNamespaceCacheFromWritable(AccessControlLists.fromNamespaceEntry(entry), nodeData);
        } else {
            this.authManager.refreshTableCacheFromWritable(TableName.valueOf(entry), nodeData);
        }
    }

    public void writeToZookeeper(byte[] entry, byte[] permsData) {
        String entryName = Bytes.toString(entry);
        String zkNode = ZKUtil.joinZNode(this.watcher.baseZNode, ACL_NODE);
        zkNode = ZKUtil.joinZNode(zkNode, entryName);
        try {
            ZKUtil.createWithParents(this.watcher, zkNode);
            ZKUtil.updateExistingNodeData(this.watcher, zkNode, permsData, -1);
        }
        catch (KeeperException e) {
            LOG.error("Failed updating permissions for entry '" + entryName + "'", e);
            this.watcher.abort("Failed writing node " + zkNode + " to zookeeper", e);
        }
    }

    public void deleteTableACLNode(TableName tableName) {
        String zkNode = ZKUtil.joinZNode(this.watcher.baseZNode, ACL_NODE);
        zkNode = ZKUtil.joinZNode(zkNode, tableName.getNameAsString());
        try {
            ZKUtil.deleteNode(this.watcher, zkNode);
        }
        catch (KeeperException.NoNodeException e) {
            LOG.warn("No acl notify node of table '" + tableName + "'");
        }
        catch (KeeperException e) {
            LOG.error("Failed deleting acl node of table '" + tableName + "'", e);
            this.watcher.abort("Failed deleting node " + zkNode, e);
        }
    }

    public void deleteNamespaceACLNode(String namespace) {
        String zkNode = ZKUtil.joinZNode(this.watcher.baseZNode, ACL_NODE);
        zkNode = ZKUtil.joinZNode(zkNode, '@' + namespace);
        try {
            ZKUtil.deleteNode(this.watcher, zkNode);
        }
        catch (KeeperException.NoNodeException e) {
            LOG.warn("No acl notify node of namespace '" + namespace + "'");
        }
        catch (KeeperException e) {
            LOG.error("Failed deleting acl node of namespace '" + namespace + "'", e);
            this.watcher.abort("Failed deleting node " + zkNode, e);
        }
    }
}

