/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.access;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.AuthUtil;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.UserProvider;
import org.apache.hadoop.hbase.security.access.AccessControlLists;
import org.apache.hadoop.hbase.security.access.Permission;
import org.apache.hadoop.hbase.security.access.TablePermission;
import org.apache.hadoop.hbase.security.access.ZKPermissionWatcher;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.hive.com.google.common.collect.ArrayListMultimap;
import org.apache.hive.com.google.common.collect.ListMultimap;
import org.apache.hive.com.google.common.collect.Lists;
import org.apache.hive.org.apache.commons.logging.Log;
import org.apache.hive.org.apache.commons.logging.LogFactory;
import org.apache.hive.org.apache.zookeeper.KeeperException;

@InterfaceAudience.Private
public class TableAuthManager {
    private static Log LOG = LogFactory.getLog(TableAuthManager.class);
    private static TableAuthManager instance;
    private volatile PermissionCache<Permission> globalCache;
    private ConcurrentSkipListMap<TableName, PermissionCache<TablePermission>> tableCache = new ConcurrentSkipListMap();
    private ConcurrentSkipListMap<String, PermissionCache<TablePermission>> nsCache = new ConcurrentSkipListMap();
    private Configuration conf;
    private ZKPermissionWatcher zkperms;
    private volatile long mtime;
    static Map<ZooKeeperWatcher, TableAuthManager> managerMap;

    private TableAuthManager(ZooKeeperWatcher watcher, Configuration conf) throws IOException {
        this.conf = conf;
        this.globalCache = this.initGlobal(conf);
        this.zkperms = new ZKPermissionWatcher(watcher, this, conf);
        try {
            this.zkperms.start();
        }
        catch (KeeperException ke) {
            LOG.error("ZooKeeper initialization failed", ke);
        }
    }

    private PermissionCache<Permission> initGlobal(Configuration conf) throws IOException {
        UserProvider userProvider = UserProvider.instantiate(conf);
        User user = userProvider.getCurrent();
        if (user == null) {
            throw new IOException("Unable to obtain the current user, authorization checks for internal operations will not work correctly!");
        }
        PermissionCache<Permission> newCache = new PermissionCache<Permission>();
        String currentUser = user.getShortName();
        List<String> superusers = Lists.asList(currentUser, conf.getStrings("hbase.superuser", new String[0]));
        if (superusers != null) {
            for (String name : superusers) {
                if (AuthUtil.isGroupPrincipal(name)) {
                    newCache.putGroup(AuthUtil.getGroupName(name), new Permission(Permission.Action.values()));
                    continue;
                }
                newCache.putUser(name, new Permission(Permission.Action.values()));
            }
        }
        return newCache;
    }

    public ZKPermissionWatcher getZKPermissionWatcher() {
        return this.zkperms;
    }

    public void refreshTableCacheFromWritable(TableName table, byte[] data) throws IOException {
        if (data != null && data.length > 0) {
            ListMultimap<String, TablePermission> perms;
            try {
                perms = AccessControlLists.readPermissions(data, this.conf);
            }
            catch (DeserializationException e) {
                throw new IOException(e);
            }
            if (perms != null) {
                if (Bytes.equals(table.getName(), AccessControlLists.ACL_GLOBAL_NAME)) {
                    this.updateGlobalCache(perms);
                } else {
                    this.updateTableCache(table, perms);
                }
            }
        } else {
            LOG.debug("Skipping permission cache refresh because writable data is empty");
        }
    }

    public void refreshNamespaceCacheFromWritable(String namespace, byte[] data) throws IOException {
        if (data != null && data.length > 0) {
            ListMultimap<String, TablePermission> perms;
            try {
                perms = AccessControlLists.readPermissions(data, this.conf);
            }
            catch (DeserializationException e) {
                throw new IOException(e);
            }
            if (perms != null) {
                this.updateNsCache(namespace, perms);
            }
        } else {
            LOG.debug("Skipping permission cache refresh because writable data is empty");
        }
    }

    private void updateGlobalCache(ListMultimap<String, TablePermission> userPerms) {
        PermissionCache<Permission> newCache = null;
        try {
            newCache = this.initGlobal(this.conf);
            for (Map.Entry entry : userPerms.entries()) {
                if (AuthUtil.isGroupPrincipal((String)entry.getKey())) {
                    newCache.putGroup(AuthUtil.getGroupName((String)entry.getKey()), new Permission(((TablePermission)((Object)entry.getValue())).getActions()));
                    continue;
                }
                newCache.putUser((String)entry.getKey(), new Permission(((TablePermission)((Object)entry.getValue())).getActions()));
            }
            this.globalCache = newCache;
            ++this.mtime;
        }
        catch (IOException e) {
            LOG.error("Error occured while updating the global cache", e);
        }
    }

    private void updateTableCache(TableName table, ListMultimap<String, TablePermission> tablePerms) {
        PermissionCache<Permission> newTablePerms = new PermissionCache<Permission>();
        for (Map.Entry entry : tablePerms.entries()) {
            if (AuthUtil.isGroupPrincipal((String)entry.getKey())) {
                newTablePerms.putGroup(AuthUtil.getGroupName((String)entry.getKey()), (Permission)((Object)entry.getValue()));
                continue;
            }
            newTablePerms.putUser((String)entry.getKey(), (Permission)((Object)entry.getValue()));
        }
        this.tableCache.put(table, newTablePerms);
        ++this.mtime;
    }

    private void updateNsCache(String namespace, ListMultimap<String, TablePermission> tablePerms) {
        PermissionCache<Permission> newTablePerms = new PermissionCache<Permission>();
        for (Map.Entry entry : tablePerms.entries()) {
            if (AuthUtil.isGroupPrincipal((String)entry.getKey())) {
                newTablePerms.putGroup(AuthUtil.getGroupName((String)entry.getKey()), (Permission)((Object)entry.getValue()));
                continue;
            }
            newTablePerms.putUser((String)entry.getKey(), (Permission)((Object)entry.getValue()));
        }
        this.nsCache.put(namespace, newTablePerms);
        ++this.mtime;
    }

    private PermissionCache<TablePermission> getTablePermissions(TableName table) {
        if (!this.tableCache.containsKey(table)) {
            this.tableCache.putIfAbsent(table, new PermissionCache());
        }
        return this.tableCache.get(table);
    }

    private PermissionCache<TablePermission> getNamespacePermissions(String namespace) {
        if (!this.nsCache.containsKey(namespace)) {
            this.nsCache.putIfAbsent(namespace, new PermissionCache());
        }
        return this.nsCache.get(namespace);
    }

    private boolean authorize(List<Permission> perms, Permission.Action action) {
        if (perms != null) {
            for (Permission p : perms) {
                if (!p.implies(action)) continue;
                return true;
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("No permissions found for " + (Object)((Object)action));
        }
        return false;
    }

    public boolean authorize(User user, Permission.Action action) {
        if (user == null) {
            return false;
        }
        if (this.authorize(this.globalCache.getUser(user.getShortName()), action)) {
            return true;
        }
        String[] groups = user.getGroupNames();
        if (groups != null) {
            for (String group : groups) {
                if (!this.authorize(this.globalCache.getGroup(group), action)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean authorize(List<TablePermission> perms, TableName table, byte[] family, Permission.Action action) {
        return this.authorize(perms, table, family, null, action);
    }

    private boolean authorize(List<TablePermission> perms, TableName table, byte[] family, byte[] qualifier, Permission.Action action) {
        if (perms != null) {
            for (TablePermission p : perms) {
                if (!p.implies(table, family, qualifier, action)) continue;
                return true;
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("No permissions found for table=" + table);
        }
        return false;
    }

    private boolean hasAccess(List<TablePermission> perms, TableName table, Permission.Action action) {
        if (perms != null) {
            for (TablePermission p : perms) {
                if (!p.implies(action)) continue;
                return true;
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("No permissions found for table=" + table);
        }
        return false;
    }

    public boolean authorize(User user, TableName table, Cell cell, Permission.Action action) {
        try {
            List<Permission> perms = AccessControlLists.getCellPermissionsForUser(user, cell);
            if (LOG.isTraceEnabled()) {
                LOG.trace("Perms for user " + user.getShortName() + " in cell " + cell + ": " + (perms != null ? perms : ""));
            }
            if (perms != null) {
                for (Permission p : perms) {
                    if (!p.implies(action)) continue;
                    return true;
                }
            }
        }
        catch (IOException e) {
            LOG.error("Failed parse of ACL tag in cell " + cell);
        }
        return false;
    }

    public boolean authorize(User user, String namespace, Permission.Action action) {
        if (this.authorize(user, action)) {
            return true;
        }
        PermissionCache<TablePermission> tablePerms = this.nsCache.get(namespace);
        if (tablePerms != null) {
            List<TablePermission> userPerms = tablePerms.getUser(user.getShortName());
            if (this.authorize(userPerms, namespace, action)) {
                return true;
            }
            String[] groupNames = user.getGroupNames();
            if (groupNames != null) {
                for (String group : groupNames) {
                    List<TablePermission> groupPerms = tablePerms.getGroup(group);
                    if (!this.authorize(groupPerms, namespace, action)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean authorize(List<TablePermission> perms, String namespace, Permission.Action action) {
        if (perms != null) {
            for (TablePermission p : perms) {
                if (!p.implies(namespace, action)) continue;
                return true;
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("No permissions for authorize() check, table=" + namespace);
        }
        return false;
    }

    public boolean authorizeUser(User user, TableName table, byte[] family, Permission.Action action) {
        return this.authorizeUser(user, table, family, null, action);
    }

    public boolean authorizeUser(User user, TableName table, byte[] family, byte[] qualifier, Permission.Action action) {
        if (table == null) {
            table = AccessControlLists.ACL_TABLE_NAME;
        }
        if (this.authorize(user, table.getNamespaceAsString(), action)) {
            return true;
        }
        return this.authorize(this.getTablePermissions(table).getUser(user.getShortName()), table, family, qualifier, action);
    }

    public boolean userHasAccess(User user, TableName table, Permission.Action action) {
        if (table == null) {
            table = AccessControlLists.ACL_TABLE_NAME;
        }
        if (this.authorize(user, table.getNamespaceAsString(), action)) {
            return true;
        }
        return this.hasAccess(this.getTablePermissions(table).getUser(user.getShortName()), table, action);
    }

    public boolean authorizeGroup(String groupName, Permission.Action action) {
        List<Permission> perms = this.globalCache.getGroup(groupName);
        if (LOG.isDebugEnabled()) {
            LOG.debug("authorizing " + (perms != null && !perms.isEmpty() ? perms.get(0) : "") + " for " + (Object)((Object)action));
        }
        return this.authorize(perms, action);
    }

    public boolean authorizeGroup(String groupName, TableName table, byte[] family, byte[] qualifier, Permission.Action action) {
        String namespace;
        if (this.authorizeGroup(groupName, action)) {
            return true;
        }
        if (table == null) {
            table = AccessControlLists.ACL_TABLE_NAME;
        }
        if (this.authorize(this.getNamespacePermissions(namespace = table.getNamespaceAsString()).getGroup(groupName), namespace, action)) {
            return true;
        }
        List<TablePermission> tblPerms = this.getTablePermissions(table).getGroup(groupName);
        if (LOG.isDebugEnabled()) {
            LOG.debug("authorizing " + (tblPerms != null && !tblPerms.isEmpty() ? tblPerms.get(0) : "") + " for " + groupName + " on " + table + "." + Bytes.toString(family) + "." + Bytes.toString(qualifier) + " with " + (Object)((Object)action));
        }
        return this.authorize(tblPerms, table, family, qualifier, action);
    }

    public boolean groupHasAccess(String groupName, TableName table, Permission.Action action) {
        if (this.authorizeGroup(groupName, action)) {
            return true;
        }
        if (table == null) {
            table = AccessControlLists.ACL_TABLE_NAME;
        }
        if (this.hasAccess(this.getNamespacePermissions(table.getNamespaceAsString()).getGroup(groupName), table, action)) {
            return true;
        }
        return this.hasAccess(this.getTablePermissions(table).getGroup(groupName), table, action);
    }

    public boolean authorize(User user, TableName table, byte[] family, byte[] qualifier, Permission.Action action) {
        if (this.authorizeUser(user, table, family, qualifier, action)) {
            return true;
        }
        String[] groups = user.getGroupNames();
        if (groups != null) {
            for (String group : groups) {
                if (!this.authorizeGroup(group, table, family, qualifier, action)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasAccess(User user, TableName table, Permission.Action action) {
        if (this.userHasAccess(user, table, action)) {
            return true;
        }
        String[] groups = user.getGroupNames();
        if (groups != null) {
            for (String group : groups) {
                if (!this.groupHasAccess(group, table, action)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean authorize(User user, TableName table, byte[] family, Permission.Action action) {
        return this.authorize(user, table, family, null, action);
    }

    public boolean matchPermission(User user, TableName table, byte[] family, Permission.Action action) {
        PermissionCache<TablePermission> tablePerms = this.tableCache.get(table);
        if (tablePerms != null) {
            String[] groups;
            List<TablePermission> userPerms = tablePerms.getUser(user.getShortName());
            if (userPerms != null) {
                for (TablePermission p : userPerms) {
                    if (!p.matchesFamily(table, family, action)) continue;
                    return true;
                }
            }
            if ((groups = user.getGroupNames()) != null) {
                for (String group : groups) {
                    List<TablePermission> groupPerms = tablePerms.getGroup(group);
                    if (groupPerms == null) continue;
                    for (TablePermission p : groupPerms) {
                        if (!p.matchesFamily(table, family, action)) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public boolean matchPermission(User user, TableName table, byte[] family, byte[] qualifier, Permission.Action action) {
        PermissionCache<TablePermission> tablePerms = this.tableCache.get(table);
        if (tablePerms != null) {
            String[] groups;
            List<TablePermission> userPerms = tablePerms.getUser(user.getShortName());
            if (userPerms != null) {
                for (TablePermission p : userPerms) {
                    if (!p.matchesFamilyQualifier(table, family, qualifier, action)) continue;
                    return true;
                }
            }
            if ((groups = user.getGroupNames()) != null) {
                for (String group : groups) {
                    List<TablePermission> groupPerms = tablePerms.getGroup(group);
                    if (groupPerms == null) continue;
                    for (TablePermission p : groupPerms) {
                        if (!p.matchesFamilyQualifier(table, family, qualifier, action)) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public void removeNamespace(byte[] ns) {
        this.nsCache.remove(Bytes.toString(ns));
    }

    public void removeTable(TableName table) {
        this.tableCache.remove(table);
    }

    public void setTableUserPermissions(String username, TableName table, List<TablePermission> perms) {
        PermissionCache<TablePermission> tablePerms = this.getTablePermissions(table);
        tablePerms.replaceUser(username, perms);
        this.writeTableToZooKeeper(table, tablePerms);
    }

    public void setTableGroupPermissions(String group, TableName table, List<TablePermission> perms) {
        PermissionCache<TablePermission> tablePerms = this.getTablePermissions(table);
        tablePerms.replaceGroup(group, perms);
        this.writeTableToZooKeeper(table, tablePerms);
    }

    public void setNamespaceUserPermissions(String username, String namespace, List<TablePermission> perms) {
        PermissionCache<TablePermission> tablePerms = this.getNamespacePermissions(namespace);
        tablePerms.replaceUser(username, perms);
        this.writeNamespaceToZooKeeper(namespace, tablePerms);
    }

    public void setNamespaceGroupPermissions(String group, String namespace, List<TablePermission> perms) {
        PermissionCache<TablePermission> tablePerms = this.getNamespacePermissions(namespace);
        tablePerms.replaceGroup(group, perms);
        this.writeNamespaceToZooKeeper(namespace, tablePerms);
    }

    public void writeTableToZooKeeper(TableName table, PermissionCache<TablePermission> tablePerms) {
        byte[] serialized = new byte[]{};
        if (tablePerms != null) {
            serialized = AccessControlLists.writePermissionsAsBytes(tablePerms.getAllPermissions(), this.conf);
        }
        this.zkperms.writeToZookeeper(table.getName(), serialized);
    }

    public void writeNamespaceToZooKeeper(String namespace, PermissionCache<TablePermission> tablePerms) {
        byte[] serialized = new byte[]{};
        if (tablePerms != null) {
            serialized = AccessControlLists.writePermissionsAsBytes(tablePerms.getAllPermissions(), this.conf);
        }
        this.zkperms.writeToZookeeper(Bytes.toBytes(AccessControlLists.toNamespaceEntry(namespace)), serialized);
    }

    public long getMTime() {
        return this.mtime;
    }

    public static synchronized TableAuthManager get(ZooKeeperWatcher watcher, Configuration conf) throws IOException {
        instance = managerMap.get(watcher);
        if (instance == null) {
            instance = new TableAuthManager(watcher, conf);
            managerMap.put(watcher, instance);
        }
        return instance;
    }

    static {
        managerMap = new HashMap<ZooKeeperWatcher, TableAuthManager>();
    }

    private static class PermissionCache<T extends Permission> {
        private ListMultimap<String, T> userCache = ArrayListMultimap.create();
        private ListMultimap<String, T> groupCache = ArrayListMultimap.create();

        private PermissionCache() {
        }

        public List<T> getUser(String user) {
            return this.userCache.get(user);
        }

        public void putUser(String user, T perm) {
            this.userCache.put(user, perm);
        }

        public List<T> replaceUser(String user, Iterable<? extends T> perms) {
            return this.userCache.replaceValues(user, perms);
        }

        public List<T> getGroup(String group) {
            return this.groupCache.get(group);
        }

        public void putGroup(String group, T perm) {
            this.groupCache.put(group, perm);
        }

        public List<T> replaceGroup(String group, Iterable<? extends T> perms) {
            return this.groupCache.replaceValues(group, perms);
        }

        public ListMultimap<String, T> getAllPermissions() {
            ArrayListMultimap<String, T> tmp = ArrayListMultimap.create();
            tmp.putAll(this.userCache);
            for (String group : this.groupCache.keySet()) {
                tmp.putAll(AuthUtil.toGroupEntry(group), this.groupCache.get(group));
            }
            return tmp;
        }
    }
}

