/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.regionserver.wal.FSWALEntry;
import org.apache.hadoop.hbase.regionserver.wal.SyncFuture;
import org.apache.hive.com.lmax.disruptor.EventFactory;
import org.apache.htrace.Span;

@InterfaceAudience.Private
class RingBufferTruck {
    private SyncFuture syncFuture;
    private FSWALEntry entry;
    private Span span;
    static final EventFactory<RingBufferTruck> EVENT_FACTORY = new EventFactory<RingBufferTruck>(){

        @Override
        public RingBufferTruck newInstance() {
            return new RingBufferTruck();
        }
    };

    RingBufferTruck() {
    }

    void loadPayload(FSWALEntry entry, Span span) {
        this.entry = entry;
        this.span = span;
        this.syncFuture = null;
    }

    void loadPayload(SyncFuture syncFuture) {
        this.syncFuture = syncFuture;
        this.entry = null;
        this.span = null;
    }

    boolean hasFSWALEntryPayload() {
        return this.entry != null;
    }

    boolean hasSyncFuturePayload() {
        return this.syncFuture != null;
    }

    FSWALEntry unloadFSWALEntryPayload() {
        FSWALEntry ret = this.entry;
        this.entry = null;
        return ret;
    }

    SyncFuture unloadSyncFuturePayload() {
        SyncFuture ret = this.syncFuture;
        this.syncFuture = null;
        return ret;
    }

    Span unloadSpanPayload() {
        Span ret = this.span;
        this.span = null;
        return ret;
    }
}

