/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hbase.CompatibilitySingletonFactory;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.MetricsRegionWrapper;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.metrics2.MetricsExecutor;
import org.apache.hive.org.apache.commons.math.stat.descriptive.DescriptiveStatistics;

@InterfaceAudience.Private
public class MetricsRegionWrapperImpl
implements MetricsRegionWrapper,
Closeable {
    public static final int PERIOD = 45;
    public static final String UNKNOWN = "unknown";
    private final HRegion region;
    private ScheduledExecutorService executor;
    private Runnable runnable;
    private long numStoreFiles;
    private long memstoreSize;
    private long storeFileSize;
    private Map<String, DescriptiveStatistics> coprocessorTimes;
    private ScheduledFuture<?> regionMetricsUpdateTask;

    public MetricsRegionWrapperImpl(HRegion region) {
        this.region = region;
        this.executor = CompatibilitySingletonFactory.getInstance(MetricsExecutor.class).getExecutor();
        this.runnable = new HRegionMetricsWrapperRunnable();
        this.regionMetricsUpdateTask = this.executor.scheduleWithFixedDelay(this.runnable, 45L, 45L, TimeUnit.SECONDS);
        this.coprocessorTimes = new HashMap<String, DescriptiveStatistics>();
    }

    @Override
    public String getTableName() {
        HTableDescriptor tableDesc = this.region.getTableDesc();
        if (tableDesc == null) {
            return UNKNOWN;
        }
        return tableDesc.getTableName().getQualifierAsString();
    }

    @Override
    public String getNamespace() {
        HTableDescriptor tableDesc = this.region.getTableDesc();
        if (tableDesc == null) {
            return UNKNOWN;
        }
        return tableDesc.getTableName().getNamespaceAsString();
    }

    @Override
    public String getRegionName() {
        HRegionInfo regionInfo = this.region.getRegionInfo();
        if (regionInfo == null) {
            return UNKNOWN;
        }
        return regionInfo.getEncodedName();
    }

    @Override
    public long getNumStores() {
        Map<byte[], Store> stores = this.region.stores;
        if (stores == null) {
            return 0L;
        }
        return stores.size();
    }

    @Override
    public long getNumStoreFiles() {
        return this.numStoreFiles;
    }

    @Override
    public long getMemstoreSize() {
        return this.memstoreSize;
    }

    @Override
    public long getStoreFileSize() {
        return this.storeFileSize;
    }

    @Override
    public long getReadRequestCount() {
        return this.region.getReadRequestsCount();
    }

    @Override
    public long getWriteRequestCount() {
        return this.region.getWriteRequestsCount();
    }

    @Override
    public long getNumFilesCompacted() {
        return this.region.compactionNumFilesCompacted.get();
    }

    @Override
    public long getNumBytesCompacted() {
        return this.region.compactionNumBytesCompacted.get();
    }

    @Override
    public long getNumCompactionsCompleted() {
        return this.region.compactionsFinished.get();
    }

    @Override
    public void close() throws IOException {
        this.regionMetricsUpdateTask.cancel(true);
    }

    @Override
    public Map<String, DescriptiveStatistics> getCoprocessorExecutionStatistics() {
        return this.coprocessorTimes;
    }

    public class HRegionMetricsWrapperRunnable
    implements Runnable {
        @Override
        public void run() {
            long tempNumStoreFiles = 0L;
            long tempMemstoreSize = 0L;
            long tempStoreFileSize = 0L;
            if (((MetricsRegionWrapperImpl)MetricsRegionWrapperImpl.this).region.stores != null) {
                for (Store store : ((MetricsRegionWrapperImpl)MetricsRegionWrapperImpl.this).region.stores.values()) {
                    tempNumStoreFiles += (long)store.getStorefilesCount();
                    tempMemstoreSize += store.getMemStoreSize();
                    tempStoreFileSize += store.getStorefilesSize();
                }
            }
            MetricsRegionWrapperImpl.this.numStoreFiles = tempNumStoreFiles;
            MetricsRegionWrapperImpl.this.memstoreSize = tempMemstoreSize;
            MetricsRegionWrapperImpl.this.storeFileSize = tempStoreFileSize;
            MetricsRegionWrapperImpl.this.coprocessorTimes = MetricsRegionWrapperImpl.this.region.getCoprocessorHost().getCoprocessorExecutionStatistics();
        }
    }
}

