/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.procedure2;

import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.procedure2.RemoteProcedureException;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class ProcedureResult {
    private final RemoteProcedureException exception;
    private final long lastUpdate;
    private final long startTime;
    private final byte[] result;
    private long clientAckTime = -1L;

    public ProcedureResult(long startTime, long lastUpdate, RemoteProcedureException exception) {
        this.lastUpdate = lastUpdate;
        this.startTime = startTime;
        this.exception = exception;
        this.result = null;
    }

    public ProcedureResult(long startTime, long lastUpdate, byte[] result) {
        this.lastUpdate = lastUpdate;
        this.startTime = startTime;
        this.exception = null;
        this.result = result;
    }

    public boolean isFailed() {
        return this.exception != null;
    }

    public RemoteProcedureException getException() {
        return this.exception;
    }

    public boolean hasResultData() {
        return this.result != null;
    }

    public byte[] getResult() {
        return this.result;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getLastUpdate() {
        return this.lastUpdate;
    }

    public long executionTime() {
        return this.lastUpdate - this.startTime;
    }

    public boolean hasClientAckTime() {
        return this.clientAckTime > 0L;
    }

    public long getClientAckTime() {
        return this.clientAckTime;
    }

    @InterfaceAudience.Private
    protected void setClientAckTime(long timestamp) {
        this.clientAckTime = timestamp;
    }
}

