/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.snapshot;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.client.RegionReplicaUtil;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.protobuf.generated.SnapshotProtos;
import org.apache.hadoop.hbase.snapshot.ClientSnapshotDescriptionUtils;
import org.apache.hadoop.hbase.snapshot.CorruptedSnapshotException;
import org.apache.hadoop.hbase.snapshot.SnapshotDescriptionUtils;
import org.apache.hadoop.hbase.snapshot.SnapshotManifest;
import org.apache.hadoop.hbase.snapshot.SnapshotReferenceUtil;
import org.apache.hadoop.hbase.zookeeper.MetaTableLocator;
import org.apache.hive.org.apache.commons.logging.Log;
import org.apache.hive.org.apache.commons.logging.LogFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public final class MasterSnapshotVerifier {
    private static final Log LOG = LogFactory.getLog(MasterSnapshotVerifier.class);
    private HBaseProtos.SnapshotDescription snapshot;
    private FileSystem fs;
    private Path rootDir;
    private TableName tableName;
    private MasterServices services;

    public MasterSnapshotVerifier(MasterServices services, HBaseProtos.SnapshotDescription snapshot, Path rootDir) {
        this.fs = services.getMasterFileSystem().getFileSystem();
        this.services = services;
        this.snapshot = snapshot;
        this.rootDir = rootDir;
        this.tableName = TableName.valueOf(snapshot.getTable());
    }

    public void verifySnapshot(Path snapshotDir, Set<String> snapshotServers) throws CorruptedSnapshotException, IOException {
        SnapshotManifest manifest = SnapshotManifest.open(this.services.getConfiguration(), this.fs, snapshotDir, this.snapshot);
        this.verifySnapshotDescription(snapshotDir);
        this.verifyTableInfo(manifest);
        this.verifyRegions(manifest);
    }

    private void verifySnapshotDescription(Path snapshotDir) throws CorruptedSnapshotException {
        HBaseProtos.SnapshotDescription found = SnapshotDescriptionUtils.readSnapshotInfo(this.fs, snapshotDir);
        if (!this.snapshot.equals(found)) {
            throw new CorruptedSnapshotException("Snapshot read (" + found + ") doesn't equal snapshot we ran (" + this.snapshot + ").", this.snapshot);
        }
    }

    private void verifyTableInfo(SnapshotManifest manifest) throws IOException {
        HTableDescriptor htd = manifest.getTableDescriptor();
        if (htd == null) {
            throw new CorruptedSnapshotException("Missing Table Descriptor", this.snapshot);
        }
        if (!htd.getNameAsString().equals(this.snapshot.getTable())) {
            throw new CorruptedSnapshotException("Invalid Table Descriptor. Expected " + this.snapshot.getTable() + " name, got " + htd.getNameAsString(), this.snapshot);
        }
    }

    private void verifyRegions(SnapshotManifest manifest) throws IOException {
        List<HRegionInfo> regions = TableName.META_TABLE_NAME.equals(this.tableName) ? new MetaTableLocator().getMetaRegions(this.services.getZooKeeper()) : MetaTableAccessor.getTableRegions(this.services.getZooKeeper(), this.services.getConnection(), this.tableName);
        RegionReplicaUtil.removeNonDefaultRegions(regions);
        Map<String, SnapshotProtos.SnapshotRegionManifest> regionManifests = manifest.getRegionManifestsMap();
        if (regionManifests == null) {
            String msg = "Snapshot " + ClientSnapshotDescriptionUtils.toString(this.snapshot) + " looks empty";
            LOG.error(msg);
            throw new CorruptedSnapshotException(msg);
        }
        String errorMsg = "";
        if (regionManifests.size() != regions.size()) {
            errorMsg = "Regions moved during the snapshot '" + ClientSnapshotDescriptionUtils.toString(this.snapshot) + "'. expected=" + regions.size() + " snapshotted=" + regionManifests.size() + ".";
            LOG.error(errorMsg);
        }
        for (HRegionInfo region : regions) {
            SnapshotProtos.SnapshotRegionManifest regionManifest = regionManifests.get(region.getEncodedName());
            if (regionManifest == null) {
                String mesg = " No snapshot region directory found for region:" + region;
                if (errorMsg.isEmpty()) {
                    errorMsg = mesg;
                }
                LOG.error(mesg);
                continue;
            }
            this.verifyRegionInfo(region, regionManifest);
        }
        if (!errorMsg.isEmpty()) {
            throw new CorruptedSnapshotException(errorMsg);
        }
        SnapshotReferenceUtil.verifySnapshot(this.services.getConfiguration(), this.fs, manifest);
    }

    private void verifyRegionInfo(HRegionInfo region, SnapshotProtos.SnapshotRegionManifest manifest) throws IOException {
        HRegionInfo manifestRegionInfo = HRegionInfo.convert(manifest.getRegionInfo());
        if (!region.equals(manifestRegionInfo)) {
            String msg = "Manifest region info " + manifestRegionInfo + "doesn't match expected region:" + region;
            throw new CorruptedSnapshotException(msg, this.snapshot);
        }
    }
}

