/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import org.apache.hadoop.hbase.ipc.MetricsHBaseServerWrapper;
import org.apache.hadoop.hbase.ipc.RpcServer;

public class MetricsHBaseServerWrapperImpl
implements MetricsHBaseServerWrapper {
    private RpcServer server;

    MetricsHBaseServerWrapperImpl(RpcServer server) {
        this.server = server;
    }

    private boolean isServerStarted() {
        return this.server != null && this.server.isStarted();
    }

    @Override
    public long getTotalQueueSize() {
        if (!this.isServerStarted()) {
            return 0L;
        }
        return this.server.callQueueSize.get();
    }

    @Override
    public int getGeneralQueueLength() {
        if (!this.isServerStarted() || this.server.getScheduler() == null) {
            return 0;
        }
        return this.server.getScheduler().getGeneralQueueLength();
    }

    @Override
    public int getReplicationQueueLength() {
        if (!this.isServerStarted() || this.server.getScheduler() == null) {
            return 0;
        }
        return this.server.getScheduler().getReplicationQueueLength();
    }

    @Override
    public int getPriorityQueueLength() {
        if (!this.isServerStarted() || this.server.getScheduler() == null) {
            return 0;
        }
        return this.server.getScheduler().getPriorityQueueLength();
    }

    @Override
    public int getNumOpenConnections() {
        if (!this.isServerStarted() || this.server.connectionList == null) {
            return 0;
        }
        return this.server.connectionList.size();
    }

    @Override
    public int getActiveRpcHandlerCount() {
        if (!this.isServerStarted() || this.server.getScheduler() == null) {
            return 0;
        }
        return this.server.getScheduler().getActiveRpcHandlerCount();
    }
}

