/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hive.org.apache.commons.logging.Log;
import org.apache.hive.org.apache.commons.logging.LogFactory;

public class PrefetchExecutor {
    private static final Log LOG = LogFactory.getLog(PrefetchExecutor.class);
    private static final Map<Path, Future<?>> prefetchFutures = new ConcurrentSkipListMap();
    private static final ScheduledExecutorService prefetchExecutorPool;
    private static final int prefetchDelayMillis;
    private static final float prefetchDelayVariation;
    private static final Random RNG;
    private static final Pattern prefetchPathExclude;

    public static void request(Path path, Runnable runnable) {
        if (!prefetchPathExclude.matcher(path.toString()).find()) {
            long delay = prefetchDelayMillis > 0 ? (long)((float)prefetchDelayMillis * (1.0f - prefetchDelayVariation / 2.0f) + (float)prefetchDelayMillis * (prefetchDelayVariation / 2.0f) * RNG.nextFloat()) : 0L;
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Prefetch requested for " + path + ", delay=" + delay + " ms");
                }
                prefetchFutures.put(path, prefetchExecutorPool.schedule(runnable, delay, TimeUnit.MILLISECONDS));
            }
            catch (RejectedExecutionException e) {
                prefetchFutures.remove(path);
                LOG.warn("Prefetch request rejected for " + path);
            }
        }
    }

    public static void complete(Path path) {
        prefetchFutures.remove(path);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Prefetch completed for " + path);
        }
    }

    public static void cancel(Path path) {
        Future<?> future = prefetchFutures.get(path);
        if (future != null) {
            future.cancel(true);
            prefetchFutures.remove(path);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Prefetch cancelled for " + path);
            }
        }
    }

    public static boolean isCompleted(Path path) {
        Future<?> future = prefetchFutures.get(path);
        if (future != null) {
            return future.isDone();
        }
        return true;
    }

    static {
        Configuration conf = HBaseConfiguration.create();
        prefetchDelayMillis = conf.getInt("hbase.hfile.prefetch.delay", 1000);
        prefetchDelayVariation = conf.getFloat("hbase.hfile.prefetch.delay.variation", 0.2f);
        int prefetchThreads = conf.getInt("hbase.hfile.thread.prefetch", 4);
        prefetchExecutorPool = new ScheduledThreadPoolExecutor(prefetchThreads, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setName("hfile-prefetch-" + System.currentTimeMillis());
                t.setDaemon(true);
                return t;
            }
        });
        RNG = new Random();
        prefetchPathExclude = Pattern.compile("(/" + ".tmp".replace(".", "\\.") + '/' + ")|(" + '/' + "compaction.dir".replace(".", "\\.") + '/' + ")");
    }
}

